/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.embedded;

import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Sniffer;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.internal.embedded.ContainerBuilder;
import org.glassfish.internal.embedded.EmbeddedContainer;
import org.glassfish.internal.embedded.EmbeddedDeployer;
import org.glassfish.internal.embedded.EmbeddedFileSystem;
import org.glassfish.internal.embedded.LifecycleException;
import org.glassfish.internal.embedded.Port;
import org.glassfish.internal.embedded.Ports;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.Inhabitants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Contract
public class Server {
    private static final Map<String, Server> servers = new HashMap<String, Server>();
    private final String serverName;
    private final boolean loggerEnabled;
    private final boolean verbose;
    private final File loggerFile;
    private final int jmxPort;
    private final ContainerStatus status = new ContainerStatus();
    private final Inhabitant<EmbeddedFileSystem> fileSystem;
    private final Habitat habitat;
    private final List<Container> containers = new ArrayList<Container>();
    private final GlassFish glassfish;
    private static GlassFishRuntime glassfishRuntime;
    private static final Logger logger;

    private void setBootstrapProperties(BootstrapProperties props, EmbeddedFileSystem fs) {
        props.setProperty("GlassFish_Platform", "Static");
        if (fs != null) {
            String installRoot;
            String instanceRoot = fs.instanceRoot != null ? fs.instanceRoot.getAbsolutePath() : null;
            String string = installRoot = fs.installRoot != null ? fs.installRoot.getAbsolutePath() : instanceRoot;
            if (installRoot != null) {
                props.setInstallRoot(installRoot);
            }
        }
    }

    private void setGlassFishProperties(GlassFishProperties props, EmbeddedFileSystem fs) {
        props.setProperty("-type", "EMBEDDED");
        if (fs != null) {
            String instanceRoot;
            String string = instanceRoot = fs.instanceRoot != null ? fs.instanceRoot.getAbsolutePath() : null;
            if (instanceRoot != null) {
                props.setInstanceRoot(fs.instanceRoot.getAbsolutePath());
            }
            if (fs.configFile != null) {
                props.setConfigFileURI(fs.configFile.toURI().toString());
            }
            if (fs.autoDelete) {
                props.setProperty("org.glassfish.embeddable.autoDelete", "true");
            }
        }
    }

    private Server(Builder builder, Properties properties) {
        this.serverName = builder.serverName;
        this.loggerEnabled = builder.loggerEnabled;
        this.verbose = builder.verbose;
        this.loggerFile = builder.loggerFile;
        this.jmxPort = builder.jmxPort;
        try {
            if (properties == null) {
                properties = new Properties();
            }
            EmbeddedFileSystem fs = builder.fileSystem;
            BootstrapProperties bootstrapProps = new BootstrapProperties(properties);
            this.setBootstrapProperties(bootstrapProps, fs);
            glassfishRuntime = GlassFishRuntime.bootstrap((BootstrapProperties)bootstrapProps, (ClassLoader)this.getClass().getClassLoader());
            GlassFishProperties gfProps = new GlassFishProperties(properties);
            this.setGlassFishProperties(gfProps, fs);
            this.glassfish = glassfishRuntime.newGlassFish(gfProps);
            this.glassfish.start();
            if (fs == null) {
                EmbeddedFileSystem.Builder fsBuilder = new EmbeddedFileSystem.Builder();
                fsBuilder.autoDelete(true);
                fs = fsBuilder.build();
            }
            this.habitat = (Habitat)this.glassfish.getService(Habitat.class);
            this.habitat.add(Inhabitants.create((Object)this));
            this.fileSystem = new ExistingSingletonInhabitant((Object)fs);
            this.habitat.addIndex(this.fileSystem, EmbeddedFileSystem.class.getName(), null);
            logger.logp(Level.FINER, "Server", "<init>", "Created GlassFish = {0}, GlassFish Status = {1}", new Object[]{this.glassfish, this.glassfish.getStatus()});
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static List<String> getServerNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(servers.keySet());
        return names;
    }

    public static Server getServer(String name) {
        return servers.get(name);
    }

    public ContainerBuilder<EmbeddedContainer> createConfig(ContainerBuilder.Type type2) {
        return this.createConfig(type2.toString());
    }

    public ContainerBuilder<EmbeddedContainer> createConfig(String name) {
        return (ContainerBuilder)this.habitat.getComponent(ContainerBuilder.class, name);
    }

    public <T extends ContainerBuilder<?>> T createConfig(Class<T> configType) {
        return (T)((ContainerBuilder)this.habitat.getComponent(configType));
    }

    public synchronized void addContainer(final ContainerBuilder.Type type2) {
        if (this.status.isStarted()) {
            throw new IllegalStateException("Cannot add container to a started embedded instance");
        }
        this.containers.add(new Container(new EmbeddedContainer(){
            final List<Container> delegates = new ArrayList<Container>();
            final ArrayList<Sniffer> sniffers = new ArrayList();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Sniffer> getSniffers() {
                ArrayList<Sniffer> arrayList = this.sniffers;
                synchronized (arrayList) {
                    if (this.sniffers.isEmpty()) {
                        if (type2 == ContainerBuilder.Type.all) {
                            for (ContainerBuilder.Type t : ContainerBuilder.Type.values()) {
                                if (t == ContainerBuilder.Type.all) continue;
                                this.delegates.add(this.getContainerFor(t));
                            }
                        } else {
                            this.delegates.add(this.getContainerFor(type2));
                        }
                    }
                    for (Container c : this.delegates) {
                        this.sniffers.addAll(c.container.getSniffers());
                    }
                }
                return this.sniffers;
            }

            @Override
            public void bind(Port port, String protocol) {
                for (Container delegate : this.delegates) {
                    delegate.container.bind(port, protocol);
                }
            }

            private Container getContainerFor(final ContainerBuilder.Type type22) {
                ContainerBuilder<EmbeddedContainer> b = Server.this.createConfig(type22);
                if (b != null) {
                    return new Container(b.create(Server.this));
                }
                return new Container(new EmbeddedContainer(){

                    @Override
                    public List<Sniffer> getSniffers() {
                        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
                        Sniffer s = (Sniffer)Server.this.habitat.getComponent(Sniffer.class, type22.toString());
                        if (s != null) {
                            sniffers.add(s);
                        }
                        return sniffers;
                    }

                    @Override
                    public void bind(Port port, String protocol) {
                    }

                    @Override
                    public void start() throws LifecycleException {
                    }

                    @Override
                    public void stop() throws LifecycleException {
                    }
                });
            }

            @Override
            public void start() throws LifecycleException {
                for (Container c : this.delegates) {
                    if (c.started) continue;
                    c.container.start();
                    c.started = true;
                }
            }

            @Override
            public void stop() throws LifecycleException {
                for (Container c : this.delegates) {
                    if (!c.started) continue;
                    c.container.stop();
                    c.started = false;
                }
            }
        }));
    }

    public synchronized <T extends EmbeddedContainer> T addContainer(ContainerBuilder<T> info) {
        if (this.status.isStarted()) {
            throw new IllegalStateException("Cannot add containers to an already started embedded instance");
        }
        T container = info.create(this);
        if (container != null && this.containers.add(new Container((EmbeddedContainer)container))) {
            return container;
        }
        return null;
    }

    public Collection<EmbeddedContainer> getContainers() {
        ArrayList<EmbeddedContainer> copy = new ArrayList<EmbeddedContainer>();
        for (Container c : this.containers) {
            copy.add(c.container);
        }
        return copy;
    }

    public Port createPort(int portNumber) throws IOException {
        Ports ports = (Ports)this.habitat.getComponent(Ports.class);
        return ports.createPort(portNumber);
    }

    public Habitat getHabitat() {
        return this.habitat;
    }

    public String getName() {
        return this.serverName;
    }

    public EmbeddedFileSystem getFileSystem() {
        return (EmbeddedFileSystem)this.fileSystem.get();
    }

    public synchronized void start() throws LifecycleException {
        if (this.glassfish != null) {
            try {
                if (this.glassfish.getStatus() != GlassFish.Status.STARTED) {
                    this.glassfish.start();
                }
            }
            catch (GlassFishException e) {
                throw new LifecycleException(e);
            }
            logger.finer("GlassFish has been started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws LifecycleException {
        try {
            if (this.glassfish != null) {
                this.glassfish.stop();
                logger.finer("GlassFish has been stopped");
            }
            if (glassfishRuntime != null) {
                glassfishRuntime.shutdown();
                logger.finer("GlassFishruntime has been shutdown");
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        finally {
            Map<String, Server> map = servers;
            synchronized (map) {
                servers.remove(this.serverName);
            }
            ((EmbeddedFileSystem)this.fileSystem.get()).preDestroy();
        }
    }

    public EmbeddedDeployer getDeployer() {
        return (EmbeddedDeployer)this.habitat.getByContract(EmbeddedDeployer.class);
    }

    static {
        logger = Logger.getAnonymousLogger();
    }

    private static final class Container {
        private final EmbeddedContainer container;
        boolean started;

        private Container(EmbeddedContainer container) {
            this.container = container;
        }
    }

    private static final class ContainerStatus {
        int status = 0;

        private ContainerStatus() {
        }

        private void started() {
            this.status = 1;
        }

        private void stopped() {
            this.status = 0;
        }

        private boolean isStopped() {
            return this.status == 0;
        }

        private boolean isStarted() {
            return this.status == 1;
        }
    }

    public static class Builder {
        final String serverName;
        boolean loggerEnabled;
        boolean verbose;
        File loggerFile;
        EmbeddedFileSystem fileSystem;
        int jmxPort = 0;

        public Builder(String id) {
            this.serverName = id;
        }

        public Builder logger(boolean enabled) {
            this.loggerEnabled = enabled;
            return this;
        }

        public Builder logFile(File f) {
            this.loggerFile = f;
            return this;
        }

        public Builder verbose(boolean b) {
            this.verbose = b;
            return this;
        }

        public Builder jmxPort(int portNumber) {
            this.jmxPort = portNumber;
            return this;
        }

        public Builder embeddedFileSystem(EmbeddedFileSystem fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        public Server build() {
            return this.build(null);
        }

        public Server build(Properties properties) {
            Map map = servers;
            synchronized (map) {
                if (!servers.containsKey(this.serverName)) {
                    Server s = new Server(this, properties);
                    servers.put(this.serverName, s);
                    return s;
                }
                throw new IllegalStateException("An embedded server of this name already exists");
            }
        }
    }
}

