/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.apache.felix.framework.capabilityset.Attribute;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.CapabilitySet;
import org.apache.felix.framework.capabilityset.Directive;
import org.apache.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.util.StringMap;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class FilterImpl
implements Filter {
    private final SimpleFilter m_filter;

    public FilterImpl(String filterStr) throws InvalidSyntaxException {
        try {
            this.m_filter = SimpleFilter.parse(filterStr);
        }
        catch (Throwable th) {
            throw new InvalidSyntaxException(th.getMessage(), filterStr);
        }
    }

    public boolean match(ServiceReference sr) {
        return CapabilitySet.matches(new ServiceReferenceCapability(sr), this.m_filter);
    }

    public boolean match(Dictionary dctnr) {
        return CapabilitySet.matches(new DictionaryCapability(dctnr, false), this.m_filter);
    }

    public boolean matchCase(Dictionary dctnr) {
        return CapabilitySet.matches(new DictionaryCapability(dctnr, true), this.m_filter);
    }

    public boolean equals(Object o) {
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.m_filter.toString();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ServiceReferenceCapability
    implements Capability {
        private final ServiceReference m_sr;

        public ServiceReferenceCapability(ServiceReference sr) {
            this.m_sr = sr;
        }

        @Override
        public Module getModule() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getNamespace() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Directive getDirective(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<Directive> getDirectives() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Attribute getAttribute(String name) {
            Object value = this.m_sr.getProperty(name);
            return value == null ? null : new Attribute(name, value, false);
        }

        @Override
        public List<Attribute> getAttributes() {
            return new ArrayList<Attribute>();
        }

        @Override
        public List<String> getUses() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DictionaryCapability
    implements Capability {
        private final StringMap m_map;
        private final Dictionary m_dict;

        public DictionaryCapability(Dictionary dict, boolean caseSensitive) {
            this.m_dict = dict;
            if (!caseSensitive) {
                this.m_map = new StringMap(false);
                if (dict != null) {
                    Enumeration keys = dict.keys();
                    while (keys.hasMoreElements()) {
                        Object key = keys.nextElement();
                        if (this.m_map.get(key) == null) {
                            this.m_map.put(key, key);
                            continue;
                        }
                        throw new IllegalArgumentException(new StringBuffer().append("Duplicate attribute: ").append(key.toString()).toString());
                    }
                }
            } else {
                this.m_map = null;
            }
        }

        @Override
        public Module getModule() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getNamespace() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Directive getDirective(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<Directive> getDirectives() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Attribute getAttribute(String name) {
            String key = name;
            Object value = null;
            if (this.m_dict != null) {
                if (this.m_map != null) {
                    key = (String)this.m_map.get(name);
                }
                if (key != null) {
                    value = this.m_dict.get(key);
                }
            }
            return value == null ? null : new Attribute(key, value, false);
        }

        @Override
        public List<Attribute> getAttributes() {
            return new ArrayList<Attribute>();
        }

        @Override
        public List<String> getUses() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

