/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.single;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleDependency;
import com.sun.enterprise.module.ModuleMetadata;
import com.sun.enterprise.module.common_impl.ByteArrayInhabitantsDescriptor;
import com.sun.enterprise.module.single.ManifestProxy;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProxyModuleDefinition
implements ModuleDefinition {
    private final ModuleMetadata metadata = new ModuleMetadata();
    private final Manifest manifest;
    private static final ModuleDependency[] EMPTY_MODULE_DEFINITIONS_ARRAY;
    private static final List<URI> uris;

    public ProxyModuleDefinition(ClassLoader classLoader) throws IOException {
        this(classLoader, null, Collections.singleton("default"));
    }

    public ProxyModuleDefinition(ClassLoader classLoader, List<ManifestProxy.SeparatorMappings> mappings) throws IOException {
        this(classLoader, mappings, Collections.singleton("default"));
    }

    public ProxyModuleDefinition(ClassLoader classLoader, List<ManifestProxy.SeparatorMappings> mappings, Collection<String> habitatNames) throws IOException {
        this.manifest = new ManifestProxy(classLoader, mappings);
        for (String habitatName : habitatNames) {
            Enumeration<URL> inhabitants = classLoader.getResources("META-INF/inhabitants/" + habitatName);
            HashSet<File> processedFiles = new HashSet<File>();
            while (inhabitants.hasMoreElements()) {
                String path;
                File f;
                int index;
                URL url = inhabitants.nextElement();
                if (url.getProtocol().equals("jar") && (index = url.getPath().indexOf("!")) > 0 && url.getPath().length() > 5 && (f = new File(path = url.getPath().substring(5, url.getPath().indexOf("!")))).exists()) {
                    if (processedFiles.contains(f = f.getCanonicalFile())) continue;
                    processedFiles.add(f);
                }
                this.metadata.addHabitat(habitatName, new ByteArrayInhabitantsDescriptor(url, ProxyModuleDefinition.readFully(url)));
            }
        }
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlCL = (URLClassLoader)classLoader;
            for (URL url : urlCL.getURLs()) {
                try {
                    uris.add(url.toURI());
                }
                catch (URISyntaxException e) {
                    Logger.getAnonymousLogger().log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    private static byte[] readFully(URL url) throws IOException {
        FilterInputStream dis = null;
        try {
            URLConnection con = url.openConnection();
            int len = con.getContentLength();
            InputStream in = con.getInputStream();
            dis = new DataInputStream(in);
            byte[] bytes = new byte[len];
            ((DataInputStream)dis).readFully(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (IOException e) {
            IOException x = new IOException("Failed to read " + url);
            x.initCause(e);
            throw x;
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
    }

    @Override
    public String getName() {
        return "Static Module";
    }

    @Override
    public String[] getPublicInterfaces() {
        return new String[0];
    }

    @Override
    public ModuleDependency[] getDependencies() {
        return EMPTY_MODULE_DEFINITIONS_ARRAY;
    }

    @Override
    public URI[] getLocations() {
        return uris.toArray(new URI[uris.size()]);
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public String getImportPolicyClassName() {
        return null;
    }

    @Override
    public String getLifecyclePolicyClassName() {
        return null;
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }

    @Override
    public ModuleMetadata getMetadata() {
        return this.metadata;
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private static boolean ok(String[] ss) {
        return ss != null && ss.length > 0;
    }

    static {
        String[] paths;
        EMPTY_MODULE_DEFINITIONS_ARRAY = new ModuleDependency[0];
        uris = new ArrayList<URI>();
        String cp = System.getProperty("java.class.path");
        if (ProxyModuleDefinition.ok(cp) && ProxyModuleDefinition.ok(paths = cp.split(System.getProperty("path.separator")))) {
            for (int i = 0; i < paths.length; ++i) {
                uris.add(new File(paths[i]).toURI());
            }
        }
    }
}

