/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.util.EarlyLogger;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class AdminRESTConfigUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Configs configs;

    public void postConstruct() {
        for (Config config : this.configs.getConfig()) {
            block7: {
                try {
                    if (config.getAdminListener() == null) {
                        EarlyLogger.add((Level)Level.FINE, (String)String.format("Skipping config %s. No admin listener.", config.getName()));
                    }
                    break block7;
                }
                catch (IllegalStateException ise) {
                    EarlyLogger.add((Level)Level.FINE, (String)String.format("Skipping config %s. getAdminListener threw: %s", config.getName(), ise.getLocalizedMessage()));
                }
                continue;
            }
            Protocols ps = config.getNetworkConfig().getProtocols();
            if (ps == null) continue;
            for (Protocol p : ps.getProtocol()) {
                Http h = p.getHttp();
                if (h == null || !"__asadmin".equals(h.getDefaultVirtualServer())) continue;
                try {
                    ConfigSupport.apply((SingleConfigCode)new HttpConfigCode(), (ConfigBeanProxy)h);
                }
                catch (TransactionFailure tf) {
                    EarlyLogger.add((Level)Level.SEVERE, (String)("Could not upgrade http element for admin console: " + (Object)((Object)tf)));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HttpConfigCode
    implements SingleConfigCode<Http> {
        private HttpConfigCode() {
        }

        public Object run(Http http) throws PropertyVetoException, TransactionFailure {
            http.setEncodedSlashEnabled("true");
            return null;
        }
    }
}

