/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.config.GrizzlyConfigException;
import com.sun.grizzly.config.GrizzlyEmbeddedHttp;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.hk2.component.Holder;
import com.sun.hk2.component.InhabitantsParser;
import com.sun.hk2.component.InhabitantsScanner;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.xml.stream.XMLInputFactory;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final String habitatName = "default";
    private static final String inhabitantPath = "META-INF/inhabitants";

    public static Habitat getHabitat(String fileURL) {
        URL url = Utils.class.getClassLoader().getResource(fileURL);
        if (url == null) {
            try {
                url = new URL(fileURL);
            }
            catch (MalformedURLException e) {
                throw new GrizzlyConfigException(e.getMessage());
            }
        }
        Habitat habitat = null;
        if (url != null) {
            try {
                habitat = Utils.getHabitat(url.openStream());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        return habitat;
    }

    public static Habitat getHabitat(InputStream inputStream) {
        try {
            Habitat habitat = Utils.getNewHabitat();
            ConfigParser parser = new ConfigParser(habitat);
            XMLInputFactory xif = XMLInputFactory.class.getClassLoader() == null ? XMLInputFactory.newInstance() : XMLInputFactory.newInstance(XMLInputFactory.class.getName(), XMLInputFactory.class.getClassLoader());
            DomDocument document = parser.parse(xif.createXMLStreamReader(inputStream));
            habitat.addComponent("document", (Object)document);
            return habitat;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GrizzlyConfigException(e.getMessage(), e);
        }
    }

    public static Habitat getNewHabitat() {
        Enumeration<URL> resources;
        Holder<ClassLoader> holder = new Holder<ClassLoader>(){

            public ClassLoader get() {
                return this.getClass().getClassLoader();
            }
        };
        try {
            resources = Utils.class.getClassLoader().getResources("META-INF/inhabitants/default");
        }
        catch (IOException e) {
            throw new GrizzlyConfigException(e);
        }
        if (resources == null) {
            System.out.println("Cannot find any inhabitant file in the classpath");
            return null;
        }
        Habitat habitat = new Habitat();
        while (resources.hasMoreElements()) {
            InhabitantsScanner scanner;
            URL resource = resources.nextElement();
            try {
                scanner = new InhabitantsScanner(resource.openConnection().getInputStream(), habitatName);
            }
            catch (IOException e) {
                throw new GrizzlyConfigException(e);
            }
            InhabitantsParser inhabitantsParser = new InhabitantsParser(habitat);
            try {
                inhabitantsParser.parse((Iterable)scanner, (Holder)holder);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return habitat;
    }

    public static String composeThreadPoolName(NetworkListener networkListener) {
        return networkListener.getThreadPool() + "-" + networkListener.getPort();
    }

    public static <E> E newInstance(Habitat habitat, Class<E> clazz, String name, String realClassName) {
        boolean isInitialized = false;
        Object instance = habitat.getComponent(clazz, name);
        if (instance == null) {
            try {
                instance = Utils.newInstance(realClassName);
                isInitialized = true;
            }
            catch (Exception e) {}
        } else {
            isInitialized = true;
        }
        if (!isInitialized) {
            GrizzlyEmbeddedHttp.logger().log(Level.WARNING, "Instance could not be initialized. Class={0}, name={1}, realClassName={2}", new Object[]{clazz, name, realClassName});
            return null;
        }
        return (E)instance;
    }

    public static Object newInstance(String classname) throws Exception {
        return Utils.loadClass(classname).newInstance();
    }

    public static Class loadClass(String classname) throws ClassNotFoundException {
        Class<?> clazz = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            try {
                clazz = cl.loadClass(classname);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return clazz == null ? GrizzlyEmbeddedHttp.class.getClassLoader().loadClass(classname) : clazz;
    }
}

