/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.hk2.classmodel.reflect.Member;
import org.glassfish.hk2.classmodel.reflect.MethodModel;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.impl.AnnotatedElementImpl;
import org.glassfish.hk2.classmodel.reflect.impl.MethodModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.TypeProxy;

public class TypeImpl
extends AnnotatedElementImpl
implements Type {
    final TypeProxy<Type> sink;
    final List<MethodModel> methods = new ArrayList<MethodModel>();
    final Set<URI> definingURIs = Collections.synchronizedSet(new HashSet());

    public TypeImpl(String name, TypeProxy<Type> sink) {
        super(name);
        this.sink = sink;
    }

    @Override
    public Collection<URI> getDefiningURIs() {
        return Collections.unmodifiableSet(this.definingURIs);
    }

    void addDefiningURI(URI uri) {
        this.definingURIs.add(uri);
        try {
            this.definingURIs.add(new File(uri).getCanonicalFile().toURI());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean wasDefinedIn(Collection<URI> uris) {
        for (URI uri : uris) {
            if (!this.definingURIs.contains(uri)) continue;
            return true;
        }
        return false;
    }

    void addMethod(MethodModelImpl m) {
        this.methods.add(m);
    }

    @Override
    public Collection<MethodModel> getMethods() {
        return Collections.unmodifiableList(this.methods);
    }

    TypeProxy getProxy() {
        return this.sink;
    }

    @Override
    public Collection<Member> getReferences() {
        return Collections.unmodifiableSet(this.sink.getRefs());
    }

    @Override
    protected void print(StringBuffer sb) {
        super.print(sb);
        sb.append(", subclasses=[");
        for (Type cm : this.sink.getSubTypeRefs()) {
            sb.append(" ").append(cm.getName());
        }
        sb.append("]");
    }
}

