/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.server.logging.FormatterDelegate;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.glassfish.api.branding.Branding;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.ContractProvided;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import sun.security.action.GetPropertyAction;

@Service
@Scoped(value=PerLookup.class)
@ContractProvided(value=Formatter.class)
public class UniformLogFormatter
extends Formatter {
    private HashMap loggerResourceBundleTable;
    private LogManager logManager;
    private Date date = new Date();
    private static String PRODUCTID_CONTEXTID;
    private static final String PRODUCT_VERSION;
    private static final int FINE_LEVEL_INT_VALUE;
    private static boolean LOG_SOURCE_IN_KEY_VALUE;
    private static boolean RECORD_NUMBER_IN_KEY_VALUE;
    private FormatterDelegate _delegate = null;
    private long recordNumber = 0L;
    private static final String LINE_SEPARATOR;
    private static final String RECORD_BEGIN_MARKER = "[#|";
    private static final String RECORD_END_MARKER;
    private static final char FIELD_SEPARATOR = '|';
    public static final char NVPAIR_SEPARATOR = ';';
    public static final char NV_SEPARATOR = '=';
    private static final String RFC_3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final SimpleDateFormat dateFormatter;

    public UniformLogFormatter() {
        this.loggerResourceBundleTable = new HashMap();
        this.logManager = LogManager.getLogManager();
    }

    public UniformLogFormatter(FormatterDelegate delegate) {
        this();
        this._delegate = delegate;
    }

    public void setDelegate(FormatterDelegate delegate) {
        this._delegate = delegate;
    }

    public String format(LogRecord record) {
        return this.uniformLogFormat(record);
    }

    public String formatMessage(LogRecord record) {
        return this.uniformLogFormat(record);
    }

    protected String getProductId() {
        Branding branding = null;
        if (Globals.getDefaultHabitat() != null) {
            branding = (Branding)Globals.getDefaultHabitat().getByContract(Branding.class);
        }
        if (branding == null) {
            return null;
        }
        String version = branding.getAbbreviatedVersion() + branding.getVersionPrefix() + branding.getMajorVersion() + "." + branding.getMinorVersion();
        return version;
    }

    protected void getNameValuePairs(StringBuilder buf, LogRecord record) {
        Object[] parameters = record.getParameters();
        if (parameters == null || parameters.length == 0) {
            return;
        }
        try {
            for (Object obj : parameters) {
                if (obj == null) continue;
                if (obj instanceof Map) {
                    for (Map.Entry entry : ((Map)obj).entrySet()) {
                        buf.append(entry.getKey().toString()).append('=').append(entry.getValue().toString()).append(';');
                    }
                    continue;
                }
                if (!(obj instanceof Collection)) continue;
                for (Map.Entry entry : (Collection)obj) {
                    buf.append(entry.toString()).append(';');
                }
            }
        }
        catch (Exception e) {
            new ErrorManager().error("Error in extracting Name Value Pairs", e, 5);
        }
    }

    private String uniformLogFormat(LogRecord record) {
        try {
            StringBuilder recordBuffer = new StringBuilder(RECORD_BEGIN_MARKER);
            this.date.setTime(record.getMillis());
            recordBuffer.append(dateFormatter.format(this.date));
            recordBuffer.append('|');
            recordBuffer.append(record.getLevel()).append('|');
            recordBuffer.append(this.getProductId()).append('|');
            recordBuffer.append(record.getLoggerName()).append('|');
            recordBuffer.append("_ThreadID").append('=');
            recordBuffer.append(record.getThreadID()).append(';');
            recordBuffer.append("_ThreadName").append('=');
            recordBuffer.append(Thread.currentThread().getName());
            recordBuffer.append(';');
            Level level = record.getLevel();
            if (LOG_SOURCE_IN_KEY_VALUE || level.intValue() <= Level.FINE.intValue()) {
                recordBuffer.append("ClassName").append('=');
                recordBuffer.append(record.getSourceClassName());
                recordBuffer.append(';');
                recordBuffer.append("MethodName").append('=');
                recordBuffer.append(record.getSourceMethodName());
                recordBuffer.append(';');
            }
            if (RECORD_NUMBER_IN_KEY_VALUE) {
                recordBuffer.append("RecordNumber").append('=');
                recordBuffer.append(this.recordNumber++).append(';');
            }
            this.getNameValuePairs(recordBuffer, record);
            if (this._delegate != null) {
                this._delegate.format(recordBuffer, level);
            }
            recordBuffer.append('|');
            String logMessage = record.getMessage();
            if (logMessage == null) {
                logMessage = "The log message is null.";
            }
            if (logMessage.indexOf("{0}") >= 0 && record.getParameters() != null) {
                logMessage = MessageFormat.format(logMessage, record.getParameters());
            } else {
                ResourceBundle rb = this.getResourceBundle(record.getLoggerName());
                if (rb != null) {
                    try {
                        logMessage = MessageFormat.format(rb.getString(logMessage), record.getParameters());
                    }
                    catch (MissingResourceException e) {
                        // empty catch block
                    }
                }
            }
            recordBuffer.append(logMessage);
            if (record.getThrown() != null) {
                recordBuffer.append(LINE_SEPARATOR);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                recordBuffer.append(sw.toString());
            }
            recordBuffer.append(RECORD_END_MARKER);
            return recordBuffer.toString();
        }
        catch (Exception ex) {
            new ErrorManager().error("Error in formatting Logrecord", ex, 5);
            return "";
        }
    }

    private synchronized ResourceBundle getResourceBundle(String loggerName) {
        if (loggerName == null) {
            return null;
        }
        ResourceBundle rb = (ResourceBundle)this.loggerResourceBundleTable.get(loggerName);
        if (rb == null && this.logManager.getLogger(loggerName) != null) {
            rb = this.logManager.getLogger(loggerName).getResourceBundle();
            this.loggerResourceBundleTable.put(loggerName, rb);
        }
        return rb;
    }

    static {
        String recordCount;
        PRODUCTID_CONTEXTID = null;
        PRODUCT_VERSION = Version.getAbbreviatedVersion();
        FINE_LEVEL_INT_VALUE = Level.FINE.intValue();
        LOG_SOURCE_IN_KEY_VALUE = false;
        RECORD_NUMBER_IN_KEY_VALUE = false;
        String logSource = System.getProperty("com.sun.aas.logging.keyvalue.logsource");
        if (logSource != null && logSource.equals("true")) {
            LOG_SOURCE_IN_KEY_VALUE = true;
        }
        if ((recordCount = System.getProperty("com.sun.aas.logging.keyvalue.recordnumber")) != null && recordCount.equals("true")) {
            RECORD_NUMBER_IN_KEY_VALUE = true;
        }
        LINE_SEPARATOR = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        RECORD_END_MARKER = "|#]" + LINE_SEPARATOR + LINE_SEPARATOR;
        dateFormatter = new SimpleDateFormat(RFC_3339_DATE_FORMAT);
    }
}

