/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.util.ExceptionUtil;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.hk2.component.InjectionResolver;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.api.admin.config.Named;
import org.glassfish.common.util.admin.GenericCommandModel;
import org.glassfish.config.support.Create;
import org.glassfish.config.support.CreationDecorator;
import org.glassfish.config.support.CrudResolver;
import org.glassfish.config.support.GenericCrudCommand;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Scoped(value=PerLookup.class)
public class GenericCreateCommand
extends GenericCrudCommand
implements AdminCommand,
PostConstruct,
CommandModelProvider {
    @Inject
    Habitat habitat;
    Class<? extends CrudResolver> resolverType;
    GenericCommandModel model;
    Create create;
    static final Logger logger = LogDomains.getLogger(GenericCreateCommand.class, (String)"javax.enterprise.system.tools.admin");

    public void postConstruct() {
        super.postConstruct();
        this.create = this.getAnnotation(this.targetMethod, Create.class);
        this.resolverType = this.create.resolver();
        try {
            this.model = new GenericCommandModel(this.targetType, true, this.create.cluster(), this.create.i18n(), (LocalStringManager)new LocalStringManagerImpl(this.targetType), (DomDocument)this.habitat.getComponent(DomDocument.class), this.commandName, new Class[]{this.create.resolver(), this.create.decorator()});
            if (logger.isLoggable(this.level)) {
                for (String paramName : this.model.getParametersNames()) {
                    CommandModel.ParamModel param = this.model.getModelFor(paramName);
                    logger.fine("I take " + param.getName() + " parameters");
                }
            }
        }
        catch (Exception e) {
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCreateCommand.command_model_exception", "Exception while creating the command model for the generic command {0} : {1}", new Object[]{this.commandName, e.getMessage()});
            logger.severe(msg);
            throw new ComponentException(msg, (Throwable)e);
        }
    }

    public void execute(final AdminCommandContext context) {
        final ActionReport result = context.getActionReport();
        final InjectionManager manager = new InjectionManager();
        CrudResolver resolver = (CrudResolver)this.habitat.getComponent(this.resolverType);
        final InjectionResolver<Param> paramResolver = this.getInjectionResolver();
        manager.inject((Object)resolver, new InjectionResolver[]{paramResolver});
        Object parentBean = resolver.resolve(context, this.parentType);
        if (parentBean == null) {
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCreateCommand.target_object_not_found", "The CrudResolver {0} could not find the configuration object of type {1} where instances of {2} should be added", new Object[]{resolver.getClass().toString(), this.parentType, this.targetType});
            result.failure(logger, msg);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ConfigBeanProxy>(){

                public Object run(ConfigBeanProxy writableParent) throws PropertyVetoException, TransactionFailure {
                    Object cbp;
                    ConfigBeanProxy childBean = writableParent.createChild(GenericCreateCommand.this.targetType);
                    manager.inject((Object)childBean, GenericCreateCommand.this.targetType, new InjectionResolver[]{GenericCreateCommand.this.getInjectionResolver()});
                    String name = null;
                    if (Named.class.isAssignableFrom(GenericCreateCommand.this.targetType)) {
                        name = ((Named)childBean).getName();
                    }
                    if (name != null && (cbp = GenericCreateCommand.this.habitat.getComponent(GenericCreateCommand.this.targetType.getName(), name)) != null) {
                        String msg = GenericCrudCommand.localStrings.getLocalString(GenericCrudCommand.class, "GenericCreateCommand.already_existing_instance", "A {0} instance with a \"{1}\" name already exist in the configuration", new Object[]{GenericCreateCommand.this.targetType.getSimpleName(), name});
                        result.failure(logger, msg);
                        throw new TransactionFailure(msg);
                    }
                    try {
                        if (GenericCreateCommand.this.targetMethod.getParameterTypes().length == 0) {
                            Object result2 = GenericCreateCommand.this.targetMethod.invoke((Object)writableParent, new Object[0]);
                            if (result2 instanceof List) {
                                List children = (List)List.class.cast(result2);
                                children.add(childBean);
                            }
                        } else {
                            GenericCreateCommand.this.targetMethod.invoke((Object)writableParent, childBean);
                        }
                    }
                    catch (Exception e) {
                        String msg = GenericCrudCommand.localStrings.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.method_invocation_exception", "Exception while invoking {0} method : {1}", new Object[]{GenericCreateCommand.this.targetMethod.toString(), e.toString()});
                        result.failure(logger, msg, (Throwable)e);
                        throw new TransactionFailure(msg, (Throwable)e);
                    }
                    CreationDecorator decorator = (CreationDecorator)GenericCreateCommand.this.habitat.getComponent(GenericCreateCommand.this.create.decorator());
                    if (decorator == null) {
                        String msg = GenericCrudCommand.localStrings.getLocalString(GenericCrudCommand.class, "GenericCreateCommand.decorator_not_found", "The CreationDecorator {0} could not be found in the habitat, is it annotated with @Service ?", new Object[]{GenericCreateCommand.this.create.decorator().toString()});
                        result.failure(logger, msg);
                        throw new TransactionFailure(msg);
                    }
                    manager.inject((Object)decorator, new InjectionResolver[]{paramResolver});
                    decorator.decorate(context, childBean);
                    return childBean;
                }
            }, parentBean);
        }
        catch (TransactionFailure e) {
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCreateCommand.transaction_exception", "Exception while adding the new configuration : {0} ", new Object[]{this.getRootCauseMessage((Exception)((Object)e))});
            result.failure(logger, msg);
        }
    }

    public CommandModel getModel() {
        return this.model;
    }

    private String getRootCauseMessage(Exception e) {
        String msg = ExceptionUtil.getRootCause((Throwable)e).getMessage();
        if (msg != null && msg.length() > 0) {
            return msg;
        }
        return e.getMessage();
    }
}

