/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.Context;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolChainInstruction;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.config.DefaultProxy;
import com.sun.grizzly.config.GrizzlyConfig;
import com.sun.grizzly.config.GrizzlyEmbeddedHttp;
import com.sun.grizzly.config.SSLConfigHolder;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Ssl;
import com.sun.grizzly.filter.SSLReadFilter;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.ssl.SSLAsyncProcessorTask;
import com.sun.grizzly.ssl.SSLAsyncProtocolFilter;
import com.sun.grizzly.ssl.SSLDefaultProtocolFilter;
import com.sun.grizzly.ssl.SSLProcessorTask;
import com.sun.grizzly.ssl.SSLSelectorThreadHandler;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.net.ssl.SSLException;
import org.jvnet.hk2.component.Habitat;

public class GrizzlyEmbeddedHttps
extends GrizzlyEmbeddedHttp {
    private ProtocolFilter lazyInitializationFilter;
    private final AtomicBoolean isSslInitialized = new AtomicBoolean();
    private volatile SSLConfigHolder sslConfigHolder;

    protected ProtocolChainInstanceHandler configureProtocol(NetworkListener networkListener, Protocol protocol, Habitat habitat, boolean mayEnableAsync) {
        if (protocol.getHttp() != null && GrizzlyConfig.toBoolean(protocol.getSecurityEnabled())) {
            Ssl ssl = protocol.getSsl();
            if (ssl == null) {
                ssl = (Ssl)DefaultProxy.createDummyProxy(protocol, Ssl.class);
            }
            try {
                this.sslConfigHolder = new SSLConfigHolder(habitat, ssl);
            }
            catch (SSLException e) {
                throw new IllegalStateException(e);
            }
            if (Boolean.parseBoolean(ssl.getAllowLazyInit())) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Perform lazy SSL initialization for the listener ''{0}''", networkListener.getName());
                }
                this.lazyInitializationFilter = new LazySSLInitializationFilter(ssl);
            } else {
                this.isSslInitialized.set(true);
                if (this.sslConfigHolder.configureSSL()) {
                    this.setHttpSecured(true);
                }
            }
        }
        return super.configureProtocol(networkListener, protocol, habitat, mayEnableAsync);
    }

    protected TCPSelectorHandler createSelectorHandler() {
        return new SSLSelectorThreadHandler(this);
    }

    protected ProtocolFilter createHttpParserFilter() {
        if (this.asyncExecution) {
            return new SSLAsyncProtocolFilter(this.algorithmClass, this.inet, this.port, this.sslConfigHolder.getSSLImplementation());
        }
        return new SSLDefaultProtocolFilter(this.algorithmClass, this.inet, this.port, this.sslConfigHolder.getSSLImplementation());
    }

    protected void configureFilters(ProtocolChain protocolChain) {
        if (this.lazyInitializationFilter != null) {
            protocolChain.addFilter(this.lazyInitializationFilter);
        } else {
            this.doConfigureFilters(protocolChain);
        }
    }

    private void doConfigureFilters(ProtocolChain protocolChain) {
        if (this.portUnificationFilter != null) {
            this.portUnificationFilter.setContinuousExecution(false);
            protocolChain.addFilter((ProtocolFilter)this.portUnificationFilter);
        } else {
            protocolChain.addFilter(this.createReadFilter());
        }
        protocolChain.addFilter(this.createHttpParserFilter());
    }

    protected ProtocolFilter createReadFilter() {
        SSLReadFilter readFilter = new SSLReadFilter();
        readFilter.setSSLContext(this.sslConfigHolder.getSSLContext());
        readFilter.setClientMode(this.sslConfigHolder.isClientMode());
        readFilter.setEnabledCipherSuites(this.sslConfigHolder.getEnabledCipherSuites());
        readFilter.setEnabledProtocols(this.sslConfigHolder.getEnabledProtocols());
        readFilter.setNeedClientAuth(this.sslConfigHolder.isNeedClientAuth());
        readFilter.setWantClientAuth(this.sslConfigHolder.isWantClientAuth());
        readFilter.setSslActivityTimeout(this.sslConfigHolder.getSslInactivityTimeout());
        return readFilter;
    }

    protected ProcessorTask newProcessorTask(boolean initialize) {
        SSLProcessorTask t = this.asyncExecution ? new SSLAsyncProcessorTask(initialize, this.getBufferResponse()) : new SSLProcessorTask(initialize, this.getBufferResponse());
        this.configureProcessorTask(t);
        return t;
    }

    public class LazySSLInitializationFilter
    implements ProtocolFilter {
        private final Ssl ssl;

        public LazySSLInitializationFilter(Ssl ssl) {
            this.ssl = ssl;
        }

        public boolean execute(Context ctx) throws IOException {
            ProtocolChain chain = ctx.getProtocolChain();
            if (!GrizzlyEmbeddedHttps.this.isSslInitialized.getAndSet(true)) {
                GrizzlyEmbeddedHttps.this.sslConfigHolder.configureSSL();
            }
            GrizzlyEmbeddedHttps.this.doConfigureFilters(chain);
            return true;
        }

        public boolean postExecute(Context ctx) throws IOException {
            ProtocolChain chain = ctx.getProtocolChain();
            chain.removeFilter((ProtocolFilter)this);
            ctx.setAttribute("ChainPostInstruction", (Object)ProtocolChainInstruction.REINVOKE);
            return true;
        }
    }
}

