/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.jvnet.hk2.component.ComponentException;

public class UnsatisfiedDependencyException
extends ComponentException {
    final AnnotatedElement member;

    public UnsatisfiedDependencyException(AnnotatedElement target) {
        this(target, null);
    }

    public UnsatisfiedDependencyException(AnnotatedElement target, Throwable cause) {
        super(UnsatisfiedDependencyException.injection_failed_msg(target, cause), cause);
        this.member = target;
    }

    public UnsatisfiedDependencyException(Field target, Throwable cause) {
        super(UnsatisfiedDependencyException.injection_failed_msg(target, cause), cause);
        this.member = target;
    }

    static String injection_failed_msg(AnnotatedElement t, Throwable cause) {
        String msg;
        if (Field.class.isInstance(t)) {
            Field target = (Field)Field.class.cast(t);
            msg = "injection failed on " + target.getDeclaringClass().getCanonicalName() + "." + target.getName() + " with " + target.getGenericType();
        } else {
            msg = "injection failed on " + t;
        }
        return msg;
    }

    public boolean isField() {
        return this.member instanceof Field;
    }

    public boolean isMethod() {
        return this.member instanceof Method;
    }

    public String getUnsatisfiedName() {
        String name;
        String string = name = this.member instanceof Member ? ((Member)((Object)this.member)).getName() : this.member.toString();
        if (this.isMethod()) {
            return name.substring(3).toLowerCase();
        }
        return name;
    }

    public AnnotatedElement getUnsatisfiedElement() {
        try {
            return (AnnotatedElement)AnnotatedElement.class.cast(this.member);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        AnnotatedElement annotated = this.getUnsatisfiedElement();
        if (annotated != null) {
            return annotated.getAnnotation(annotationType);
        }
        return null;
    }
}

