/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.AbstractFileAction;
import com.sun.pkg.client.Action;
import com.sun.pkg.client.FileList;
import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;

public final class FileAction
extends AbstractFileAction
implements FileList.DataSink {
    Fmri fmri;
    String hash;
    int size;
    File gzipfile;

    FileAction(Image image, Fmri f, String[] tokens) {
        super(6, image, tokens);
        this.fmri = f;
        this.hash = tokens[1];
        for (int i = 2; i < tokens.length; ++i) {
            if (!tokens[i].startsWith("pkg.size=")) continue;
            this.size = Integer.parseInt(tokens[i].substring(9));
        }
    }

    public String getHash() {
        return this.hash;
    }

    public int getSize() {
        return this.size;
    }

    public void setGzipFile(File f) {
        this.gzipfile = f;
    }

    void buildFileList(Action orig, FileList flist) {
        flist.add(this);
    }

    void install(Action orig) throws IOException {
        int n;
        if (this.gzipfile == null || this.path == null) {
            return;
        }
        File target = new File(this.img.getRootDirectory(), this.path);
        target.delete();
        target.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(target);
        GZIPInputStream gis = new GZIPInputStream(new FileInputStream(this.gzipfile));
        byte[] buf = new byte[4096];
        while ((n = gis.read(buf)) > 0) {
            fos.write(buf, 0, n);
        }
        fos.close();
        gis.close();
        this.setPermissions(target, this.mode);
    }

    public String toString() {
        return "file: path=" + this.path;
    }

    boolean isDifferent(Action a) {
        if (!(a instanceof FileAction)) {
            return true;
        }
        FileAction fa = (FileAction)a;
        return !this.equals(a) || !this.hash.equals(fa.hash) || !this.owner.equals(fa.owner) || !this.group.equals(fa.group) || !this.mode.equals(fa.mode);
    }
}

