/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.tracing.TracingThreadLocal;
import org.jvnet.hk2.tracing.TracingUtilities;
import sun.misc.BASE64Decoder;

public abstract class AbstractInhabitantImpl<T>
implements Inhabitant<T> {
    private Collection<Inhabitant> companions;

    public String toString() {
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this) + "(" + this.typeName() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T get() {
        try {
            if (TracingUtilities.isEnabled()) {
                TracingThreadLocal.get().push(this);
            }
            Object t = this.get(this);
            return t;
        }
        finally {
            if (TracingUtilities.isEnabled()) {
                TracingThreadLocal.get().pop();
            }
        }
    }

    @Override
    public <T> T getSerializedMetadata(final Class<T> type, String key) {
        String v = this.metadata().getOne(key);
        if (v == null) {
            return null;
        }
        try {
            ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(new BASE64Decoder().decodeBuffer(v))){
                final ClassLoader cl;
                {
                    super(x0);
                    this.cl = type.getClassLoader();
                }

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String name = desc.getName();
                    try {
                        return Class.forName(name, false, this.cl);
                    }
                    catch (ClassNotFoundException ex) {
                        return super.resolveClass(desc);
                    }
                }
            };
            return type.cast(is.readObject());
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    @Override
    public final <T> T getSerializedMetadata(Class<T> type) {
        return this.getSerializedMetadata(type, type.getName());
    }

    @Override
    public Inhabitant lead() {
        return null;
    }

    @Override
    public final Collection<Inhabitant> companions() {
        if (this.companions == null) {
            return Collections.emptyList();
        }
        return this.companions;
    }

    @Override
    public final void setCompanions(Collection<Inhabitant> companions) {
        this.companions = companions;
    }

    public <V extends Annotation> V getAnnotation(Class<V> annotation) {
        return AbstractInhabitantImpl.getAnnotation(this.type(), annotation, false);
    }

    public static <V extends Annotation> V getAnnotation(Class<?> annotated, Class<V> annotation, boolean walkParentChain) {
        V v = annotated.getAnnotation(annotation);
        if (null != v) {
            return v;
        }
        for (Annotation a : annotated.getAnnotations()) {
            v = a.annotationType().getAnnotation(annotation);
            if (null == v) continue;
            return v;
        }
        if (walkParentChain && null != (annotated = annotated.getSuperclass())) {
            return AbstractInhabitantImpl.getAnnotation(annotated, annotation, true);
        }
        return null;
    }
}

