/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.AbstractInhabitantImpl;
import com.sun.hk2.component.AbstractInhabitantProvider;
import com.sun.hk2.component.InhabitantStore;
import com.sun.hk2.component.RunLevelInhabitant;
import java.util.Iterator;
import java.util.Set;
import org.jvnet.hk2.annotations.RunLevel;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.InhabitantListener;
import org.jvnet.hk2.component.InhabitantProviderInterceptor;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.RunLevelService;
import org.jvnet.hk2.component.internal.runlevel.RunLevelServices;

public class RunLevelInhabitantProvider
extends AbstractInhabitantProvider {
    private static final RunLevelServices runLevelServices = new RunLevelServices();
    private final Habitat habitat;

    public RunLevelInhabitantProvider(Habitat h) {
        this.habitat = h;
    }

    @Override
    public AbstractInhabitantImpl<?> visit(AbstractInhabitantImpl<?> i, String typeName, Set<String> indicies, Iterator<InhabitantProviderInterceptor> remainingInterceptors, InhabitantStore store) {
        if (RunLevelInhabitantProvider.contains(indicies, RunLevel.class.getName())) {
            assert (!i.isInstantiated()) : "inhabitant should not be active yet: " + i;
            MultiMap<String, String> md = i.metadata();
            String runLevelStr = md.getOne("runLevel");
            assert (null != runLevelStr) : "expected a runLevel value on " + i;
            String envStr = i.metadata().getOne("env");
            assert (null != envStr) : "expected a env value on " + i;
            int runLevel = Integer.valueOf(runLevelStr);
            RunLevelService<?> rls = runLevelServices.get(this.habitat, runLevel, envStr);
            InhabitantListener listener = InhabitantListener.class.isInstance(rls) ? (InhabitantListener)InhabitantListener.class.cast(rls) : null;
            i = new RunLevelInhabitant(i, runLevel, rls.getState(), listener);
        }
        InhabitantProviderInterceptor next = remainingInterceptors.hasNext() ? remainingInterceptors.next() : null;
        return null == next ? i : next.visit(i, typeName, indicies, remainingInterceptors, store);
    }
}

