/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.ArgumentTokenizer;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.InvalidCommandException;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="multimode")
@Scoped(value=PerLookup.class)
public class MultimodeCommand
extends CLICommand {
    @Inject
    private Habitat habitat;
    @Param(optional=true, shortName="f")
    private File file;
    @Param(name="printprompt", optional=true)
    private Boolean printPromptOpt;
    private boolean printPrompt;
    @Param(optional=true)
    private String encoding;
    private boolean echo;
    private static final LocalStringsImpl strings = new LocalStringsImpl(MultimodeCommand.class);

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        this.printPrompt = this.printPromptOpt != null ? this.printPromptOpt.booleanValue() : this.programOpts.isInteractive();
        this.echo = this.programOpts.isEcho();
    }

    @Override
    protected Collection<CommandModel.ParamModel> usageOptions() {
        Collection opts = this.commandModel.getParameters();
        LinkedHashSet<CommandModel.ParamModel> uopts = new LinkedHashSet<CommandModel.ParamModel>();
        CommandModelData.ParamModelData p = new CommandModelData.ParamModelData("printprompt", Boolean.TYPE, true, Boolean.toString(this.programOpts.isInteractive()));
        for (CommandModel.ParamModel pm : opts) {
            if (pm.getName().equals("printprompt")) {
                uopts.add((CommandModel.ParamModel)p);
                continue;
            }
            uopts.add(pm);
        }
        return uopts;
    }

    @Override
    protected int executeCommand() throws CommandException, CommandValidationException {
        BufferedReader reader = null;
        this.programOpts.setEcho(this.echo);
        try {
            if (this.file == null) {
                System.out.println(strings.get("multimodeIntro"));
                if (this.encoding != null) {
                    reader = new BufferedReader(new InputStreamReader(System.in, this.encoding));
                }
                reader = new BufferedReader(new InputStreamReader(System.in));
            } else {
                this.printPrompt = false;
                if (!this.file.canRead()) {
                    throw new CommandException("File: " + this.file + " can not be read");
                }
                reader = this.encoding != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding)) : new BufferedReader(new FileReader(this.file));
            }
            int n = this.executeCommands(reader);
            return n;
        }
        catch (IOException e) {
            throw new CommandException((Throwable)e);
        }
        finally {
            try {
                if (this.file != null && reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeCommands(BufferedReader reader) throws CommandException, CommandValidationException, IOException {
        String line = null;
        int rc = 0;
        this.programOpts.toEnvironment(this.env);
        while (true) {
            String command;
            if (this.printPrompt) {
                System.out.print("asadmin> ");
                System.out.flush();
            }
            if ((line = reader.readLine()) == null) {
                if (!this.printPrompt) break;
                System.out.println();
                break;
            }
            if (line.trim().startsWith("#")) continue;
            String[] args = null;
            try {
                args = this.getArgs(line);
            }
            catch (ArgumentTokenizer.ArgumentException ex) {
                logger.info(ex.getMessage());
                continue;
            }
            if (args.length == 0 || (command = args[0]).length() == 0) continue;
            if (command.equals("exit") || command.equals("quit")) break;
            CLICommand cmd = null;
            ProgramOptions po = null;
            try {
                po = new ProgramOptions(this.env);
                po.setClassPath(this.programOpts.getClassPath());
                po.setClassName(this.programOpts.getClassName());
                this.habitat.remove(this.habitat.getInhabitantByType(ProgramOptions.class));
                this.habitat.addComponent("program-options", (Object)po);
                cmd = CLICommand.getCommand(this.habitat, command);
                rc = cmd.execute(args);
            }
            catch (CommandValidationException cve) {
                logger.severe(cve.getMessage());
                logger.severe(cmd.getUsage());
                rc = 1;
            }
            catch (InvalidCommandException ice) {
                logger.severe(ice.getMessage());
                try {
                    CLIUtil.displayClosestMatch(command, CLIUtil.getAllCommands(this.habitat, po, this.env), strings.get("ClosestMatchedLocalAndRemoteCommands"));
                }
                catch (InvalidCommandException e) {
                    // empty catch block
                }
            }
            catch (CommandException ce) {
                if (ce.getCause() instanceof ConnectException) {
                    logger.severe(ce.getMessage());
                    try {
                        CLIUtil.displayClosestMatch(command, CLIUtil.getLocalCommands(this.habitat), strings.get("ClosestMatchedLocalCommands"));
                    }
                    catch (InvalidCommandException e) {
                        logger.info(strings.get("InvalidRemoteCommand", new Object[]{command}));
                    }
                } else {
                    logger.severe(ce.getMessage());
                }
                rc = 1;
            }
            finally {
                this.habitat.remove(this.habitat.getInhabitantByType(ProgramOptions.class));
                this.habitat.addComponent("program-options", (Object)this.programOpts);
            }
            switch (rc) {
                case 0: {
                    if (this.programOpts.isTerse()) break;
                    logger.fine(strings.get("CommandSuccessful", new Object[]{command}));
                    break;
                }
                default: {
                    logger.fine(strings.get("CommandUnSuccessful", new Object[]{command}));
                }
            }
            CLIUtil.writeCommandToDebugLog(args, rc);
        }
        return rc;
    }

    private String[] getArgs(String line) throws ArgumentTokenizer.ArgumentException {
        ArrayList<String> args = new ArrayList<String>();
        ArgumentTokenizer t = new ArgumentTokenizer(line);
        while (t.hasMoreTokens()) {
            args.add(t.nextToken());
        }
        return args.toArray(new String[args.size()]);
    }
}

