/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jps {
    private Map<Integer, String> pidMap = new HashMap<Integer, String>();
    private static final File jpsExe;
    private static final String jpsName;

    public static void main(String[] args) {
        Set<Map.Entry<Integer, String>> set = Jps.getProcessTable().entrySet();
        System.out.println("** Got " + set.size() + " process entries");
        for (Map.Entry<Integer, String> e : set) {
            System.out.printf("%d %s\n", e.getKey(), e.getValue());
        }
        if (args.length > 0) {
            System.out.printf("Jps.isPid(%s) ==> %b\n", args[0], Jps.isPid(Integer.parseInt(args[0])));
        }
    }

    public static final Map<Integer, String> getProcessTable() {
        return new Jps().pidMap;
    }

    public static final List<Integer> getPid(String mainClassName) {
        if (mainClassName == null) {
            return Collections.emptyList();
        }
        String plainName = Jps.plainClassName(mainClassName);
        Jps jps = new Jps();
        LinkedList<Integer> ints = new LinkedList<Integer>();
        Set<Map.Entry<Integer, String>> set = jps.pidMap.entrySet();
        for (Map.Entry<Integer, String> entry : set) {
            String valueFull = entry.getValue();
            String valuePlain = Jps.plainClassName(valueFull);
            if (!mainClassName.equals(valueFull) && !plainName.equals(valuePlain)) continue;
            ints.add(entry.getKey());
        }
        return ints;
    }

    public static final boolean isPid(int apid) {
        return new Jps().pidMap.containsKey(apid);
    }

    private Jps() {
        try {
            String[] ss;
            if (jpsExe == null) {
                return;
            }
            ProcessManager pm = new ProcessManager(jpsExe.getPath(), "-l");
            pm.setEcho(false);
            pm.execute();
            String jpsOutput = pm.getStdout();
            for (String line : ss = jpsOutput.split("[\n\r]")) {
                String[] sublines;
                if (line == null || line.length() <= 0 || (sublines = line.split(" ")) == null || sublines.length != 2) continue;
                int aPid = 0;
                try {
                    aPid = Integer.parseInt(sublines[0]);
                }
                catch (Exception e) {
                    continue;
                }
                if (this.isJps(sublines[1])) continue;
                this.pidMap.put(aPid, sublines[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isJps(String id) {
        if (!StringUtils.ok(id)) {
            return false;
        }
        if (id.equals(this.getClass().getName())) {
            return true;
        }
        return id.equals("sun.tools.jps.Jps");
    }

    private static String plainClassName(String s) {
        if (s == null || !s.contains(".") || s.endsWith(".")) {
            return s;
        }
        return s.substring(s.lastIndexOf(46) + 1);
    }

    static {
        jpsName = OS.isWindows() ? "jps.exe" : "jps";
        String javaroot = System.getProperty("java.home");
        String relpath = "/bin/" + jpsName;
        File fhere = new File(javaroot + relpath);
        File fthere = new File(javaroot + "/.." + relpath);
        jpsExe = fhere.isFile() ? SmartFile.sanitize(fhere) : (fthere.isFile() ? SmartFile.sanitize(fthere) : null);
    }
}

