/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.Image;
import com.sun.pkg.client.ImagePlanProgressTracker;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

class FileList {
    Image img;
    Fmri fmri;
    Map<String, List<DataSink>> flist = new HashMap<String, List<DataSink>>();
    File download_dir;

    public FileList(Image i, Fmri f) {
        this.img = i;
        this.fmri = f;
        this.download_dir = new File(new File(this.img.getMetaDirectory(), "download"), FileList.getPID());
    }

    public void add(DataSink a) {
        String h = a.getHash();
        List<DataSink> l = this.flist.get(h);
        if (l == null) {
            l = new ArrayList<DataSink>();
            this.flist.put(h, l);
        }
        l.add(a);
    }

    public long computeTransferSize() {
        long total = 0L;
        for (List<DataSink> ds : this.flist.values()) {
            total += (long)ds.get(0).getSize();
        }
        return total;
    }

    public int computeTransferFiles() {
        return this.flist.size();
    }

    public void download(ImagePlanProgressTracker tracker) throws IOException {
        if (this.flist.isEmpty()) {
            return;
        }
        this.download_dir.mkdirs();
        int nfile = 0;
        byte[] buf = new byte[32768];
        this.img.getLogger().log(Level.FINE, "downloadfiles", new Object[]{this.fmri, this.flist.size()});
        tracker.startPackageDownload(this.fmri, this.flist.size(), this.computeTransferSize());
        for (String hash : this.flist.keySet()) {
            int numRead;
            String hv = URLEncoder.encode(hash, "UTF-8");
            HttpURLConnection uc = this.img.getRepositoryURLConnection("file/0/" + hv, this.fmri);
            this.img.checkRepositoryConnection(uc);
            BufferedInputStream tis = new BufferedInputStream(uc.getInputStream());
            DataSink fa = this.flist.get(hash).get(0);
            List<DataSink> fal = this.flist.get(hash);
            String outfilename = hash;
            this.img.getLogger().log(Level.FINER, "downloading", outfilename);
            tracker.startFileDownload(nfile, fa.getSize());
            File gzipfile = new File(this.download_dir, outfilename);
            fa.setGzipFile(gzipfile);
            FileOutputStream fos = new FileOutputStream(gzipfile);
            long xferedBytes = 0L;
            while ((numRead = tis.read(buf, 0, buf.length)) != -1) {
                ((OutputStream)fos).write(buf, 0, numRead);
                tracker.onFileDownloadProgress(nfile, xferedBytes += (long)numRead);
            }
            tracker.onFileDownloadProgress(nfile, xferedBytes);
            ((OutputStream)fos).close();
            tracker.endFileDownload(nfile++, fa.getSize());
            for (int j = 1; j < fal.size(); ++j) {
                DataSink nfa = fal.get(j);
                nfa.setGzipFile(gzipfile);
            }
        }
        tracker.endPackageDownload(this.fmri, this.flist.size());
    }

    public void cleanupDownload() throws IOException {
        this.img.getLogger().log(Level.FINEST, "deletingtemp");
        File[] files = this.download_dir.listFiles();
        if (files != null && files.length > 0) {
            for (File f : files) {
                f.delete();
            }
        }
        if (this.download_dir.exists()) {
            this.download_dir.delete();
        }
    }

    static String getPID() {
        int i;
        String name = ManagementFactory.getRuntimeMXBean().getName();
        for (i = 0; i < name.length() && Character.isDigit(name.charAt(i)); ++i) {
        }
        return i > 0 ? name.substring(0, i) : "0";
    }

    static interface DataSink {
        public String getHash();

        public int getSize();

        public void setGzipFile(File var1);
    }
}

