/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.StringEditDistance;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.InvalidCommandException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.Inhabitants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLIUtil {
    private static final int MAX_COMMANDS_TO_DISPLAY = 75;
    private static final LocalStringsImpl strings = new LocalStringsImpl(CLIUtil.class);

    public static Map<String, String> readPasswordFileOptions(String passwordFileName, boolean withPrefix) throws CommandException {
        HashMap<String, String> passwordOptions = new HashMap<String, String>();
        boolean readStdin = passwordFileName.equals("-");
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(readStdin ? System.in : new FileInputStream(passwordFileName));
            Properties prop = new Properties();
            prop.load(is);
            for (Object key : prop.keySet()) {
                String entry = (String)key;
                if (!entry.startsWith("AS_ADMIN_")) continue;
                String optionName = withPrefix ? entry : entry.substring("AS_ADMIN_".length()).toLowerCase(Locale.ENGLISH);
                String optionValue = prop.getProperty(entry);
                passwordOptions.put(optionName, optionValue);
            }
        }
        catch (Exception e) {
            throw new CommandException((Throwable)e);
        }
        finally {
            try {
                if (!readStdin && is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception ignore) {}
        }
        return passwordOptions;
    }

    public static void displayClosestMatch(String commandName, String[] commands, String msg) throws InvalidCommandException {
        block9: {
            try {
                String trimmedCommandName;
                int beginIndex = 0;
                int endIndex = commandName.length();
                if (commandName.startsWith("*")) {
                    beginIndex = 1;
                }
                if (commandName.endsWith("*")) {
                    endIndex = commandName.length() - 1;
                }
                if (!(trimmedCommandName = commandName.substring(beginIndex, endIndex)).startsWith("_")) {
                    ArrayList<String> ncl = new ArrayList<String>();
                    for (String cmd : Arrays.asList(commands)) {
                        if (cmd.startsWith("_")) continue;
                        ncl.add(cmd);
                    }
                    commands = ncl.toArray(new String[ncl.size()]);
                }
                Arrays.sort(commands);
                String[] matchedCommands = CLIUtil.getMatchedCommands(trimmedCommandName, commands);
                if (matchedCommands.length > 0 && matchedCommands.length < 75) {
                    System.out.println(msg != null ? msg : strings.get("ClosestMatchedCommands"));
                    for (String eachCommand : matchedCommands) {
                        System.out.println("    " + eachCommand);
                    }
                    break block9;
                }
                String nearestString = StringEditDistance.findNearest(trimmedCommandName, commands);
                if (StringEditDistance.editDistance(trimmedCommandName, nearestString) < 5) {
                    System.out.println(msg != null ? msg : strings.get("ClosestMatchedCommands"));
                    System.out.println("    " + nearestString);
                    break block9;
                }
                throw new InvalidCommandException(commandName);
            }
            catch (Exception e) {
                throw new InvalidCommandException(commandName);
            }
        }
    }

    private static String[] getMatchedCommands(String pattern, String[] commands) {
        ArrayList<String> matchedCommands = new ArrayList<String>();
        for (int i = 0; i < commands.length; ++i) {
            if (commands[i].indexOf(pattern) < 0) continue;
            matchedCommands.add(commands[i]);
        }
        return matchedCommands.toArray(new String[matchedCommands.size()]);
    }

    public static String[] getAllCommands(Habitat habitat, ProgramOptions po, Environment env) {
        try {
            String[] remoteCommands = CLIUtil.getRemoteCommands(habitat, po, env);
            String[] localCommands = CLIUtil.getLocalCommands(habitat);
            Object[] allCommands = new String[localCommands.length + remoteCommands.length];
            System.arraycopy(localCommands, 0, allCommands, 0, localCommands.length);
            System.arraycopy(remoteCommands, 0, allCommands, localCommands.length, remoteCommands.length);
            Arrays.sort(allCommands);
            return allCommands;
        }
        catch (CommandValidationException cve) {
            return null;
        }
        catch (CommandException ce) {
            return null;
        }
    }

    public static String[] getLocalCommands(Habitat habitat) {
        ArrayList<String> names = new ArrayList<String>();
        String cname = CLICommand.class.getName();
        for (Inhabitant command : habitat.getInhabitantsByContract(cname)) {
            for (String name : Inhabitants.getNamesFor((Inhabitant)command, (String)cname)) {
                names.add(name);
            }
        }
        Object[] localCommands = names.toArray(new String[names.size()]);
        Arrays.sort(localCommands);
        return localCommands;
    }

    public static String[] getRemoteCommands(Habitat habitat, ProgramOptions po, Environment env) throws CommandException, CommandValidationException {
        HashSet<String> localnames = new HashSet<String>();
        String cname = CLICommand.class.getName();
        for (Inhabitant command : habitat.getInhabitantsByContract(cname)) {
            for (String name : Inhabitants.getNamesFor((Inhabitant)command, (String)cname)) {
                localnames.add(name);
            }
        }
        RemoteCommand cmd = new RemoteCommand("list-commands", po, env);
        String cmds = cmd.executeAndReturnOutput("list-commands");
        ArrayList<String> rcmds = new ArrayList<String>();
        BufferedReader r = new BufferedReader(new StringReader(cmds));
        try {
            String line;
            while ((line = r.readLine()) != null) {
                String s;
                int i;
                if (!line.startsWith("Command") || (i = line.indexOf(58)) < 0 || localnames.contains(s = line.substring(i + 1).trim())) continue;
                rcmds.add(s);
            }
        }
        catch (IOException ioex) {
            // empty catch block
        }
        Collections.sort(rcmds);
        Object[] remoteCommands = rcmds.toArray(new String[rcmds.size()]);
        Arrays.sort(remoteCommands);
        return remoteCommands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCommandToDebugLog(String[] args, int exit) {
        File log = CLIUtil.getDebugLogfile();
        if (log == null) {
            return;
        }
        Writer out = null;
        try {
            out = new BufferedWriter(new FileWriter(log, true));
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            Date date = new Date();
            out.write(dateFormat.format(date));
            out.write(" EXIT: " + exit);
            out.write(" asadmin ");
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    out.write(args[i] + " ");
                }
            }
        }
        catch (IOException e) {
        }
        finally {
            if (out != null) {
                try {
                    out.write("\n");
                }
                catch (Exception e) {}
                try {
                    ((BufferedWriter)out).close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static File getDebugLogfile() {
        String fname = System.getProperty("AS_LOGFILE");
        if (fname == null) {
            fname = System.getenv("AS_LOGFILE");
        }
        if (fname == null) {
            return null;
        }
        File f = new File(fname);
        try {
            if ((f.exists() || f.createNewFile()) && f.isFile() && f.canWrite()) {
                return f;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

