/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.ServerDirs;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.admin.CommandException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartServerHelper {
    private final boolean terse;
    private final GFLauncher launcher;
    private final Logger logger;
    private final File pidFile;
    private final GFLauncherInfo info;
    private final List<HostAndPort> addresses;
    private final ServerDirs serverDirs;
    private final String masterPassword;
    private final String serverOrDomainName;
    private final boolean debug;
    private final int debugPort;
    private final boolean isDebugSuspend;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StartServerHelper.class);

    public StartServerHelper(Logger logger0, boolean terse0, ServerDirs serverDirs0, GFLauncher launcher0, String masterPassword0, boolean debug0) {
        this.logger = logger0;
        this.terse = terse0;
        this.launcher = launcher0;
        this.info = this.launcher.getInfo();
        this.serverOrDomainName = this.info.isDomain() ? this.info.getDomainName() : this.info.getInstanceName();
        this.addresses = this.info.getAdminAddresses();
        this.serverDirs = serverDirs0;
        this.pidFile = this.serverDirs.getPidFile();
        this.masterPassword = masterPassword0;
        this.debug = debug0;
        this.debugPort = this.launcher.getDebugPort();
        this.isDebugSuspend = this.launcher.isDebugSuspend();
        if (this.isDebugSuspend && this.debugPort >= 0) {
            this.logger.info(strings.get("ServerStart.DebuggerSuspendedMessage", new Object[]{"" + this.debugPort}));
        }
    }

    public void waitForServer() throws CommandException {
        long startWait = System.currentTimeMillis();
        if (!this.terse) {
            System.out.print(strings.get("WaitServer", new Object[]{this.serverOrDomainName}) + " ");
        }
        boolean alive = false;
        int count = 0;
        block5: while (!this.timedOut(startWait)) {
            if (this.pidFile != null) {
                this.logger.finer("Check for pid file: " + this.pidFile);
                if (this.pidFile.exists()) {
                    alive = true;
                    break;
                }
            } else {
                for (HostAndPort addr : this.addresses) {
                    if (!NetUtils.isRunning((String)addr.getHost(), (int)addr.getPort())) continue;
                    alive = true;
                    break block5;
                }
            }
            try {
                Process p = this.launcher.getProcess();
                int exitCode = p.exitValue();
                String sname = this.info.isDomain() ? "domain " + this.info.getDomainName() : "instance " + this.info.getInstanceName();
                ProcessStreamDrainer psd = this.launcher.getProcessStreamDrainer();
                String output = psd.getOutErrString();
                if (StringUtils.ok((String)output)) {
                    throw new CommandException(strings.get("serverDiedOutput", new Object[]{sname, exitCode, output}));
                }
                throw new CommandException(strings.get("serverDied", new Object[]{sname, exitCode}));
            }
            catch (GFLauncherException ex) {
            }
            catch (IllegalThreadStateException ex) {
                // empty catch block
            }
            try {
                Thread.sleep(100L);
                if (this.terse || count++ % 10 != 0) continue;
                System.out.print(".");
            }
            catch (InterruptedException ex) {}
        }
        if (!this.terse) {
            System.out.println();
        }
        if (!alive) {
            String time = "600";
            String msg = this.info.isDomain() ? strings.get("serverNoStart", new Object[]{strings.get("DAS"), this.info.getDomainName(), time}) : strings.get("serverNoStart", new Object[]{strings.get("INSTANCE"), this.info.getInstanceName(), time});
            throw new CommandException(msg);
        }
    }

    public boolean prepareForLaunch() throws CommandException {
        this.waitForParentToDie();
        this.setSecurity();
        if (!this.checkPorts()) {
            return false;
        }
        this.deletePidFile();
        return true;
    }

    public void report() {
        String logfile;
        try {
            logfile = this.launcher.getLogFilename();
        }
        catch (GFLauncherException ex) {
            logfile = "UNKNOWN";
        }
        int adminPort = -1;
        String adminPortString = "-1";
        try {
            if (this.addresses != null && this.addresses.size() > 0) {
                adminPort = this.addresses.get(0).getPort();
            }
            adminPortString = "" + adminPort;
        }
        catch (Exception e) {
            // empty catch block
        }
        this.logger.info(strings.get("ServerStart.SuccessMessage", new Object[]{this.info.isDomain() ? "domain " : "instance", this.serverDirs.getServerName(), this.serverDirs.getServerDir(), logfile, adminPortString}));
        if (this.debugPort >= 0) {
            this.logger.info(strings.get("ServerStart.DebuggerMessage", new Object[]{"" + this.debugPort}));
        }
    }

    private void waitForParentToDie() throws CommandException {
        if (Boolean.getBoolean("AS_RESTART")) {
            new ParentDeathWaiter();
        }
    }

    private boolean checkPorts() {
        String err = this.adminPortInUse();
        if (err != null) {
            this.logger.warning(err);
            return false;
        }
        return true;
    }

    private void deletePidFile() {
        String msg = this.serverDirs.deletePidFile();
        if (msg != null) {
            this.logger.finer(msg);
        }
    }

    private void setSecurity() {
        this.info.addSecurityToken("AS_ADMIN_MASTERPASSWORD", this.masterPassword);
    }

    private String adminPortInUse() {
        return this.adminPortInUse(this.info.getAdminAddresses());
    }

    private String adminPortInUse(List<HostAndPort> adminAddresses) {
        for (HostAndPort addr : adminAddresses) {
            if (NetUtils.isPortFree((String)addr.getHost(), (int)addr.getPort())) continue;
            return strings.get("ServerRunning", new Object[]{Integer.toString(addr.getPort())});
        }
        return null;
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 600000L;
    }

    private class ParentDeathWaiter
    implements Runnable {
        boolean success = false;

        public void run() {
            try {
                while (System.in.read() >= 0) {
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            while (StartServerHelper.this.adminPortInUse(StartServerHelper.this.addresses) != null) {
            }
            if (OS.isWindows()) {
                try {
                    int msec = 10000;
                    Thread.sleep(msec);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.success = true;
        }

        private ParentDeathWaiter() throws CommandException {
            try {
                Thread t = new Thread(this);
                t.start();
                t.join(60000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.success) {
                throw new CommandException(strings.get("deathwait_timeout", new Object[]{60000}));
            }
        }
    }
}

