/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.EventPublishingInhabitant;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.PreDestroy;

public class ReferenceCountedLazyInhabitant<T>
extends EventPublishingInhabitant<T> {
    private volatile T object;
    private volatile Inhabitant<?> onBehalfOf;
    private final AtomicInteger refCount;

    public ReferenceCountedLazyInhabitant(Inhabitant<?> delegate) {
        this(delegate, 0);
    }

    public ReferenceCountedLazyInhabitant(Inhabitant<?> delegate, int startingRefCount) {
        super(delegate);
        this.refCount = new AtomicInteger(startingRefCount);
    }

    int getRefCount() {
        return this.refCount.get();
    }

    @Override
    public T get(Inhabitant onBehalfOf) {
        T object = this.object;
        int val = this.refCount.incrementAndGet();
        if (1 == val || null == this.onBehalfOf) {
            try {
                object = this.object = super.get(onBehalfOf);
            }
            catch (RuntimeException e) {
                logger.log(Level.FINE, "error encountered", new ComponentException(e));
                this.refCount.decrementAndGet();
                throw e;
            }
            this.onBehalfOf = onBehalfOf;
        }
        assert (onBehalfOf == this.onBehalfOf) : "wrong onBehalfOf context";
        return object;
    }

    @Override
    public void release() {
        int val = this.refCount.decrementAndGet();
        if (val < 0) {
            this.refCount.set(0);
            val = 0;
        }
        if (0 == val) {
            try {
                if (PreDestroy.class.isInstance(this.object)) {
                    ((PreDestroy)PreDestroy.class.cast(this.object)).preDestroy();
                }
            }
            catch (RuntimeException e) {
                logger.log(Level.FINE, "error encountered", new ComponentException(e));
                throw e;
            }
            finally {
                this.object = null;
                this.onBehalfOf = null;
                super.release();
            }
        }
    }

    @Override
    public Inhabitant<T> scopedClone() {
        if (null == this.real) {
            this.fetch();
        }
        Inhabitant real = this.real;
        return real.scopedClone();
    }
}

