/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.SocketBinder;
import org.glassfish.grizzly.config.ConfigAwareElement;
import org.glassfish.grizzly.config.GrizzlyConfig;
import org.glassfish.grizzly.config.GrizzlyConfigException;
import org.glassfish.grizzly.config.GrizzlyListener;
import org.glassfish.grizzly.config.SSLConfigurator;
import org.glassfish.grizzly.config.Utils;
import org.glassfish.grizzly.config.dom.FileCache;
import org.glassfish.grizzly.config.dom.Http;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.PortUnification;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.ProtocolChain;
import org.glassfish.grizzly.config.dom.ProtocolChainInstanceHandler;
import org.glassfish.grizzly.config.dom.ProtocolFilter;
import org.glassfish.grizzly.config.dom.ProtocolFinder;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.grizzly.config.dom.Transport;
import org.glassfish.grizzly.config.portunif.HttpRedirectFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.EncodingFilter;
import org.glassfish.grizzly.http.GZipContentEncoding;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.KeepAlive;
import org.glassfish.grizzly.http.LZMAContentEncoding;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.FileCacheFilter;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.ServerFilterConfiguration;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.nio.transport.UDPNIOTransportBuilder;
import org.glassfish.grizzly.portunif.PUFilter;
import org.glassfish.grizzly.portunif.PUProtocol;
import org.glassfish.grizzly.portunif.finders.SSLProtocolFinder;
import org.glassfish.grizzly.rcm.ResourceAllocationFilter;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.threadpool.DefaultWorkerThread;
import org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.glassfish.grizzly.utils.IdleTimeoutFilter;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericGrizzlyListener
implements GrizzlyListener {
    static final Logger logger = Logger.getLogger(GrizzlyListener.class.getName());
    protected volatile String name;
    protected volatile InetAddress address;
    protected volatile int port;
    protected NIOTransport transport;
    protected FilterChain rootFilterChain;
    private volatile ExecutorService auxExecutorService;
    private volatile DelayedExecutor delayedExecutor;
    private volatile long transactionTimeoutMillis = -1L;

    @Override
    public String getName() {
        return this.name;
    }

    protected final void setName(String name) {
        this.name = name;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    protected final void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    protected void setPort(int port) {
        this.port = port;
    }

    @Override
    public void start() throws IOException {
        this.delayedExecutor.start();
        ((SocketBinder)this.transport).bind((SocketAddress)new InetSocketAddress(this.address, this.port));
        this.transport.start();
    }

    @Override
    public void stop() throws IOException {
        this.stopDelayedExecutor();
        this.transport.stop();
        this.transport = null;
        this.rootFilterChain = null;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void processDynamicConfigurationChange(Habitat habitat, PropertyChangeEvent[] events) {
    }

    @Override
    public <T> T getAdapter(Class<T> adapterClass) {
        return null;
    }

    public <E> List<E> getFilters(Class<E> clazz) {
        return GenericGrizzlyListener.getFilters(clazz, this.rootFilterChain, new ArrayList(2));
    }

    public static <E> List<E> getFilters(Class<E> clazz, FilterChain filterChain, List<E> filters) {
        for (Filter filter : filterChain) {
            if (clazz.isAssignableFrom(filter.getClass())) {
                filters.add(filter);
            }
            if (!PUFilter.class.isAssignableFrom(filter.getClass())) continue;
            Set puProtocols = ((PUFilter)filter).getProtocols();
            for (PUProtocol puProtocol : puProtocols) {
                GenericGrizzlyListener.getFilters(clazz, puProtocol.getFilterChain(), filters);
            }
        }
        return filters;
    }

    @Override
    public void configure(Habitat habitat, NetworkListener networkListener) throws IOException {
        this.setName(networkListener.getName());
        this.setAddress(InetAddress.getByName(networkListener.getAddress()));
        this.setPort(Integer.parseInt(networkListener.getPort()));
        this.configureDelayedExecutor(habitat);
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        this.configureTransport(habitat, networkListener, networkListener.findTransport(), filterChainBuilder);
        this.configureProtocol(habitat, networkListener, networkListener.findProtocol(), filterChainBuilder);
        this.configureThreadPool(habitat, networkListener, networkListener.findThreadPool());
        this.rootFilterChain = filterChainBuilder.build();
        this.transport.setProcessor((Processor)this.rootFilterChain);
    }

    protected void configureTransport(Habitat habitat, NetworkListener networkListener, Transport transportConfig, FilterChainBuilder filterChainBuilder) {
        String transportName = transportConfig.getName();
        if ("tcp".equalsIgnoreCase(transportName)) {
            this.transport = this.configureTCPTransport(habitat, networkListener, transportConfig);
        } else if ("udp".equalsIgnoreCase(transportName)) {
            this.transport = this.configureUDPTransport(habitat, networkListener, transportConfig);
        } else {
            throw new GrizzlyConfigException("Unsupported transport type " + transportConfig.getName());
        }
        this.transport.setSelectorRunnersCount(Integer.parseInt(transportConfig.getAcceptorThreads()));
        this.transport.setReadBufferSize(Integer.parseInt(transportConfig.getBufferSizeBytes()));
        filterChainBuilder.add((Filter)new TransportFilter());
    }

    protected NIOTransport configureTCPTransport(Habitat habitat, NetworkListener networkListener, Transport transportConfig) {
        TCPNIOTransport tcpTransport = TCPNIOTransportBuilder.newInstance().build();
        tcpTransport.setTcpNoDelay(Boolean.parseBoolean(transportConfig.getTcpNoDelay()));
        tcpTransport.setLinger(Integer.parseInt(transportConfig.getLinger()));
        tcpTransport.setServerConnectionBackLog(Integer.parseInt(transportConfig.getMaxConnectionsCount()));
        return tcpTransport;
    }

    protected NIOTransport configureUDPTransport(Habitat habitat, NetworkListener networkListener, Transport transportConfig) {
        return UDPNIOTransportBuilder.newInstance().build();
    }

    protected void configureProtocol(Habitat habitat, NetworkListener networkListener, Protocol protocol, FilterChainBuilder filterChainBuilder) {
        if (Boolean.valueOf(protocol.getSecurityEnabled()).booleanValue()) {
            GenericGrizzlyListener.configureSsl(habitat, networkListener, protocol.getSsl(), filterChainBuilder);
        }
        this.configureSubProtocol(habitat, networkListener, protocol, filterChainBuilder);
    }

    protected void configureSubProtocol(Habitat habitat, NetworkListener networkListener, Protocol protocol, FilterChainBuilder filterChainBuilder) {
        if (protocol.getHttp() != null) {
            Http http = protocol.getHttp();
            this.configureHttpProtocol(habitat, networkListener, http, filterChainBuilder);
        } else if (protocol.getPortUnification() != null) {
            PortUnification pu = protocol.getPortUnification();
            String puFilterClassname = pu.getClassname();
            PUFilter puFilter = null;
            if (puFilterClassname != null) {
                try {
                    puFilter = Utils.newInstance(habitat, PUFilter.class, puFilterClassname, puFilterClassname);
                    GenericGrizzlyListener.configureElement(habitat, networkListener, pu, puFilter);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Can not initialize port unification filter: " + puFilterClassname + " default filter will be used instead", e);
                }
            }
            if (puFilter == null) {
                puFilter = new PUFilter();
            }
            List<ProtocolFinder> findersConfig = pu.getProtocolFinder();
            for (ProtocolFinder finderConfig : findersConfig) {
                String finderClassname = finderConfig.getClassname();
                try {
                    org.glassfish.grizzly.portunif.ProtocolFinder protocolFinder = Utils.newInstance(habitat, org.glassfish.grizzly.portunif.ProtocolFinder.class, finderClassname, finderClassname);
                    GenericGrizzlyListener.configureElement(habitat, networkListener, finderConfig, protocolFinder);
                    Protocol subProtocol = finderConfig.findProtocol();
                    FilterChainBuilder subProtocolFilterChainBuilder = puFilter.getPUFilterChainBuilder();
                    if (Boolean.valueOf(subProtocol.getSecurityEnabled()).booleanValue()) {
                        PUFilter extraSslPUFilter = new PUFilter();
                        GenericGrizzlyListener.configureSsl(habitat, networkListener, subProtocol.getSsl(), subProtocolFilterChainBuilder);
                        subProtocolFilterChainBuilder.add((Filter)extraSslPUFilter);
                        FilterChainBuilder extraSslPUFilterChainBuilder = extraSslPUFilter.getPUFilterChainBuilder();
                        this.configureSubProtocol(habitat, networkListener, subProtocol, extraSslPUFilterChainBuilder);
                        extraSslPUFilter.register(protocolFinder, extraSslPUFilterChainBuilder.build());
                        puFilter.register((org.glassfish.grizzly.portunif.ProtocolFinder)new SSLProtocolFinder((SSLEngineConfigurator)new SSLConfigurator(habitat, subProtocol.getSsl())), subProtocolFilterChainBuilder.build());
                        continue;
                    }
                    this.configureSubProtocol(habitat, networkListener, subProtocol, subProtocolFilterChainBuilder);
                    puFilter.register(protocolFinder, subProtocolFilterChainBuilder.build());
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Can not initialize sub protocol. Finder: " + finderClassname, e);
                }
            }
            filterChainBuilder.add((Filter)puFilter);
        } else if (protocol.getHttpRedirect() != null) {
            filterChainBuilder.add((Filter)new HttpServerFilter());
            HttpRedirectFilter filter = new HttpRedirectFilter();
            filter.configure(habitat, networkListener, protocol.getHttpRedirect());
            filterChainBuilder.add((Filter)filter);
        } else {
            ProtocolChainInstanceHandler pcihConfig = protocol.getProtocolChainInstanceHandler();
            if (pcihConfig == null) {
                logger.log(Level.WARNING, "Empty protocol declaration");
                return;
            }
            ProtocolChain filterChainConfig = pcihConfig.getProtocolChain();
            for (ProtocolFilter filterConfig : filterChainConfig.getProtocolFilter()) {
                String filterClassname = filterConfig.getClassname();
                try {
                    Filter filter = (Filter)Utils.newInstance(filterClassname);
                    GenericGrizzlyListener.configureElement(habitat, networkListener, filterConfig, filter);
                    filterChainBuilder.add(filter);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Can not initialize protocol filter: " + filterClassname, e);
                    throw new IllegalStateException("Can not initialize protocol filter: " + filterClassname);
                }
            }
        }
    }

    protected static void configureSsl(Habitat habitat, NetworkListener networkListener, Ssl ssl, FilterChainBuilder filterChainBuilder) {
        SSLConfigurator serverConfig = new SSLConfigurator(habitat, ssl);
        SSLConfigurator clientConfig = new SSLConfigurator(habitat, ssl);
        clientConfig.setClientMode(true);
        filterChainBuilder.add((Filter)new SSLFilter((SSLEngineConfigurator)serverConfig, (SSLEngineConfigurator)clientConfig));
    }

    private static void configureElement(Habitat habitat, NetworkListener networkListener, ConfigBeanProxy configuration, Object instance) {
        if (instance instanceof ConfigAwareElement) {
            ((ConfigAwareElement)instance).configure(habitat, networkListener, configuration);
        }
    }

    protected void configureThreadPool(Habitat habitat, NetworkListener networkListener, ThreadPool threadPool) {
        try {
            this.transport.setWorkerThreadPool((ExecutorService)GrizzlyExecutorService.createInstance((ThreadPoolConfig)this.configureThreadPoolConfig(habitat, networkListener, threadPool)));
        }
        catch (NumberFormatException ex) {
            logger.log(Level.WARNING, " Invalid thread-pool attribute", ex);
        }
    }

    protected ThreadPoolConfig configureThreadPoolConfig(Habitat habitat, NetworkListener networkListener, ThreadPool threadPool) {
        int maxQueueSize = threadPool.getMaxQueueSize() == null ? Integer.MAX_VALUE : Integer.parseInt(threadPool.getMaxQueueSize());
        int minThreads = Integer.parseInt(threadPool.getMinThreadPoolSize());
        int maxThreads = Integer.parseInt(threadPool.getMaxThreadPoolSize());
        int timeout = Integer.parseInt(threadPool.getIdleThreadTimeoutSeconds());
        ThreadPoolConfig poolConfig = ThreadPoolConfig.defaultConfig();
        poolConfig.setCorePoolSize(minThreads);
        poolConfig.setMaxPoolSize(maxThreads);
        poolConfig.setQueueLimit(maxQueueSize);
        poolConfig.setKeepAliveTime(timeout < 0 ? Long.MAX_VALUE : (long)timeout, TimeUnit.SECONDS);
        if (this.transactionTimeoutMillis > 0L && !Utils.isDebugVM()) {
            poolConfig.setTransactionTimeout(this.delayedExecutor, this.transactionTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        return poolConfig;
    }

    protected void configureDelayedExecutor(Habitat habitat) {
        final AtomicInteger threadCounter = new AtomicInteger();
        this.auxExecutorService = Executors.newCachedThreadPool(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                DefaultWorkerThread newThread = new DefaultWorkerThread(GenericGrizzlyListener.this.transport.getAttributeBuilder(), GenericGrizzlyListener.this.getName() + '-' + threadCounter.getAndIncrement(), null, r);
                newThread.setDaemon(true);
                return newThread;
            }
        });
        this.delayedExecutor = new DelayedExecutor(this.auxExecutorService);
    }

    protected void stopDelayedExecutor() {
        DelayedExecutor localDelayedExecutor = this.delayedExecutor;
        this.delayedExecutor = null;
        if (localDelayedExecutor != null) {
            localDelayedExecutor.stop();
        }
        ExecutorService localThreadPool = this.auxExecutorService;
        this.auxExecutorService = null;
        if (localThreadPool != null) {
            localThreadPool.shutdownNow();
        }
    }

    protected void configureHttpProtocol(Habitat habitat, NetworkListener networkListener, Http http, FilterChainBuilder filterChainBuilder) {
        this.transactionTimeoutMillis = Integer.parseInt(http.getRequestTimeoutSeconds()) * 1000;
        filterChainBuilder.add((Filter)new IdleTimeoutFilter(this.delayedExecutor, (long)Integer.parseInt(http.getTimeoutSeconds()), TimeUnit.SECONDS));
        HttpServerFilter httpServerFilter = new HttpServerFilter(Boolean.parseBoolean(http.getChunkingEnabled()), Integer.parseInt(http.getHeaderBufferLengthBytes()), http.getForcedResponseType(), this.configureKeepAlive(habitat, http), this.delayedExecutor);
        Set<ContentEncoding> contentEncodings = this.configureContentEncodings(habitat, http);
        for (ContentEncoding contentEncoding : contentEncodings) {
            httpServerFilter.addContentEncoding(contentEncoding);
        }
        boolean isRcmSupportEnabled = Boolean.parseBoolean(http.getRcmSupportEnabled());
        if (isRcmSupportEnabled) {
            filterChainBuilder.add((Filter)new ResourceAllocationFilter());
        }
        filterChainBuilder.add((Filter)httpServerFilter);
        org.glassfish.grizzly.http.server.filecache.FileCache fileCache = this.configureHttpFileCache(habitat, http.getFileCache());
        fileCache.initialize(this.transport.getMemoryManager(), this.delayedExecutor);
        FileCacheFilter fileCacheFilter = new FileCacheFilter(fileCache);
        filterChainBuilder.add((Filter)fileCacheFilter);
        org.glassfish.grizzly.http.server.HttpServerFilter webServerFilter = new org.glassfish.grizzly.http.server.HttpServerFilter(this.getHttpServerFilterConfiguration(http), this.delayedExecutor);
        HttpHandler httpHandler = this.getHttpHandler(http);
        httpHandler.setAllowEncodedSlash(GrizzlyConfig.toBoolean(http.getEncodedSlashEnabled()));
        webServerFilter.setHttpHandler(httpHandler);
        filterChainBuilder.add((Filter)webServerFilter);
        this.configureCometSupport(habitat, networkListener, http, filterChainBuilder);
        this.configureWebSocketSupport(habitat, networkListener, http, filterChainBuilder);
        this.configureAjpSupport(habitat, networkListener, http, filterChainBuilder);
    }

    protected void configureCometSupport(Habitat habitat, NetworkListener networkListener, Http http, FilterChainBuilder filterChainBuilder) {
        AddOn cometAddOn;
        if (GrizzlyConfig.toBoolean(http.getCometSupportEnabled()) && (cometAddOn = this.loadAddOn(habitat, "comet", "org.glassfish.grizzly.comet.CometAddOn")) != null) {
            GenericGrizzlyListener.configureElement(habitat, networkListener, http, cometAddOn);
            cometAddOn.setup(null, filterChainBuilder);
        }
    }

    protected void configureWebSocketSupport(Habitat habitat, NetworkListener networkListener, Http http, FilterChainBuilder filterChainBuilder) {
        AddOn websocketAddOn;
        boolean websocketsSupportEnabled = Boolean.parseBoolean(http.getWebsocketsSupportEnabled());
        if (websocketsSupportEnabled && (websocketAddOn = this.loadAddOn(habitat, "websocket", "org.glassfish.grizzly.websockets.WebSocketAddOn")) != null) {
            GenericGrizzlyListener.configureElement(habitat, networkListener, http, websocketAddOn);
            websocketAddOn.setup(null, filterChainBuilder);
        }
    }

    protected void configureAjpSupport(Habitat habitat, NetworkListener networkListener, Http http, FilterChainBuilder filterChainBuilder) {
        AddOn ajpAddOn;
        boolean jkSupportEnabled;
        boolean bl = jkSupportEnabled = http.getJkEnabled() != null ? Boolean.parseBoolean(http.getJkEnabled()) : Boolean.parseBoolean(networkListener.getJkEnabled());
        if (jkSupportEnabled && (ajpAddOn = this.loadAddOn(habitat, "ajp", "org.glassfish.grizzly.http.ajp.AjpAddOn")) != null) {
            GenericGrizzlyListener.configureElement(habitat, networkListener, http, ajpAddOn);
            ajpAddOn.setup(null, filterChainBuilder);
        }
    }

    private AddOn loadAddOn(Habitat habitat, String name, String addOnClassName) {
        return Utils.newInstance(habitat, AddOn.class, name, addOnClassName);
    }

    private Filter loadFilter(Habitat habitat, String name, String filterClassName) {
        return Utils.newInstance(habitat, Filter.class, name, filterClassName);
    }

    protected ServerFilterConfiguration getHttpServerFilterConfiguration(Http http) {
        return new ServerFilterConfiguration();
    }

    protected HttpHandler getHttpHandler(Http http) {
        return new StaticHttpHandler(new String[]{"."});
    }

    protected org.glassfish.grizzly.http.server.filecache.FileCache configureHttpFileCache(Habitat habitat, FileCache cache) {
        org.glassfish.grizzly.http.server.filecache.FileCache fileCache = new org.glassfish.grizzly.http.server.filecache.FileCache();
        if (cache != null) {
            fileCache.setEnabled(GrizzlyConfig.toBoolean(cache.getEnabled()));
            fileCache.setSecondsMaxAge(Integer.parseInt(cache.getMaxAgeSeconds()));
            fileCache.setMaxCacheEntries(Integer.parseInt(cache.getMaxFilesCount()));
            fileCache.setMaxLargeFileCacheSize(Integer.parseInt(cache.getMaxCacheSizeBytes()));
        } else {
            fileCache.setEnabled(false);
        }
        return fileCache;
    }

    protected KeepAlive configureKeepAlive(Habitat habitat, Http http) {
        int timeoutInSeconds = 60;
        int maxConnections = 256;
        if (http != null) {
            String msg;
            try {
                timeoutInSeconds = Integer.parseInt(http.getTimeoutSeconds());
            }
            catch (NumberFormatException ex) {
                msg = "pewebcontainer.invalidKeepAliveTimeout";
                msg = MessageFormat.format(msg, http.getTimeoutSeconds(), Integer.toString(timeoutInSeconds));
                logger.log(Level.WARNING, msg, ex);
            }
            try {
                maxConnections = Integer.parseInt(http.getMaxConnections());
            }
            catch (NumberFormatException ex) {
                msg = "pewebcontainer.invalidKeepAliveMaxConnections";
                msg = MessageFormat.format(msg, http.getMaxConnections(), Integer.toString(maxConnections));
                logger.log(Level.WARNING, msg, ex);
            }
        }
        KeepAlive keepAlive = new KeepAlive();
        keepAlive.setIdleTimeoutInSeconds(timeoutInSeconds);
        keepAlive.setMaxRequestsCount(maxConnections);
        return keepAlive;
    }

    protected Set<ContentEncoding> configureContentEncodings(Habitat habitat, Http http) {
        return this.configureCompressionEncodings(habitat, http);
    }

    protected Set<ContentEncoding> configureCompressionEncodings(Habitat habitat, Http http) {
        COMPRESSION_LEVEL compressionLevel;
        String mode = http.getCompression();
        int compressionMinSize = Integer.parseInt(http.getCompressionMinSizeBytes());
        try {
            compressionLevel = this.getCompressionLevel(mode);
        }
        catch (IllegalArgumentException e) {
            try {
                compressionLevel = COMPRESSION_LEVEL.ON;
                compressionMinSize = Integer.parseInt(mode);
            }
            catch (Exception ignore) {
                compressionLevel = COMPRESSION_LEVEL.OFF;
            }
        }
        String compressableMimeTypesString = http.getCompressableMimeType();
        String noCompressionUserAgentsString = http.getNoCompressionUserAgents();
        String[] compressableMimeTypes = this.split(compressableMimeTypesString, ",");
        String[] noCompressionUserAgents = this.split(noCompressionUserAgentsString, ",");
        GZipContentEncoding gzipContentEncoding = new GZipContentEncoding(512, 512, new CompressionEncodingFilter(compressionLevel, compressionMinSize, compressableMimeTypes, noCompressionUserAgents, GZipContentEncoding.ALIASES));
        LZMAContentEncoding lzmaEncoding = new LZMAContentEncoding(new CompressionEncodingFilter(compressionLevel, compressionMinSize, compressableMimeTypes, noCompressionUserAgents, LZMAContentEncoding.ALIASES));
        HashSet<ContentEncoding> set = new HashSet<ContentEncoding>(2);
        set.add(gzipContentEncoding);
        set.add(lzmaEncoding);
        return set;
    }

    private String[] split(String s, String delim) {
        if (s == null) {
            return new String[0];
        }
        ArrayList<String> compressableMimeTypeList = new ArrayList<String>(4);
        StringTokenizer st = new StringTokenizer(s, delim);
        while (st.hasMoreTokens()) {
            compressableMimeTypeList.add(st.nextToken().trim());
        }
        String[] splitStrings = new String[compressableMimeTypeList.size()];
        compressableMimeTypeList.toArray(splitStrings);
        return splitStrings;
    }

    protected final COMPRESSION_LEVEL getCompressionLevel(String compression) {
        if ("on".equalsIgnoreCase(compression)) {
            return COMPRESSION_LEVEL.ON;
        }
        if ("force".equalsIgnoreCase(compression)) {
            return COMPRESSION_LEVEL.FORCE;
        }
        if ("off".equalsIgnoreCase(compression)) {
            return COMPRESSION_LEVEL.OFF;
        }
        throw new IllegalArgumentException();
    }

    private static int indexOf(String[] aliases, DataChunk dc) {
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (!dc.equalsIgnoreCase(alias)) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfStartsWith(String[] aliases, String s) {
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (!s.startsWith(alias)) continue;
            return i;
        }
        return -1;
    }

    public static class CompressionEncodingFilter
    implements EncodingFilter {
        private final COMPRESSION_LEVEL compressionLevel;
        private final int compressionMinSize;
        private final String[] compressableMimeTypes;
        private final String[] noCompressionUserAgents;
        private final String[] aliases;

        public CompressionEncodingFilter(COMPRESSION_LEVEL compressionLevel, int compressionMinSize, String[] compressableMimeTypes, String[] noCompressionUserAgents, String[] aliases) {
            this.compressionLevel = compressionLevel;
            this.compressionMinSize = compressionMinSize;
            this.compressableMimeTypes = compressableMimeTypes;
            this.noCompressionUserAgents = noCompressionUserAgents;
            this.aliases = aliases;
        }

        public boolean applyEncoding(HttpHeader httpPacket) {
            DataChunk userAgentValueDC;
            switch (this.compressionLevel) {
                case OFF: {
                    return false;
                }
            }
            if (org.glassfish.grizzly.http.Protocol.HTTP_1_1 != httpPacket.getProtocol()) {
                return false;
            }
            HttpResponsePacket responsePacket = (HttpResponsePacket)httpPacket;
            MimeHeaders requestHeaders = responsePacket.getRequest().getHeaders();
            DataChunk acceptEncodingDC = requestHeaders.getValue("accept-encoding");
            if (acceptEncodingDC == null || GenericGrizzlyListener.indexOf(this.aliases, acceptEncodingDC) == -1) {
                return false;
            }
            MimeHeaders responseHeaders = responsePacket.getHeaders();
            DataChunk contentEncodingMB = responseHeaders.getValue("Content-Encoding");
            if (contentEncodingMB != null && GenericGrizzlyListener.indexOf(this.aliases, contentEncodingMB) != -1) {
                return false;
            }
            if (this.compressionLevel == COMPRESSION_LEVEL.FORCE) {
                return true;
            }
            if (this.noCompressionUserAgents.length > 0 && (userAgentValueDC = requestHeaders.getValue("user-agent")) != null && GenericGrizzlyListener.indexOf(this.noCompressionUserAgents, userAgentValueDC) != -1) {
                return false;
            }
            long contentLength = responsePacket.getContentLength();
            if ((contentLength == -1L || contentLength > (long)this.compressionMinSize) && this.compressableMimeTypes.length > 0) {
                return GenericGrizzlyListener.indexOfStartsWith(this.compressableMimeTypes, responsePacket.getContentType()) != -1;
            }
            return true;
        }

        public boolean applyDecoding(HttpHeader httpPacket) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum COMPRESSION_LEVEL {
        OFF,
        ON,
        FORCE;

    }
}

