/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.util;

import java.util.List;
import javax.naming.directory.DirContext;

public class AlternateDocBase {
    private String pattern;
    private UrlPatternType patternType;
    private int patternSlashCount;
    private String docBase;
    private String basePath;
    private String patternSuffix;
    private String wildcardPath;
    private DirContext resources;
    private DirContext webappResources;

    public void setUrlPattern(String urlPattern) {
        this.pattern = urlPattern;
        this.patternSlashCount = AlternateDocBase.getSlashCount(urlPattern);
        if (urlPattern.endsWith("/*")) {
            this.patternType = UrlPatternType.WILDCARD;
            this.wildcardPath = urlPattern.substring(0, urlPattern.length() - 1);
        } else if (urlPattern.startsWith("*.")) {
            this.patternType = UrlPatternType.EXTENSION;
            this.patternSuffix = urlPattern.substring(1);
        } else {
            this.patternType = UrlPatternType.EXACT;
        }
    }

    public String getUrlPattern() {
        return this.pattern;
    }

    public UrlPatternType getUrlPatternType() {
        return this.patternType;
    }

    public int getUrlPatternSlashCount() {
        return this.patternSlashCount;
    }

    public String getUrlPatternSuffix() {
        return this.patternSuffix;
    }

    public String getUrlPatternWildcardPath() {
        return this.wildcardPath;
    }

    public void setDocBase(String docBase) {
        this.docBase = docBase;
    }

    public String getDocBase() {
        return this.docBase;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setResources(DirContext resources) {
        this.resources = resources;
    }

    public DirContext getResources() {
        return this.resources;
    }

    public void setWebappResources(DirContext webappResources) {
        this.webappResources = webappResources;
    }

    public DirContext getWebappResources() {
        return this.webappResources;
    }

    public static AlternateDocBase findMatch(String path, List<AlternateDocBase> alternateDocBases) {
        if (alternateDocBases == null) {
            return null;
        }
        AlternateDocBase match = null;
        AlternateDocBase wildcardMatch = null;
        AlternateDocBase extensionMatch = null;
        int maxSlashCountMatch = 0;
        int pathSlashCount = AlternateDocBase.getSlashCount(path);
        for (int i = 0; i < alternateDocBases.size(); ++i) {
            AlternateDocBase alternateDocBase = alternateDocBases.get(i);
            String pattern = alternateDocBase.getUrlPattern();
            int patternSlashCount = alternateDocBase.getUrlPatternSlashCount();
            UrlPatternType type = alternateDocBase.getUrlPatternType();
            String wildcardPath = alternateDocBase.getUrlPatternWildcardPath();
            if (type == UrlPatternType.EXACT && path.equals(pattern)) {
                match = alternateDocBase;
                break;
            }
            if (type == UrlPatternType.WILDCARD && pathSlashCount >= patternSlashCount && patternSlashCount > maxSlashCountMatch && path.startsWith(wildcardPath)) {
                wildcardMatch = alternateDocBase;
                maxSlashCountMatch = patternSlashCount;
                continue;
            }
            if (type != UrlPatternType.EXTENSION || !path.endsWith(alternateDocBase.getUrlPatternSuffix())) continue;
            extensionMatch = alternateDocBase;
        }
        if (match == null) {
            match = wildcardMatch != null ? wildcardMatch : extensionMatch;
        }
        return match;
    }

    private static int getSlashCount(String s) {
        int count = 0;
        if (s != null) {
            int index = s.indexOf(47);
            while (index >= 0) {
                ++count;
                index = s.indexOf(47, index + 1);
            }
        }
        return count;
    }

    static enum UrlPatternType {
        EXACT,
        WILDCARD,
        EXTENSION;

    }
}

