/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.launcher.GFLauncherLogger;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GFEmbeddedLauncher
extends GFLauncher {
    private boolean setup = false;
    private File gfeJar;
    private File runServerJar;
    private File installDir;
    private File javaExe;
    private File domainDir;
    private String javaDbClassPath;
    private String logFilename;
    private static final String GFE_RUNSERVER_JAR = "GFE_RUNSERVER_JAR";
    private static final String GFE_RUNSERVER_CLASS = "GFE_RUNSERVER_CLASS";
    private static final String GFE_JAR = "GFE_JAR";
    private static final String INSTALL_HOME = "S1AS_HOME";
    private static final String JAVA_HOME = "JAVA_HOME";
    private static final String GENERAL_MESSAGE = " *********  GENERAL MESSAGE ********\nYou must setup four different environmental variables to run embedded with asadmin.  They are\nGFE_JAR - path to the embedded jar\nS1AS_HOME - path to installation directory.  This can be empty or not exist yet.\nJAVA_HOME - path to a JDK installation.  JRE installation is generally not good enough\nGFE_DEBUG_PORT - optional debugging port.  It will start suspended.\n\n*********  SPECIFIC MESSAGE ********\n";
    private String[] DERBY_FILES = new String[]{"derby.jar", "derbyclient.jar"};

    public GFEmbeddedLauncher(GFLauncherInfo info) {
        super(info);
    }

    @Override
    void internalLaunch() throws GFLauncherException {
        try {
            this.launchInstance();
        }
        catch (Exception ex) {
            throw new GFLauncherException(ex);
        }
    }

    @Override
    List<File> getMainClasspath() throws GFLauncherException {
        throw new GFLauncherException("not needed?!?");
    }

    @Override
    String getMainClass() throws GFLauncherException {
        String className = System.getenv(GFE_RUNSERVER_CLASS);
        if (className == null) {
            return "org.glassfish.tests.embedded.EmbeddedMain";
        }
        return className;
    }

    @Override
    public void setup() throws GFLauncherException, MiniXmlParserException {
        if (this.setup) {
            return;
        }
        this.setup = true;
        try {
            this.setupFromEnv();
        }
        catch (GFLauncherException gfle) {
            String msg = "";
            throw new GFLauncherException(GENERAL_MESSAGE + gfle.getMessage());
        }
        this.setCommandLine();
        GFLauncherInfo info = this.getInfo();
        try {
            File parent = info.getDomainParentDir();
            String domainName = info.getDomainName();
            String instanceName = info.getInstanceName();
            if (instanceName == null) {
                instanceName = "server";
            }
            File dom = new File(parent, domainName);
            File theConfigDir = new File(dom, "config");
            File dx = new File(theConfigDir, "domain.xml");
            info.setConfigDir(theConfigDir);
            info.setDomainRootDir(new File(System.getenv(INSTALL_HOME)));
            MiniXmlParser parser = new MiniXmlParser(dx, instanceName);
            info.setAdminAddresses(parser.getAdminAddresses());
            File logFile = new File(dom, "logs");
            logFile = new File(logFile, "server.log");
            this.logFilename = logFile.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<HostAndPort> adminAddresses = info.getAdminAddresses();
        if (adminAddresses == null || adminAddresses.isEmpty()) {
            adminAddresses = new ArrayList<HostAndPort>();
            adminAddresses.add(new HostAndPort("localhost", 4848, false));
            info.setAdminAddresses(adminAddresses);
        }
        GFLauncherLogger.addLogFileHandler(this.getLogFilename(), info);
    }

    @Override
    public String getLogFilename() throws GFLauncherException {
        return this.logFilename;
    }

    @Override
    void setClasspath() {
        String classPath = this.gfeJar.getPath() + File.pathSeparator + this.javaDbClassPath;
        if (this.runServerJar != null) {
            classPath = classPath + File.pathSeparator + this.runServerJar.getPath();
        }
        this.setClasspath(classPath);
    }

    @Override
    void setCommandLine() throws GFLauncherException {
        List<String> cmdLine = this.getCommandLine();
        cmdLine.clear();
        cmdLine.add(this.javaExe.getPath());
        this.addThreadDump(cmdLine);
        cmdLine.add("-cp");
        cmdLine.add(this.getClasspath());
        this.addDebug(cmdLine);
        cmdLine.add(this.getMainClass());
        cmdLine.add("--installdir");
        cmdLine.add(this.installDir.getPath());
        cmdLine.add("--instancedir");
        cmdLine.add(this.domainDir.getPath());
        cmdLine.add("--autodelete");
        cmdLine.add("false");
        cmdLine.add("--autodeploy");
    }

    private void addDebug(List<String> cmdLine) {
        String suspend;
        String debugPort = System.getenv("GFE_DEBUG_PORT");
        if (this.ok(debugPort)) {
            suspend = "y";
        } else {
            debugPort = "12345";
            suspend = "n";
        }
        cmdLine.add("-Xdebug");
        cmdLine.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=" + suspend + ",address=" + debugPort);
    }

    private void addThreadDump(List<String> cmdLine) {
        File logDir = new File(this.domainDir, "logs");
        File jvmLogFile = new File(logDir, "jvm.log");
        cmdLine.add("-XX:+UnlockDiagnosticVMOptions");
        cmdLine.add("-XX:+LogVMOutput");
        cmdLine.add("-XX:LogFile=" + jvmLogFile.getPath());
    }

    private void setupFromEnv() throws GFLauncherException {
        this.setupEmbeddedJars();
        this.setupInstallationDir();
        this.setupJDK();
        this.setupDomainDir();
        this.setupJavaDB();
        this.setClasspath();
    }

    private void setupDomainDir() throws GFLauncherException {
        String domainDirName = this.getInfo().getDomainName();
        this.domainDir = this.getInfo().getDomainParentDir();
        this.domainDir = new File(this.domainDir, domainDirName);
        if (!FileUtils.mkdirsMaybe(this.domainDir)) {
            throw new GFLauncherException("Can not create directory: " + this.domainDir);
        }
        this.domainDir = SmartFile.sanitize(this.domainDir);
    }

    private void setupJDK() throws GFLauncherException {
        String err = "You must set the environmental variable JAVA_HOME to point at a valid JDK.  <jdk>/bin/javac[.exe] must exist.";
        String jdkDirName = System.getenv(JAVA_HOME);
        if (!this.ok(jdkDirName)) {
            throw new GFLauncherException(err);
        }
        File jdkDir = new File(jdkDirName);
        if (!jdkDir.isDirectory()) {
            throw new GFLauncherException(err);
        }
        this.javaExe = File.separatorChar == '\\' ? new File(jdkDir, "bin/java.exe") : new File(jdkDir, "bin/java");
        if (!this.javaExe.isFile()) {
            throw new GFLauncherException(err);
        }
        this.javaExe = SmartFile.sanitize(this.javaExe);
    }

    private void setupInstallationDir() throws GFLauncherException {
        String err = "You must set the environmental variable S1AS_HOME to point at a GlassFish installation or at an empty directory or at a location where an empty directory can be created.";
        String installDirName = System.getenv(INSTALL_HOME);
        if (!this.ok(installDirName)) {
            throw new GFLauncherException(err);
        }
        this.installDir = new File(installDirName);
        if (!FileUtils.mkdirsMaybe(this.installDir)) {
            throw new GFLauncherException(err);
        }
        this.installDir = SmartFile.sanitize(this.installDir);
    }

    private void setupEmbeddedJars() throws GFLauncherException {
        String err = "You must set the environmental variable GFE_JAR to point at the Embedded jarfile.";
        String gfeJarName = System.getenv(GFE_JAR);
        if (!this.ok(gfeJarName)) {
            throw new GFLauncherException(err);
        }
        this.gfeJar = new File(gfeJarName);
        if (!this.gfeJar.isFile() || this.gfeJar.length() < 1000000L) {
            throw new GFLauncherException(err);
        }
        this.gfeJar = SmartFile.sanitize(this.gfeJar);
        err = "You must set the environmental variable GFE_RUNSERVER_JAR to point at the server startup jar.";
        String runServerJarName = System.getenv(GFE_RUNSERVER_JAR);
        if (runServerJarName != null) {
            if (!this.ok(runServerJarName)) {
                throw new GFLauncherException(err);
            }
            this.runServerJar = new File(runServerJarName);
            if (!this.runServerJar.isFile()) {
                throw new GFLauncherException(err);
            }
            this.runServerJar = SmartFile.sanitize(this.runServerJar);
        }
    }

    private void setupJavaDB() throws GFLauncherException {
        String relPath = "javadb/lib";
        File derbyLib = new File(this.installDir, relPath);
        if (!derbyLib.isDirectory()) {
            derbyLib = new File(this.installDir.getParentFile(), relPath);
        }
        if (!derbyLib.isDirectory()) {
            throw new GFLauncherException("Could not find the JavaDB lib directory.");
        }
        this.javaDbClassPath = "";
        boolean firstItem = true;
        for (String fname : this.DERBY_FILES) {
            File f = new File(derbyLib, fname);
            this.javaDbClassPath = this.javaDbClassPath + File.pathSeparator;
            this.javaDbClassPath = this.javaDbClassPath + f.getPath();
            if (f.exists()) continue;
            throw new GFLauncherException("Could not find the JavaDB jar: " + f);
        }
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

