/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote;

import com.sun.enterprise.admin.remote.RemoteAdminCommand;
import com.sun.enterprise.admin.util.HttpConnectorAddress;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.security.ssl.SSLUtils;
import java.net.URLConnection;
import java.util.logging.Logger;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.component.Habitat;

public class ServerRemoteAdminCommand
extends RemoteAdminCommand {
    private static final String SSL_SOCKET_PROTOCOL = "TLS";
    private Habitat habitat;
    private SecureAdmin secureAdmin;
    private ServerEnvironment serverEnv;
    private SSLUtils _sslUtils = null;

    public ServerRemoteAdminCommand(Habitat habitat, String name, String host, int port, boolean secure, String user, String password, Logger logger) throws CommandException {
        super(name, host, port, false, "admin", "", logger);
        this.completeInit(habitat);
    }

    private synchronized void completeInit(Habitat habitat) {
        this.habitat = habitat;
        this.secureAdmin = (SecureAdmin)habitat.getComponent(SecureAdmin.class);
        this.serverEnv = (ServerEnvironment)habitat.getComponent(ServerEnvironment.class);
    }

    protected HttpConnectorAddress getHttpConnectorAddress(String host, int port, boolean shouldUseSecure) {
        if (SecureAdmin.Util.isEnabled((SecureAdmin)this.secureAdmin)) {
            return new HttpConnectorAddress(host, port, this.sslUtils().getAdminSocketFactory(this.getCertAlias(), SSL_SOCKET_PROTOCOL));
        }
        return super.getHttpConnectorAddress(host, port, shouldUseSecure);
    }

    protected void addAdditionalHeaders(URLConnection urlConnection) {
        String indicatorValue;
        if (!SecureAdmin.Util.isEnabled((SecureAdmin)this.secureAdmin) && (indicatorValue = SecureAdmin.Util.configuredAdminIndicator((SecureAdmin)this.secureAdmin)) != null) {
            urlConnection.setRequestProperty("X-GlassFish-admin", indicatorValue);
        }
    }

    private synchronized String getCertAlias() {
        return this.serverEnv.isDas() ? SecureAdmin.Util.DASAlias((SecureAdmin)this.secureAdmin) : SecureAdmin.Util.instanceAlias((SecureAdmin)this.secureAdmin);
    }

    private synchronized SSLUtils sslUtils() {
        if (this._sslUtils == null) {
            this._sslUtils = (SSLUtils)this.habitat.getComponent(SSLUtils.class);
        }
        return this._sslUtils;
    }
}

