/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.ReferenceCountedLazyInhabitant;
import com.sun.hk2.component.ScopeInstance;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.tracing.TracingThreadLocal;
import org.jvnet.hk2.tracing.TracingUtilities;
import sun.misc.BASE64Decoder;

public abstract class AbstractInhabitantImpl<T>
implements Inhabitant<T> {
    protected static final Logger logger = Logger.getLogger(ScopeInstance.class.getName());
    private Collection<Inhabitant> companions;
    private Collection<Inhabitant<?>> managed;

    public String toString() {
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this) + "(" + this.typeName() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T get() {
        try {
            if (TracingUtilities.isEnabled()) {
                TracingThreadLocal.get().push(this);
            }
            Object t = this.get(this);
            return t;
        }
        finally {
            if (TracingUtilities.isEnabled()) {
                TracingThreadLocal.get().pop();
            }
        }
    }

    @Override
    public <T> T getSerializedMetadata(final Class<T> type, String key) {
        String v = this.metadata().getOne(key);
        if (v == null) {
            return null;
        }
        try {
            ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(new BASE64Decoder().decodeBuffer(v))){
                final ClassLoader cl;
                {
                    super(x0);
                    this.cl = type.getClassLoader();
                }

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String name = desc.getName();
                    try {
                        return Class.forName(name, false, this.cl);
                    }
                    catch (ClassNotFoundException ex) {
                        return super.resolveClass(desc);
                    }
                }
            };
            return type.cast(is.readObject());
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    @Override
    public final <T> T getSerializedMetadata(Class<T> type) {
        return this.getSerializedMetadata(type, type.getName());
    }

    @Override
    public Inhabitant lead() {
        return null;
    }

    @Override
    public final Collection<Inhabitant> companions() {
        if (this.companions == null) {
            return Collections.emptyList();
        }
        return this.companions;
    }

    @Override
    public final void setCompanions(Collection<Inhabitant> companions) {
        this.companions = companions;
    }

    @Override
    public Inhabitant<T> scopedClone() {
        return new ReferenceCountedLazyInhabitant(this);
    }

    @Override
    public void manage(Inhabitant<?> managedInhabitant) {
        assert (null != managedInhabitant);
        assert (this != managedInhabitant);
        if (null == this.managed) {
            this.managed = new ArrayList();
        }
        this.managed.add(managedInhabitant);
    }

    @Override
    public void release() {
        if (null != this.managed) {
            this.releaseManaged();
        }
    }

    protected final void dispose(T object) {
        if (object instanceof PreDestroy) {
            logger.log(Level.FINER, "calling PreDestroy on {0}", object);
            ((PreDestroy)object).preDestroy();
        }
    }

    protected void releaseManaged() {
        if (null != this.managed) {
            RuntimeException lastException = null;
            for (Inhabitant<?> i : this.managed) {
                logger.log(Level.FINER, "releasing {0} on behalf of {1}", new Object[]{i, this});
                try {
                    i.release();
                }
                catch (RuntimeException e) {
                    logger.log(Level.FINE, "error encountered", e);
                    lastException = e;
                }
            }
            this.managed = null;
            if (null != lastException) {
                throw lastException;
            }
        }
    }

    public <V extends Annotation> V getAnnotation(Class<V> annotation) {
        return AbstractInhabitantImpl.getAnnotation(this.type(), annotation, false);
    }

    public static <V extends Annotation> V getAnnotation(Class<?> annotated, Class<V> annotation, boolean walkParentChain) {
        V v = annotated.getAnnotation(annotation);
        if (null != v) {
            return v;
        }
        for (Annotation a : annotated.getAnnotations()) {
            v = a.annotationType().getAnnotation(annotation);
            if (null == v) continue;
            return v;
        }
        if (walkParentChain && null != (annotated = annotated.getSuperclass())) {
            return AbstractInhabitantImpl.getAnnotation(annotated, annotation, true);
        }
        return null;
    }
}

