/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.AbstractInhabitantImpl;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.hk2.component.Holder;
import com.sun.hk2.component.InhabitantStore;
import com.sun.hk2.component.LazyInhabitant;
import com.sun.hk2.component.ScopedInhabitant;
import com.sun.hk2.component.SingletonInhabitant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.jvnet.hk2.annotations.RunLevel;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Creator;
import org.jvnet.hk2.component.Creators;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantProviderInterceptor;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.Scope;
import org.jvnet.hk2.component.Singleton;

public class Inhabitants {
    public static Inhabitant<?> createInhabitant(Habitat habitat, Holder<ClassLoader> classLoader, String typeName, MultiMap<String, String> metadata, Inhabitant<?> lead, Set<String> indicies) {
        Iterator<InhabitantProviderInterceptor> interceptors = null == habitat ? Collections.EMPTY_LIST.iterator() : habitat.getAllByContract(InhabitantProviderInterceptor.class).iterator();
        return Inhabitants.createInhabitant(habitat, interceptors, classLoader, typeName, metadata, lead, null, indicies);
    }

    public static Inhabitant<?> createInhabitant(Habitat habitat, Iterator<InhabitantProviderInterceptor> interceptors, Holder<ClassLoader> classLoader, String typeName, MultiMap<String, String> metadata, Inhabitant<?> lead, InhabitantStore store, Set<String> indicies) {
        InhabitantProviderInterceptor interceptor;
        AbstractInhabitantImpl i = new LazyInhabitant(habitat, classLoader, typeName, metadata, lead);
        InhabitantProviderInterceptor inhabitantProviderInterceptor = interceptor = null != interceptors && interceptors.hasNext() ? interceptors.next() : null;
        if (null != interceptor) {
            i = interceptor.visit(i, typeName, indicies, interceptors, store);
        }
        return i;
    }

    public static <T> Inhabitant<T> create(T instance) {
        return new ExistingSingletonInhabitant<T>(instance);
    }

    public static <T> Inhabitant<T> create(Class<T> c, Habitat habitat, MultiMap<String, String> metadata) {
        return Inhabitants.wrapByScope(c, Creators.create(c, habitat, metadata), habitat);
    }

    public static <T> Inhabitant<T> wrapByScope(Class<T> c, Creator<T> creator, Habitat habitat) {
        Scoped scoped = c.getAnnotation(Scoped.class);
        if (scoped == null) {
            return new SingletonInhabitant<T>(creator);
        }
        Class<? extends Scope> scopeClass = scoped.value();
        return Inhabitants.wrapByScope(creator, habitat, scopeClass);
    }

    public static <T> Inhabitant<T> wrapByScope(Creator<T> creator, Habitat habitat, Class<? extends Scope> scopeClass) {
        if (scopeClass == PerLookup.class) {
            return creator;
        }
        if (scopeClass == Singleton.class) {
            return new SingletonInhabitant<T>(creator);
        }
        Scope scope = habitat.getByType(scopeClass);
        if (scope == null) {
            throw new ComponentException("Failed to look up %s", scopeClass);
        }
        return new ScopedInhabitant<T>(creator, scope);
    }

    public static <T> Collection<String> getNamesFor(Inhabitant<T> i, String indexName) {
        return new ArrayList<String>(i.metadata().get(indexName));
    }

    static void validate(Object target, Object injectedVal) {
        if (null != injectedVal) {
            RunLevel targetRL = AbstractInhabitantImpl.getAnnotation(target.getClass(), RunLevel.class, false);
            RunLevel injectedValRL = AbstractInhabitantImpl.getAnnotation(injectedVal.getClass(), RunLevel.class, false);
            if (null == targetRL && null != injectedValRL) {
                throw new ComponentException("invalid dependency from a non-RunLevel instance " + target + " to a RunLevel instance " + injectedVal);
            }
        }
    }
}

