/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.Hk2ThreadContext;
import com.sun.hk2.component.Holder;
import com.sun.hk2.component.Inhabitants;
import com.sun.hk2.component.InjectionPointImpl;
import com.sun.hk2.component.InjectionResolver;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.tiger_types.Types;

public class InjectInjectionResolver
extends InjectionResolver<Inject> {
    public static final boolean MANAGED_ENABLED = true;
    final Habitat habitat;

    public InjectInjectionResolver(Habitat habitat) {
        super(Inject.class);
        this.habitat = habitat;
    }

    @Override
    public boolean isOptional(AnnotatedElement element, Inject annotation) {
        return annotation.optional();
    }

    @Override
    public <V> V getValue(final Object component, final Inhabitant<?> onBehalfOf, final AnnotatedElement target, final Type genericType, final Class<V> type) throws ComponentException {
        final Inject inject = target.getAnnotation(Inject.class);
        Callable callable = new Callable<V>(){

            @Override
            public V call() throws ComponentException {
                Object result = type.isArray() ? InjectInjectionResolver.this.getArrayInjectValue(InjectInjectionResolver.this.habitat, component, onBehalfOf, target, genericType, type) : (Types.isSubClassOf(type, Holder.class) ? InjectInjectionResolver.this.getHolderInjectValue(InjectInjectionResolver.this.habitat, component, onBehalfOf, target, genericType, type, inject) : (InjectInjectionResolver.this.habitat.isContract(type) ? InjectInjectionResolver.this.getServiceInjectValue(InjectInjectionResolver.this.habitat, component, onBehalfOf, target, genericType, type, inject) : InjectInjectionResolver.this.getComponentInjectValue(InjectInjectionResolver.this.habitat, component, onBehalfOf, target, genericType, type, inject)));
                return InjectInjectionResolver.this.validate(component, onBehalfOf, result);
            }
        };
        try {
            if (this.habitat.isContextualFactoriesPresent()) {
                InjectionPointImpl ip = new InjectionPointImpl(component, target, type, inject, onBehalfOf);
                return Hk2ThreadContext.captureIPandRun(ip, callable);
            }
            return callable.call();
        }
        catch (Exception e) {
            if (e instanceof ComponentException) {
                throw (ComponentException)ComponentException.class.cast(e);
            }
            throw new ComponentException(e);
        }
    }

    protected <V> V getArrayInjectValue(Habitat habitat, Object component, Inhabitant<?> onBehalfOf, AnnotatedElement target, Type genericType, Class<V> type) {
        Class<?> ct = type.getComponentType();
        Collection<?> instances = habitat.isContract(ct) ? this.getAllByContract(onBehalfOf, habitat, ct) : this.getAllByType(onBehalfOf, habitat, ct);
        V result = type.cast(instances.toArray((Object[])Array.newInstance(ct, instances.size())));
        return result;
    }

    protected <V> V getHolderInjectValue(Habitat habitat, Object component, Inhabitant<?> onBehalfOf, AnnotatedElement target, Type genericType, Class<V> type, Inject inject) throws ComponentException {
        Type t = Types.getTypeArgument(((Field)target).getGenericType(), 0);
        Class finalType = Types.erasure(t);
        if (habitat.isContract(finalType)) {
            Inhabitant<?> i = this.manage(onBehalfOf, habitat.getInhabitant(finalType, inject.name()));
            return type.cast(i);
        }
        try {
            if (finalType.cast(component) != null) {
                return type.cast(onBehalfOf);
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        V result = type.cast(this.getInhabitantByType(onBehalfOf, habitat, finalType));
        return result;
    }

    protected <V> V getServiceInjectValue(Habitat habitat, Object component, Inhabitant<?> onBehalfOf, AnnotatedElement target, Type genericType, Class<V> type, Inject inject) throws ComponentException {
        V result = null;
        Inhabitant<?> i = this.manage(onBehalfOf, habitat.getInhabitant(type, inject.name()));
        if (null != i) {
            Object service = i.get();
            try {
                result = type.cast(service);
            }
            catch (ClassCastException e) {
                Logger.getAnonymousLogger().severe("ClassCastException between contract " + type + " and service " + service);
                Logger.getAnonymousLogger().severe("Contract class loader " + type.getClassLoader());
                Logger.getAnonymousLogger().severe("Service class loader " + service.getClass().getClassLoader());
                i.release();
                throw e;
            }
        }
        return result;
    }

    protected <V> V getComponentInjectValue(Habitat habitat, Object component, Inhabitant<?> onBehalfOf, AnnotatedElement target, Type genericType, Class<V> type, Inject inject) throws ComponentException {
        Inhabitant<?> i = this.manage(onBehalfOf, habitat.getInhabitantByType(type));
        if (null != i) {
            return (V)i.get();
        }
        return null;
    }

    protected <V> V validate(Object component, Inhabitant<?> onBehalfOf, V toBeInjected) {
        Inhabitants.validate(component, toBeInjected);
        return toBeInjected;
    }

    protected Inhabitant<?> manage(Inhabitant<?> onBehalfOf, Inhabitant<?> inhabitant) {
        if (null == inhabitant || null == onBehalfOf) {
            return inhabitant;
        }
        Inhabitant<?> scopedClone = inhabitant.scopedClone();
        onBehalfOf.manage(scopedClone);
        return scopedClone;
    }

    protected <V> Collection<V> manage(Inhabitant<?> onBehalfOf, Iterable<?> inhabitants) {
        if (null == inhabitants) {
            return null;
        }
        ArrayList managed = new ArrayList();
        for (Object iObj : inhabitants) {
            Inhabitant i = (Inhabitant)iObj;
            managed.add(this.manage(onBehalfOf, i).get());
        }
        return managed;
    }

    protected Inhabitant<?> getInhabitantByType(Inhabitant<?> onBehalfOf, Habitat habitat, Class<?> finalType) {
        return this.manage(onBehalfOf, habitat.getInhabitantByType(finalType));
    }

    protected <V> Collection<V> getInhabitants(Inhabitant<?> onBehalfOf, Habitat habitat, Class<?> finalType, String name) {
        return this.manage(onBehalfOf, habitat.getInhabitants(finalType, name));
    }

    protected <V> Collection<V> getAllByType(Inhabitant<?> onBehalfOf, Habitat habitat, Class<V> ct) {
        return this.manage(onBehalfOf, habitat.getAllInhabitantsByType(ct));
    }

    protected <V> Collection<V> getAllByContract(Inhabitant<?> onBehalfOf, Habitat habitat, Class<V> ct) {
        return this.manage(onBehalfOf, habitat.getAllInhabitantsByContract(ct.getName()));
    }
}

