/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.classmodel;

import com.sun.hk2.component.InhabitantsScanner;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.hk2.classmodel.reflect.util.ParsingConfig;
import org.glassfish.hk2.classmodel.reflect.util.ResourceLocator;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.InhabitantMetadata;
import org.jvnet.hk2.annotations.RunLevel;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.classmodel.ClassPath;
import org.jvnet.hk2.component.classmodel.ClassPathAdvisor;

public abstract class InhabitantsParsingContextGenerator
implements Closeable {
    private static final Logger logger = Logger.getLogger(InhabitantsParsingContextGenerator.class.getName());
    private Parser parser;
    private final ParsingContext context;
    private final LinkedHashMap<String, InhabitantsScanner> metaInfScanners = new LinkedHashMap();
    private FileFilter inhabitantsClassPathFilter;
    private final LinkedHashSet<URI> parsed = new LinkedHashSet();

    public static InhabitantsParsingContextGenerator create(Habitat h, ExecutorService es, ClassPath inhabitantsClassPath, FileFilter inhabitantsClassPathFilter) {
        return new InhabitantsParsingContextGenerator(es, inhabitantsClassPath, inhabitantsClassPathFilter){};
    }

    protected InhabitantsParsingContextGenerator(ExecutorService es, ClassPath inhabitantsClassPath, FileFilter inhabitantsClassPathFilter) {
        ParsingContext.Builder builder = new ParsingContext.Builder();
        final HashSet<String> annotations = new HashSet<String>();
        annotations.add(Contract.class.getName());
        annotations.add(Service.class.getName());
        annotations.add(InhabitantMetadata.class.getName());
        annotations.add(RunLevel.class.getName());
        annotations.add("org.jvnet.hk2.config.Configured");
        builder.config(new ParsingConfig(){
            final Set<String> empty = Collections.emptySet();

            @Override
            public Set<String> getAnnotationsOfInterest() {
                return this.empty;
            }

            @Override
            public Set<String> getTypesOfInterest() {
                return annotations;
            }
        });
        builder.executorService(es);
        Locator locator = null;
        if (null == inhabitantsClassPathFilter) {
            this.inhabitantsClassPathFilter = null;
            locator = null == inhabitantsClassPath ? null : new Locator(inhabitantsClassPath);
        } else {
            this.inhabitantsClassPathFilter = inhabitantsClassPathFilter;
            if (ClassPathAdvisor.class.isInstance(this.inhabitantsClassPathFilter)) {
                ClassPathAdvisor advisor = (ClassPathAdvisor)ClassPathAdvisor.class.cast(this.inhabitantsClassPathFilter);
                advisor.starting(inhabitantsClassPath);
            }
            if (null != inhabitantsClassPath) {
                LinkedHashSet<File> accepted = new LinkedHashSet<File>();
                for (File f : inhabitantsClassPath.getFileEntries()) {
                    if (!inhabitantsClassPathFilter.accept(f)) continue;
                    accepted.add(f);
                }
                locator = new Locator(ClassPath.create(null, accepted));
            }
        }
        builder.locator(locator);
        this.context = builder.build();
        this.parser = new Parser(this.context);
    }

    public void parse(Collection<File> files) throws IOException {
        for (File file : files) {
            this.parse(file);
        }
    }

    public ParsingContext getContext() {
        if (null != this.parser) {
            try {
                this.parser.awaitTermination();
            }
            catch (InterruptedException e) {
                this.close();
                throw new RuntimeException(e);
            }
        }
        if (ClassPathAdvisor.class.isInstance(this.inhabitantsClassPathFilter)) {
            ClassPathAdvisor advisor = (ClassPathAdvisor)ClassPathAdvisor.class.cast(this.inhabitantsClassPathFilter);
            advisor.finishing(this.getSignificantURIReferences(), this.getInsignificantURIReferences());
            this.inhabitantsClassPathFilter = null;
        }
        return this.context;
    }

    private Set<URI> getSignificantURIReferences() {
        LinkedHashSet<URI> result = new LinkedHashSet<URI>();
        Types types = this.context.getTypes();
        for (String annotation : this.context.getConfig().getTypesOfInterest()) {
            AnnotationType atype = (AnnotationType)types.getBy(annotation);
            if (null == atype) continue;
            Collection<AnnotatedElement> coll = atype.allAnnotatedTypes();
            for (AnnotatedElement ae : coll) {
                Type type = types.getBy(ae.getName());
                if (null == type) continue;
                for (URI uri : type.getDefiningURIs()) {
                    try {
                        result.add(new File(uri).getCanonicalFile().toURI());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private Set<URI> getInsignificantURIReferences() {
        LinkedHashSet<URI> result = new LinkedHashSet<URI>();
        result.addAll(this.parsed);
        result.removeAll(this.getSignificantURIReferences());
        return Collections.unmodifiableSet(result);
    }

    public Collection<InhabitantsScanner> getInhabitantsScanners() {
        return Collections.unmodifiableCollection(this.metaInfScanners.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addInhabitantsScanner(String name, InhabitantsScanner is) {
        LinkedHashMap<String, InhabitantsScanner> linkedHashMap = this.metaInfScanners;
        synchronized (linkedHashMap) {
            if (!this.metaInfScanners.containsKey(name)) {
                this.metaInfScanners.put(name, is);
            }
        }
    }

    public void parse(File f) throws IOException {
        if (null == this.parser) {
            throw new IllegalStateException("parser closed");
        }
        f = f.getCanonicalFile();
        if (null == this.inhabitantsClassPathFilter || this.inhabitantsClassPathFilter.accept(f)) {
            this.parseAlways(this.parser, f);
        }
    }

    protected void parseAlways(Parser parser, final File f) throws IOException {
        logger.log(Level.FINE, "introspecting {0}", f);
        this.parsed.add(f.toURI());
        try {
            parser.parse(f, new Runnable(){

                @Override
                public void run() {
                    logger.log(Level.FINER, "Finished introspecting {0}", f.getName());
                }
            });
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "problem during parsing - closing prematurely", e);
            this.close();
        }
    }

    @Override
    public void close() {
        if (null != this.parser) {
            this.parser.close();
            this.parser = null;
        }
    }

    private static class Locator
    implements ResourceLocator {
        private final ClassLoader resourceLoader;

        public Locator(ClassPath inhabitantsClassPath) {
            try {
                this.resourceLoader = new URLClassLoader(inhabitantsClassPath.getRawURLs(), null);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "resourceLoader is {0}", Arrays.asList(inhabitantsClassPath.getRawURLs()).toString());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public InputStream openResourceStream(String name) {
            if (name.startsWith("java/")) {
                logger.log(Level.FINE, "skipping {0}", name);
                return null;
            }
            if (name.indexOf(".") == -1) {
                return null;
            }
            logger.log(Level.FINE, "loading resource {0}", name);
            try {
                InputStream resource = this.resourceLoader.getResourceAsStream(name);
                logger.log(Level.FINE, "resource {0} resolved to {1}", new Object[]{name, resource});
                return resource;
            }
            catch (Exception e) {
                throw new RuntimeException("failed while getting resource: " + name);
            }
        }

        @Override
        public URL getResource(String name) {
            if (name.startsWith("java/")) {
                logger.log(Level.FINE, "skipping {0}", name);
                return null;
            }
            if (name.indexOf(".") == -1) {
                return null;
            }
            return this.resourceLoader.getResource(name);
        }
    }
}

