/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.helper;

import com.sun.appserv.management.config.AttributeResolver;

public class AttributeResolverHelper {
    private final AttributeResolver mResolver;

    public AttributeResolverHelper(AttributeResolver resolver) {
        this.mResolver = resolver;
    }

    public static boolean needsResolving(String value) {
        if (value == null) {
            return false;
        }
        String temp = value.trim();
        return temp.startsWith("${") && temp.endsWith("}");
    }

    public static String extract(String value) {
        return AttributeResolverHelper.needsResolving(value) ? value.trim().substring(2, value.length() - 1) : value;
    }

    public String resolve(String in) {
        return AttributeResolverHelper.resolve(this.mResolver, in);
    }

    public static String resolve(AttributeResolver resolver, String value) {
        return AttributeResolverHelper.needsResolving(value) ? resolver.resolveAttributeValue(value) : value;
    }

    public boolean resolveBoolean(String value) {
        return AttributeResolverHelper.resolveBoolean(this.mResolver, value);
    }

    public static boolean resolveBoolean(AttributeResolver resolver, String value) {
        String resolved = AttributeResolverHelper.resolve(resolver, value);
        return Boolean.parseBoolean(resolved);
    }

    public int resolveInt(String value) {
        return AttributeResolverHelper.resolveInt(this.mResolver, value);
    }

    public static int resolveInt(AttributeResolver resolver, String value) {
        String resolved = AttributeResolverHelper.resolve(resolver, value);
        return Integer.parseInt(resolved);
    }
}

