/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.misc.TypeCast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListUtil {
    private ListUtil() {
    }

    public static <T> void addArray(List<T> list, T[] array) {
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
    }

    public static List<String> asStringList(Object value) {
        List<String> values = null;
        if (value instanceof String) {
            values = Collections.singletonList((String)value);
        } else if (value instanceof String[]) {
            values = ListUtil.newListFromArray((String[])value);
        } else if (value instanceof List) {
            List<String> checkedList = TypeCast.checkList(TypeCast.asList(value), String.class);
            values = new ArrayList<String>(checkedList);
        } else {
            throw new IllegalArgumentException("" + value);
        }
        return values;
    }

    public static String[] toStringArray(List<?> list) {
        String[] names = new String[list.size()];
        int i = 0;
        for (Object o : list) {
            names[i] = "" + o;
            ++i;
        }
        return names;
    }

    public static <T> List<T> newListFromCollection(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(c);
        return list;
    }

    public static <T> List<? extends T> newListFromIterator(Iterator<? extends T> iter) {
        ArrayList<T> list = new ArrayList<T>();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public static <T> List<T> newList(T m1) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(m1);
        return list;
    }

    public static <T> List<T> newList(T m1, T m2) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(m1);
        list.add(m2);
        return list;
    }

    public static <T> List<T> newList(T m1, T m2, T m3) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(m1);
        list.add(m2);
        list.add(m3);
        return list;
    }

    public static <T> List<T> newList(T m1, T m2, T m3, T m4) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(m1);
        list.add(m2);
        list.add(m3);
        list.add(m4);
        return list;
    }

    public static <T> List<T> newList(T m1, T m2, T m3, T m4, T m5) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(m1);
        list.add(m2);
        list.add(m3);
        list.add(m4);
        list.add(m5);
        return list;
    }

    public static <T> List<T> newListFromArray(T[] items) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < items.length; ++i) {
            list.add(items[i]);
        }
        return list;
    }

    public static <T> List<T> reverse(List<T> list) {
        int numItems = list.size();
        ArrayList<T> result = new ArrayList<T>(numItems);
        for (int i = 0; i < numItems; ++i) {
            result.add(list.get(numItems - i - 1));
        }
        return result;
    }
}

