/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import com.sun.enterprise.admin.cli.remote.Log;
import com.sun.enterprise.admin.cli.remote.ManifestManager;
import com.sun.enterprise.admin.cli.remote.PlainTextManager;
import com.sun.enterprise.admin.cli.remote.RemoteException;
import com.sun.enterprise.admin.cli.remote.RemoteFailureException;
import com.sun.enterprise.admin.cli.remote.RemoteUtils;
import com.sun.enterprise.admin.cli.remote.ResponseManager;
import com.sun.enterprise.universal.StringUtils;
import com.sun.enterprise.universal.io.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteResponseManager
implements ResponseManager {
    private int code;
    final InputStream responseStream;
    final String response;
    private static final int HTTP_SUCCESS_CODE = 200;
    private Manifest m;
    private Map<String, String> mainAtts;

    public RemoteResponseManager(InputStream in, int code) throws RemoteException, IOException {
        this.code = code;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtils.copyStream(in, baos);
        this.responseStream = new ByteArrayInputStream(baos.toByteArray());
        this.response = baos.toString();
        if (!StringUtils.ok(this.response)) {
            throw new RemoteFailureException("emptyResponse");
        }
        Log.finer("------- RAW RESPONSE  ---------", new Object[0]);
        Log.finer(this.response, new Object[0]);
        Log.finer("------- RAW RESPONSE  ---------", new Object[0]);
    }

    @Override
    public void process() throws RemoteException {
        this.checkCode();
        try {
            this.handleManifest();
        }
        catch (RemoteFailureException e) {
            throw e;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.handlePlainText();
        throw new RemoteFailureException(this.get("internal", this.get("unknownResponse", this.response)));
    }

    public Map<String, String> getMainAtts() {
        return this.mainAtts;
    }

    private void checkCode() throws RemoteFailureException {
        if (this.code != 200) {
            throw new RemoteFailureException("badHttpCode", this.code);
        }
    }

    private void handleManifest() throws RemoteException, IOException {
        ManifestManager mgr = new ManifestManager(this.responseStream);
        this.mainAtts = mgr.getMainAtts();
        mgr.process();
    }

    private void handlePlainText() throws RemoteException {
        PlainTextManager mgr = new PlainTextManager(this.response);
        mgr.process();
    }

    private String get(String s) {
        return RemoteUtils.getString(s);
    }

    private String get(String s, Object ... objs) {
        return RemoteUtils.getString(s, objs);
    }
}

