/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.connectors.ConnectionManagerImpl;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.LazyAssociatableConnectionManagerImpl;
import com.sun.enterprise.connectors.LazyEnlistableConnectionManagerImpl;
import com.sun.enterprise.connectors.PoolMetaData;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ConnectionManager;

public class ConnectionManagerFactory {
    public static ConnectionManager getAvailableConnectionManager(String poolName, boolean forceNoLazyAssoc) throws ConnectorRuntimeException {
        ConnectorRegistry registry = ConnectorRegistry.getInstance();
        PoolMetaData pmd = registry.getPoolMetaData(poolName);
        boolean isLazyEnlist = pmd.isLazyEnlistable();
        boolean isLazyAssoc = pmd.isLazyAssociatable();
        ConnectionManagerImpl mgr = null;
        if (isLazyAssoc && !forceNoLazyAssoc) {
            ConnectionManagerFactory.logFine("Creating LazyAssociatableConnectionManager");
            mgr = new LazyAssociatableConnectionManagerImpl(poolName);
        } else if (isLazyEnlist) {
            ConnectionManagerFactory.logFine("Creating LazyEnlistableConnectionManager");
            mgr = new LazyEnlistableConnectionManagerImpl(poolName);
        } else {
            ConnectionManagerFactory.logFine("Creating plain ConnectionManager");
            mgr = new ConnectionManagerImpl(poolName);
        }
        return mgr;
    }

    private static void logFine(String message) {
        Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(message);
        }
    }
}

