/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInitInfo;
import com.sun.enterprise.deployment.EjbRemovalInfo;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.ejb.SessionSynchronization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EjbSessionDescriptor
extends EjbDescriptor {
    private boolean isStateless = false;
    private int timeout = 0;
    private Set<LifecycleCallbackDescriptor> postActivateDescs = new HashSet<LifecycleCallbackDescriptor>();
    private Set<LifecycleCallbackDescriptor> prePassivateDescs = new HashSet<LifecycleCallbackDescriptor>();
    private Map<MethodDescriptor, EjbRemovalInfo> removeMethods = new HashMap<MethodDescriptor, EjbRemovalInfo>();
    private Set<EjbInitInfo> initMethods = new HashSet<EjbInitInfo>();
    public static final String TYPE = "Session";
    public static final String STATELESS = "Stateless";
    public static final String STATEFUL = "Stateful";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbSessionDescriptor.class);

    public EjbSessionDescriptor() {
    }

    public EjbSessionDescriptor(EjbDescriptor other) {
        super(other);
        if (other instanceof EjbSessionDescriptor) {
            EjbSessionDescriptor session = (EjbSessionDescriptor)other;
            this.isStateless = session.isStateless;
            this.timeout = session.timeout;
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String getSessionType() {
        if (this.isStateless()) {
            return STATELESS;
        }
        return STATEFUL;
    }

    public void setSessionType(String sessionType) {
        if (STATELESS.equals(sessionType)) {
            this.setStateless(true);
            return;
        }
        if (STATEFUL.equals(sessionType)) {
            this.setStateless(false);
            return;
        }
        if (this.isBoundsChecking()) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionsessiontypenotlegaltype", "{0} is not a legal session type for session ejbs. The type must be {1} or {2}", sessionType, STATEFUL, STATELESS));
        }
    }

    @Override
    public void setType(String type) {
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotsettypeofsessionbean", "Cannot set the type of a session bean"));
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTransactionType(String transactionType) {
        boolean isValidType;
        boolean bl = isValidType = "Bean".equals(transactionType) || "Container".equals(transactionType);
        if (!isValidType) {
            if (this.isBoundsChecking()) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment..exceptointxtypenotlegaltype", "{0} is not a legal transaction type for session beans", transactionType));
            }
        }
        this.transactionType = transactionType;
        super.setMethodContainerTransactions(new Hashtable());
    }

    public boolean isStateless() {
        return this.isStateless;
    }

    public boolean isStateful() {
        return !this.isStateless();
    }

    public void setStateless(boolean isStateless) {
        this.isStateless = isStateless;
    }

    public boolean hasRemoveMethods() {
        return !this.removeMethods.isEmpty();
    }

    public EjbRemovalInfo getRemovalInfo(MethodDescriptor method) {
        for (MethodDescriptor methodDesc : this.removeMethods.keySet()) {
            if (!methodDesc.equals(method)) continue;
            return this.removeMethods.get(methodDesc);
        }
        for (MethodDescriptor methodDesc : this.removeMethods.keySet()) {
            if (!methodDesc.implies(method)) continue;
            return this.removeMethods.get(methodDesc);
        }
        return null;
    }

    public Set<EjbRemovalInfo> getAllRemovalInfo() {
        return new HashSet<EjbRemovalInfo>(this.removeMethods.values());
    }

    public void addRemoveMethod(EjbRemovalInfo removalInfo) {
        this.removeMethods.put(removalInfo.getRemoveMethod(), removalInfo);
    }

    public boolean hasInitMethods() {
        return !this.initMethods.isEmpty();
    }

    public Set<EjbInitInfo> getInitMethods() {
        return new HashSet<EjbInitInfo>(this.initMethods);
    }

    public void addInitMethod(EjbInitInfo initInfo) {
        this.initMethods.add(initInfo);
    }

    public Set<LifecycleCallbackDescriptor> getPostActivateDescriptors() {
        if (this.postActivateDescs == null) {
            this.postActivateDescs = new HashSet<LifecycleCallbackDescriptor>();
        }
        return this.postActivateDescs;
    }

    public void addPostActivateDescriptor(LifecycleCallbackDescriptor postActivateDesc) {
        String className = postActivateDesc.getLifecycleCallbackClass();
        boolean found = false;
        for (LifecycleCallbackDescriptor next : this.getPostActivateDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.getPostActivateDescriptors().add(postActivateDesc);
        }
    }

    public LifecycleCallbackDescriptor getPostActivateDescriptorByClass(String className) {
        for (LifecycleCallbackDescriptor next : this.getPostActivateDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            return next;
        }
        return null;
    }

    public boolean hasPostActivateMethod() {
        return this.getPostActivateDescriptors().size() > 0;
    }

    public Set<LifecycleCallbackDescriptor> getPrePassivateDescriptors() {
        if (this.prePassivateDescs == null) {
            this.prePassivateDescs = new HashSet<LifecycleCallbackDescriptor>();
        }
        return this.prePassivateDescs;
    }

    public void addPrePassivateDescriptor(LifecycleCallbackDescriptor prePassivateDesc) {
        String className = prePassivateDesc.getLifecycleCallbackClass();
        boolean found = false;
        for (LifecycleCallbackDescriptor next : this.getPrePassivateDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.getPrePassivateDescriptors().add(prePassivateDesc);
        }
    }

    public LifecycleCallbackDescriptor getPrePassivateDescriptorByClass(String className) {
        for (LifecycleCallbackDescriptor next : this.getPrePassivateDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            return next;
        }
        return null;
    }

    public boolean hasPrePassivateMethod() {
        return this.getPrePassivateDescriptors().size() > 0;
    }

    @Override
    public Vector getPossibleTransactionAttributes() {
        Vector<ContainerTransaction> txAttributes = super.getPossibleTransactionAttributes();
        if (this.isStateful()) {
            try {
                EjbBundleDescriptor ejbBundle = this.getEjbBundleDescriptor();
                ClassLoader classLoader = ejbBundle.getClassLoader();
                Class<?> ejbClass = classLoader.loadClass(this.getEjbClassName());
                Class<SessionSynchronization> sessionSynchClass = SessionSynchronization.class;
                if (sessionSynchClass.isAssignableFrom(ejbClass)) {
                    txAttributes = new Vector<ContainerTransaction>();
                    txAttributes.add(new ContainerTransaction("Required", ""));
                    txAttributes.add(new ContainerTransaction("RequiresNew", ""));
                    txAttributes.add(new ContainerTransaction("Mandatory", ""));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return txAttributes;
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("Session descriptor");
        toStringBuffer.append("\n isStateless ").append(this.isStateless);
        super.print(toStringBuffer);
    }
}

