/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.OrderedSet;
import java.util.Iterator;
import java.util.Set;

public class OutboundResourceAdapter
extends Descriptor {
    private int transactionSupport = 1;
    private Set authMechanisms = new OrderedSet();
    private boolean reauthenticationSupport = false;
    private Set connectionDefs = new OrderedSet();

    public boolean supportsReauthentication() {
        return this.reauthenticationSupport;
    }

    public String getReauthenticationSupport() {
        return String.valueOf(this.reauthenticationSupport);
    }

    public void setReauthenticationSupport(boolean reauthenticationSupport) {
        this.reauthenticationSupport = reauthenticationSupport;
    }

    public void setReauthenticationSupport(String reauthSupport) {
        this.reauthenticationSupport = Boolean.valueOf(reauthSupport);
    }

    public String getTransSupport() {
        if (this.transactionSupport == 0) {
            return "NoTransaction";
        }
        if (this.transactionSupport == 1) {
            return "LocalTransaction";
        }
        return "XATransaction";
    }

    public int getTransactionSupport() {
        return this.transactionSupport;
    }

    public void setTransactionSupport(int transactionSupport) {
        this.transactionSupport = transactionSupport;
    }

    public void setTransactionSupport(String support) {
        this.transactionSupport = "NoTransaction".equals(support) ? 0 : ("LocalTransaction".equals(support) ? 1 : 2);
    }

    public Set getAuthMechanisms() {
        if (this.authMechanisms == null) {
            this.authMechanisms = new OrderedSet();
        }
        return this.authMechanisms;
    }

    public boolean addAuthMechanism(AuthMechanism mech) {
        boolean flag = false;
        for (AuthMechanism next : this.authMechanisms) {
            if (next.getAuthMechVal() != mech.getAuthMechVal()) continue;
            return flag;
        }
        flag = this.authMechanisms.add(mech);
        return flag;
    }

    public boolean removeAuthMechanism(AuthMechanism mech) {
        boolean flag = false;
        for (AuthMechanism next : this.authMechanisms) {
            if (!next.equals(mech)) continue;
            flag = this.authMechanisms.remove(mech);
            return flag;
        }
        return flag;
    }

    public boolean addAuthMechanism(int mech) {
        boolean flag = false;
        for (AuthMechanism next : this.authMechanisms) {
            if (next.getAuthMechVal() != mech) continue;
            return flag;
        }
        String credInf = null;
        credInf = mech == 0 ? "javax.resource.spi.security.PasswordCredential" : "javax.resource.spi.security.GenericCredential";
        AuthMechanism auth = new AuthMechanism("", mech, credInf);
        flag = this.authMechanisms.add(auth);
        return flag;
    }

    public boolean removeAuthMechanism(int mech) {
        boolean flag = false;
        for (AuthMechanism next : this.authMechanisms) {
            if (next.getAuthMechVal() != mech) continue;
            flag = this.authMechanisms.remove(next);
            return flag;
        }
        return flag;
    }

    public void addConnectionDefDescriptor(ConnectionDefDescriptor conDefDesc) {
        this.connectionDefs.add(conDefDesc);
    }

    public void removeConnectionDefDescriptor(ConnectionDefDescriptor conDefDesc) {
        this.connectionDefs.remove(conDefDesc);
    }

    public Set getConnectionDefs() {
        return this.connectionDefs;
    }

    public void setConnectionDef(ConnectionDefDescriptor conDef) {
        this.connectionDefs.add(conDef);
    }

    public ConnectionDefDescriptor getConnectionDef() {
        Iterator iter = this.connectionDefs.iterator();
        ConnectionDefDescriptor conDef = (ConnectionDefDescriptor)iter.next();
        return conDef;
    }

    public String getManagedConnectionFactoryImpl() {
        return this.getConnectionDef().getManagedConnectionFactoryImpl();
    }

    public void setManagedConnectionFactoryImpl(String managedConnectionFactoryImpl) {
        this.getConnectionDef().setManagedConnectionFactoryImpl(managedConnectionFactoryImpl);
    }

    public Set getConfigProperties() {
        return this.getConnectionDef().getConfigProperties();
    }

    public void addConfigProperty(EnvironmentProperty configProperty) {
        this.getConnectionDef().getConfigProperties().add(configProperty);
    }

    public void removeConfigProperty(EnvironmentProperty configProperty) {
        this.getConnectionDef().getConfigProperties().remove(configProperty);
    }

    public String getConnectionFactoryImpl() {
        return this.getConnectionDef().getConnectionFactoryImpl();
    }

    public void setConnectionFactoryImpl(String cf) {
        this.getConnectionDef().setConnectionFactoryImpl(cf);
    }

    public String getConnectionFactoryIntf() {
        return this.getConnectionDef().getConnectionFactoryIntf();
    }

    public void setConnectionFactoryIntf(String cf) {
        this.getConnectionDef().setConnectionFactoryIntf(cf);
    }

    public String getConnectionIntf() {
        return this.getConnectionDef().getConnectionIntf();
    }

    public void setConnectionIntf(String con) {
        this.getConnectionDef().setConnectionIntf(con);
    }

    public String getConnectionImpl() {
        return this.getConnectionDef().getConnectionImpl();
    }

    public void setConnectionImpl(String con) {
        this.getConnectionDef().setConnectionImpl(con);
    }
}

