/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.annotation.context.ComponentContext;
import com.sun.enterprise.deployment.annotation.context.EjbBundleContext;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.EjbInterceptorContext;
import com.sun.enterprise.deployment.annotation.context.EjbsContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractAttributeHandler
extends AbstractHandler {
    AbstractAttributeHandler() {
    }

    protected abstract HandlerProcessingResult processAnnotation(AnnotationInfo var1, EjbContext[] var2) throws AnnotationProcessorException;

    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbInterceptorContext ejbInterceptorContext) throws AnnotationProcessorException {
        if (!this.isDelegatee()) {
            throw new UnsupportedOperationException();
        }
        return this.getDefaultProcessedResult();
    }

    @Override
    public HandlerProcessingResult processAnnotation(AnnotationInfo ainfo) throws AnnotationProcessorException {
        AnnotatedElementHandler aeHandler;
        AnnotatedElement ae = ainfo.getAnnotatedElement();
        Annotation annotation = ainfo.getAnnotation();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("@process annotation " + annotation + " in " + ae);
        }
        if ((aeHandler = ainfo.getProcessingContext().getHandler()) instanceof EjbBundleContext) {
            EjbBundleContext ejbBundleContext = (EjbBundleContext)aeHandler;
            AnnotatedElementHandler aeh = ejbBundleContext.createContextForEjb();
            if (aeh != null) {
                aeHandler = aeh;
            } else {
                if (this.isDelegatee()) {
                    aeHandler = ejbBundleContext.createContextForEjbInterceptor();
                }
                if (aeHandler == null) {
                    return this.getInvalidAnnotatedElementHandlerResult(aeHandler, ainfo);
                }
            }
        }
        if (!this.supportTypeInheritance() && ElementType.TYPE.equals((Object)ainfo.getElementType()) && aeHandler instanceof ComponentContext) {
            ComponentContext context = (ComponentContext)((Object)aeHandler);
            Class clazz = (Class)ainfo.getAnnotatedElement();
            if (!clazz.getName().equals(context.getComponentClassName())) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.log(Level.WARNING, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.typeinhernotsupp", "The annotation symbol inheritance is not supported."));
                }
                return this.getDefaultProcessedResult();
            }
        }
        EjbContext[] ejbContexts = null;
        EjbInterceptorContext ejbInterceptorContext = null;
        if (aeHandler instanceof EjbContext) {
            EjbContext ejbContext = (EjbContext)aeHandler;
            ejbContexts = new EjbContext[]{ejbContext};
        } else if (aeHandler instanceof EjbsContext) {
            ejbContexts = ((EjbsContext)aeHandler).getEjbContexts();
        } else if (this.isDelegatee() && aeHandler instanceof EjbInterceptorContext) {
            ejbInterceptorContext = (EjbInterceptorContext)aeHandler;
        } else {
            return this.getInvalidAnnotatedElementHandlerResult(aeHandler, ainfo);
        }
        HandlerProcessingResult procResult = null;
        procResult = ejbInterceptorContext != null ? this.processAnnotation(ainfo, ejbInterceptorContext) : this.processAnnotation(ainfo, ejbContexts);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("New annotation for " + annotation);
        }
        return procResult;
    }

    protected boolean isDelegatee() {
        return false;
    }

    protected boolean supportTypeInheritance() {
        return false;
    }

    protected Set<MethodDescriptor> getMethodAllDescriptors(EjbDescriptor ejbDesc) {
        HashSet<MethodDescriptor> methodAlls = new HashSet<MethodDescriptor>();
        if (ejbDesc.isRemoteInterfacesSupported() || ejbDesc.isRemoteBusinessInterfacesSupported()) {
            methodAlls.add(new MethodDescriptor("*", "", "Remote"));
            if (ejbDesc.isRemoteInterfacesSupported()) {
                methodAlls.add(new MethodDescriptor("*", "", "Home"));
            }
        }
        if (ejbDesc.isLocalInterfacesSupported() || ejbDesc.isLocalBusinessInterfacesSupported()) {
            methodAlls.add(new MethodDescriptor("*", "", "Local"));
            if (ejbDesc.isLocalInterfacesSupported()) {
                methodAlls.add(new MethodDescriptor("*", "", "LocalHome"));
            }
        }
        if (ejbDesc.hasWebServiceEndpointInterface()) {
            methodAlls.add(new MethodDescriptor("*", "", "ServiceEndpoint"));
        }
        return methodAlls;
    }

    protected boolean hasMethodPermissionsFromDD(MethodDescriptor methodDesc, EjbDescriptor ejbDesc) {
        HashMap methodPermissionsFromDD = ejbDesc.getMethodPermissionsFromDD();
        if (methodPermissionsFromDD != null) {
            Set allMethods = ejbDesc.getMethodDescriptors();
            String ejbClassSymbol = methodDesc.getEjbClassSymbol();
            for (Object mdObjsObj : methodPermissionsFromDD.values()) {
                List mdObjs = (List)mdObjsObj;
                for (Object mdObj : mdObjs) {
                    MethodDescriptor md = (MethodDescriptor)mdObj;
                    for (Object style3MdObj : md.doStyleConversion(ejbDesc, allMethods)) {
                        MethodDescriptor style3Md = (MethodDescriptor)style3MdObj;
                        if (!methodDesc.equals(style3Md)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

