/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.runtime.common;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class MessageDescriptor
extends RuntimeDescriptor {
    public static final String JAVA_METHOD = "JavaMethod";
    public static final String OPERATION_NAME = "OperationName";
    private static final String ALL_METHODS = "*";
    private String operationName = null;
    private MethodDescriptor methodDescriptor = null;
    private ArrayList convertedMethodDescs = new ArrayList();
    private ServiceRefPortInfo portInfo = null;
    private WebServiceEndpoint endPoint = null;
    private BundleDescriptor bundleDesc = null;
    private boolean isConverted = false;

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setMethodDescriptor(MethodDescriptor methodDescriptor) {
        this.methodDescriptor = methodDescriptor;
    }

    public MethodDescriptor getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public void setServiceRefPortInfo(ServiceRefPortInfo portInfo) {
        this.portInfo = portInfo;
    }

    public ServiceRefPortInfo getServiceRefPortInfo() {
        return this.portInfo;
    }

    public void setWebServiceEndpoint(WebServiceEndpoint endPoint) {
        this.endPoint = endPoint;
    }

    public WebServiceEndpoint getWebServiceEndpoint() {
        return this.endPoint;
    }

    public void setBundleDescriptor(BundleDescriptor bundleDesc) {
        this.bundleDesc = bundleDesc;
    }

    public BundleDescriptor getBundleDescriptor() {
        return this.bundleDesc;
    }

    public ArrayList getAllDefinedMethodsInMessage() {
        if (!this.isConverted) {
            this.doStyleConversion();
        }
        return this.convertedMethodDescs;
    }

    private void doStyleConversion() {
        if (this.operationName == null && this.methodDescriptor == null) {
            this.convertedMethodDescs = this.getAllSEIMethodsOf(ALL_METHODS);
        } else if (this.methodDescriptor != null) {
            if (this.methodDescriptor.getName() != null && this.methodDescriptor.getParameterClassNames() != null) {
                this.convertedMethodDescs.add(this.methodDescriptor);
            } else if (this.methodDescriptor.getName() != null && this.methodDescriptor.getParameterClassNames() == null) {
                this.convertedMethodDescs = this.getAllSEIMethodsOf(this.methodDescriptor.getName());
            }
        }
        this.isConverted = true;
    }

    private ArrayList getAllSEIMethodsOf(String methodName) {
        String serviceInterfaceName = null;
        ArrayList<MethodDescriptor> allMethodsInSEI = new ArrayList<MethodDescriptor>();
        if (this.endPoint != null) {
            serviceInterfaceName = this.endPoint.getServiceEndpointInterface();
        } else if (this.portInfo != null) {
            serviceInterfaceName = this.portInfo.getServiceEndpointInterface();
        }
        if (serviceInterfaceName == null) {
            return allMethodsInSEI;
        }
        ClassLoader classLoader = null;
        if (this.bundleDesc != null) {
            classLoader = this.bundleDesc.getClassLoader();
        }
        if (classLoader == null) {
            return allMethodsInSEI;
        }
        try {
            Class<?> c = classLoader.loadClass(serviceInterfaceName);
            Method[] methods = c.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (methodName.equals(ALL_METHODS)) {
                    allMethodsInSEI.add(new MethodDescriptor(methods[i]));
                    continue;
                }
                if (!methodName.equals(methods[i].getName())) continue;
                allMethodsInSEI.add(new MethodDescriptor(methods[i]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return allMethodsInSEI;
    }
}

