/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.annotation.introspection.AnnotationScanner;
import com.sun.enterprise.deployment.annotation.introspection.ClassFile;
import com.sun.enterprise.deployment.annotation.introspection.ConstantPoolInfo;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Enumeration;
import org.glassfish.api.deployment.archive.ReadableArchive;

public class AnnotationDetector {
    private final ClassFile classFile;

    public AnnotationDetector(AnnotationScanner scanner) {
        ConstantPoolInfo poolInfo = new ConstantPoolInfo(scanner);
        this.classFile = new ClassFile(poolInfo);
    }

    public boolean hasAnnotationInArchive(ReadableArchive archive) throws IOException {
        Enumeration<String> entries = archive.entries();
        while (entries.hasMoreElements()) {
            String entryName = entries.nextElement();
            if (!entryName.endsWith(".class") || !this.containsAnnotation(archive, entryName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAnnotation(ReadableArchive archive, String entryName) throws IOException {
        boolean result = false;
        ReadableByteChannel channel = null;
        try {
            channel = Channels.newChannel(archive.getEntry(entryName));
            if (channel != null) {
                result = this.classFile.containsAnnotation(channel, archive.getEntrySize(entryName));
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (channel != null) {
                channel.close();
            }
        }
    }
}

