/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceGateway {
    protected static final Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public boolean allowed() {
        return true;
    }

    public void acquiredResource() {
    }

    public static ResourceGateway getInstance(String className) throws PoolingException {
        ResourceGateway gateway = null;
        gateway = className != null ? ResourceGateway.initializeCustomResourceGatewayInPrivilegedMode(className) : new ResourceGateway();
        return gateway;
    }

    private static ResourceGateway initializeCustomResourceGatewayInPrivilegedMode(final String className) throws PoolingException {
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ResourceGateway result = null;
                try {
                    result = ResourceGateway.initializeCustomResourceGateway(className);
                }
                catch (Exception e) {
                    _logger.log(Level.WARNING, "pool.resource.gateway.init.failure", className);
                    _logger.log(Level.WARNING, "pool.resource.gateway.init.failure", e);
                }
                return result;
            }
        });
        if (result != null) {
            return (ResourceGateway)result;
        }
        throw new PoolingException("Unable to initalize custom ResourceGateway : " + className);
    }

    private static ResourceGateway initializeCustomResourceGateway(String className) throws Exception {
        Class<?> class1 = Class.forName(className);
        ResourceGateway gateway = (ResourceGateway)class1.newInstance();
        return gateway;
    }

    protected static void debug(String debugStatement) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, debugStatement);
        }
    }
}

