/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import com.sun.enterprise.security.auth.realm.Realm;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class RealmsManager {
    private Hashtable<String, Realm> loadedRealms = new Hashtable();
    private String defaultRealmName = "default";

    public boolean isValidRealm(String name) {
        if (name == null) {
            return false;
        }
        return this.loadedRealms.containsKey(name);
    }

    public Enumeration getRealmNames() {
        return this.loadedRealms.keys();
    }

    Realm _getInstance(String name) {
        Realm retval = null;
        retval = this.loadedRealms.get(name);
        if (retval == null && "default".equals(name)) {
            retval = this.loadedRealms.get(this.getDefaultRealmName());
        }
        return retval;
    }

    void removeFromLoadedRealms(String realmName) {
        this.loadedRealms.remove(realmName);
    }

    void putIntoLoadedRealms(String realmName, Realm realm) {
        this.loadedRealms.put(realmName, realm);
    }

    Realm getFromLoadedRealms(String realmName) {
        return this.loadedRealms.get(realmName);
    }

    public String getDefaultRealmName() {
        return this.defaultRealmName;
    }

    public void setDefaultRealmName(String defaultRealmName) {
        this.defaultRealmName = defaultRealmName;
    }
}

