/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-auth-realm")
@Scoped(value=PerLookup.class)
@I18n(value="delete.auth.realm")
public class DeleteAuthRealm
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteAuthRealm.class);
    @Param(name="authrealmname", primary=true)
    String authRealmName;
    @Inject
    SecurityService securityService;
    AuthRealm authRealm = null;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            for (AuthRealm realm : this.securityService.getAuthRealm()) {
                if (!realm.getName().equals(this.authRealmName)) continue;
                this.authRealm = realm;
            }
            if (this.authRealm == null) {
                report.setMessage(localStrings.getLocalString("delete.auth.realm.notfound", "Authrealm named {0} not found", this.authRealmName));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ConfigSupport.apply(new SingleConfigCode<SecurityService>(){

                @Override
                public Object run(SecurityService param) throws PropertyVetoException, TransactionFailure {
                    param.getAuthRealm().remove(DeleteAuthRealm.this.authRealm);
                    return null;
                }
            }, this.securityService);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.auth.realm.fail", "Deletion of Authrealm {0} failed", this.authRealmName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

