/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.ResourceUtils;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-resource-ref")
@Scoped(value=PerLookup.class)
@I18n(value="delete.resource.ref")
public class DeleteResourceRef
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteResourceRef.class);
    @Param(optional=true)
    String target = "server";
    @Param(name="reference_name", primary=true)
    String refName;
    @Inject
    Server[] servers;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.isResourceRefExists()) {
            report.setMessage(localStrings.getLocalString("delete.resource.ref.doesNotExist", "A resource ref named {0} does not exist.", this.refName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            for (Server server : this.servers) {
                if (!server.getName().equals(this.target)) continue;
                ResourceUtils.deleteResourceRef(server, this.refName);
            }
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("delete.resource.ref.failed", "Resource ref {0} deletion failed", this.refName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(tfe);
            return;
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("delete.resource.ref.failed", "Resource ref {0} deletion failed", this.refName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean isResourceRefExists() {
        for (Server server : this.servers) {
            if (!server.getName().equals(this.target)) continue;
            for (ResourceRef ref : server.getResourceRef()) {
                if (!ref.getRef().equals(this.refName)) continue;
                return true;
            }
        }
        return false;
    }
}

