/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.JDBCResourceManager;
import java.util.ArrayList;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-jdbc-resources")
@Scoped(value=PerLookup.class)
@I18n(value="list.jdbc.resources")
public class ListJdbcResources
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListJdbcResources.class);
    @Inject
    JdbcResource[] resources;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            JDBCResourceManager jdbcMgr = new JDBCResourceManager();
            ArrayList list = jdbcMgr.list(this.resources);
            for (String jndiName : list) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(jndiName);
            }
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.jdbc.resources.failed", "List JDBC resources failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

