/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.v3.admin.V2DottedNameSupport;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set")
public class SetCommand
extends V2DottedNameSupport
implements AdminCommand {
    @Inject
    Domain domain;
    @Param(primary=true)
    String target;
    @Param
    String value;

    public void execute(AdminCommandContext context) {
        if (this.target.lastIndexOf(46) == -1) {
            context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
            context.getActionReport().setMessage("Invalid target " + this.target);
            return;
        }
        String attrName = this.target.substring(this.target.lastIndexOf(46) + 1);
        String pattern = this.target.substring(0, this.target.lastIndexOf(46));
        V2DottedNameSupport.TreeNode[] parentNodes = this.getAliasedParent(this.domain, pattern);
        HashMap<Dom, String> dottedNames = new HashMap<Dom, String>();
        for (V2DottedNameSupport.TreeNode parentNode : parentNodes) {
            dottedNames.putAll(this.getAllDottedNodes(parentNode.node));
        }
        pattern = parentNodes[0].relativeName;
        Map<Dom, String> matchingNodes = this.getMatchingNodes(dottedNames, pattern);
        HashMap<ConfigBean, Map<String, String>> changes = new HashMap<ConfigBean, Map<String, String>>();
        HashMap<String, String> attrChanges = new HashMap<String, String>();
        attrChanges.put(attrName, this.value);
        for (Map.Entry<Dom, String> node : matchingNodes.entrySet()) {
            Dom targetNode = node.getKey();
            for (String name : targetNode.getAttributeNames()) {
                if (!attrName.equals(name)) continue;
                ActionReport.MessagePart part = context.getActionReport().getTopMessagePart().addChild();
                part.setChildrenType("DottedName");
                part.setMessage(node.getValue() + "." + name + "=" + this.value);
                changes.put((ConfigBean)node.getKey(), attrChanges);
            }
        }
        if (!changes.isEmpty()) {
            try {
                ConfigSupport.apply(changes);
            }
            catch (TransactionFailure transactionFailure) {
                context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
                context.getActionReport().setFailureCause(transactionFailure);
                context.getActionReport().setMessage("Could not change the attributes : " + transactionFailure.getMessage());
            }
        }
        context.getActionReport().setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

