/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.adapter;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemApplications;
import com.sun.enterprise.util.zip.ZipFile;
import com.sun.enterprise.v3.admin.adapter.AdapterState;
import com.sun.enterprise.v3.admin.adapter.ProgressObject;
import com.sun.enterprise.v3.server.ServerEnvironmentImpl;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InstallerThread
extends Thread {
    private final List<URL> urls;
    private final File toFile;
    private final String proxyHost;
    private final int proxyPort;
    private final ProgressObject progress;
    private final Domain domain;
    private final ServerEnvironmentImpl env;
    private final String contextRoot;

    InstallerThread(List<URL> urls, File toFile, String proxyHost, int proxyPort, ProgressObject progress, Domain domain, ServerEnvironmentImpl env, String contextRoot) {
        this.urls = urls;
        this.toFile = toFile;
        this.toFile.getParentFile().mkdirs();
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.progress = progress;
        this.domain = domain;
        this.env = env;
        this.contextRoot = contextRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.download();
            this.expand();
            this.install();
            ProgressObject progressObject = this.progress;
            synchronized (progressObject) {
                this.progress.finish();
                this.progress.setAdapterState(AdapterState.APPLICATION_INSTALLED_BUT_NOT_LOADED);
            }
        }
        catch (Exception e) {
            ProgressObject progressObject = this.progress;
            synchronized (progressObject) {
                this.progress.finish();
                this.progress.setMessage(e.getMessage());
                this.progress.setAdapterState(AdapterState.APPLICATION_NOT_INSTALLED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncMessage(String s) {
        ProgressObject progressObject = this.progress;
        synchronized (progressObject) {
            this.progress.setMessage(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download() throws Exception {
        Proxy proxy = Proxy.NO_PROXY;
        if (this.proxyHost != null && !"".equals(this.proxyHost)) {
            InetSocketAddress address = new InetSocketAddress(this.proxyHost, this.proxyPort);
            proxy = new Proxy(Proxy.Type.HTTP, address);
        }
        URLConnection uc = null;
        URL theUrl = null;
        for (URL url : this.urls) {
            HttpURLConnection http;
            uc = url.openConnection(proxy);
            if (!(uc instanceof HttpURLConnection) || (http = (HttpURLConnection)uc).getResponseCode() != 200) continue;
            theUrl = url;
            break;
        }
        this.syncMessage("Starting download from: " + theUrl);
        BufferedInputStream bis = new BufferedInputStream(uc.getInputStream());
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.toFile));
        try {
            int read;
            byte[] bytes = new byte[8192];
            while ((read = bis.read(bytes)) != -1) {
                bos.write(bytes, 0, read);
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException io) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException io) {}
            }
        }
        this.syncMessage("Finished downloading: " + uc.getContentLength() + " bytes from: " + theUrl);
    }

    private void expand() throws Exception {
        this.syncMessage("Expanding the archive: " + this.toFile.getAbsolutePath());
        File expFolder = new File(this.toFile.getParentFile(), "__admingui");
        expFolder.mkdirs();
        ZipFile zip = new ZipFile(this.toFile, expFolder);
        ArrayList list = zip.explode();
        this.syncMessage("Expanded the archive with :" + list.size() + " entries, at: " + this.toFile.getParentFile().getAbsolutePath());
    }

    private void install() throws Exception {
        this.syncMessage("Installing the application ...");
        ConfigCode code = new ConfigCode(){

            public Object run(ConfigBeanProxy ... proxies) throws PropertyVetoException, TransactionFailure {
                SystemApplications sa = (SystemApplications)proxies[0];
                Application app = ConfigSupport.createChildOf(sa, Application.class);
                sa.getModules().add(app);
                app.setName("__admingui");
                app.setEnabled(Boolean.TRUE.toString());
                app.setObjectType("system-admin");
                app.setDirectoryDeployed("true");
                app.setContextRoot(InstallerThread.this.contextRoot);
                File expFolder = new File(InstallerThread.this.toFile.getParentFile(), "__admingui");
                try {
                    app.setLocation(expFolder.toURL().toURI().toString());
                }
                catch (Exception me) {
                    throw new RuntimeException(me);
                }
                Engine webe = ConfigSupport.createChildOf(app, Engine.class);
                webe.setSniffer("web");
                Engine sece = ConfigSupport.createChildOf(app, Engine.class);
                sece.setSniffer("security");
                app.getEngine().add(webe);
                app.getEngine().add(sece);
                Server s = (Server)proxies[1];
                List<ApplicationRef> arefs = s.getApplicationRef();
                ApplicationRef aref = ConfigSupport.createChildOf(s, ApplicationRef.class);
                aref.setRef(app.getName());
                aref.setEnabled(Boolean.TRUE.toString());
                arefs.add(aref);
                return true;
            }
        };
        Server server = this.domain.getServerNamed(this.env.getInstanceName());
        ConfigSupport.apply(code, this.domain.getSystemApplications(), server);
        this.syncMessage("Installed the application ...");
    }
}

