/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.logging.LogDomains;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnifferAnnotationScanner
implements ClassVisitor {
    Map<String, SnifferStatus> annotations = new HashMap<String, SnifferStatus>();
    String className;
    String signature;
    static final Logger logger = LogDomains.getLogger("javax.enterprise.system.core");

    public void register(Sniffer sniffer, Class[] annotationClasses) {
        SnifferStatus stat = new SnifferStatus(sniffer);
        if (annotationClasses != null) {
            for (Class annClass : annotationClasses) {
                this.annotations.put(Type.getDescriptor(annClass), stat);
            }
        }
    }

    public List<Sniffer> getApplicableSniffers() {
        ArrayList<Sniffer> appSniffers = new ArrayList<Sniffer>();
        for (String annotationName : this.annotations.keySet()) {
            SnifferStatus stat = this.annotations.get(annotationName);
            if (appSniffers.contains(stat.sniffer) || !stat.found) continue;
            appSniffers.add(stat.sniffer);
        }
        return appSniffers;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.signature = signature;
    }

    @Override
    public void visitSource(String s, String s1) {
    }

    @Override
    public void visitOuterClass(String s, String s1, String s2) {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String s, boolean b) {
        SnifferStatus status = this.annotations.get(s);
        if (status != null) {
            status.found = true;
        }
        return null;
    }

    @Override
    public void visitAttribute(Attribute attribute) {
    }

    @Override
    public void visitInnerClass(String s, String s1, String s2, int i) {
    }

    @Override
    public FieldVisitor visitField(int i, String s, String s1, String s2, Object o) {
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int i, String s, String s1, String s2, String[] strings) {
        return null;
    }

    @Override
    public void visitEnd() {
    }

    public void scanArchive(ReadableArchive archive) {
        try {
            int crFlags = 7;
            Enumeration<String> entries = archive.entries();
            while (entries.hasMoreElements()) {
                String entryName = entries.nextElement();
                if (!entryName.endsWith(".class")) continue;
                InputStream is = archive.getEntry(entryName);
                ClassReader cr = new ClassReader(is);
                cr.accept(this, crFlags);
            }
        }
        catch (Exception e) {
            logger.warning("Failed to scan archive for annotations" + e.getMessage());
        }
    }

    private static final class SnifferStatus {
        Sniffer sniffer;
        boolean found;

        SnifferStatus(Sniffer sniffer) {
            this.sniffer = sniffer;
        }
    }
}

