/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.v3.admin.AdminAdapter;
import com.sun.enterprise.v3.services.impl.EndpointMapper;
import com.sun.enterprise.v3.services.impl.GrizzlyEmbeddedHttp;
import com.sun.enterprise.v3.services.impl.GrizzlyEmbeddedHttpConfigurator;
import com.sun.enterprise.v3.services.impl.GrizzlyServiceListener;
import com.sun.enterprise.v3.services.impl.NetworkProxy;
import com.sun.enterprise.v3.services.impl.V3Mapper;
import com.sun.enterprise.v3.services.impl.VirtualHostMapper;
import com.sun.grizzly.Controller;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.deployment.ApplicationContainer;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyProxy
implements NetworkProxy {
    protected GrizzlyServiceListener grizzlyListener;
    final Logger logger;
    final HttpListener httpListener;
    final HttpService httpService;
    private EndpointMapper<Adapter> endPointMapper;
    private VirtualHostMapper vsMapper;
    private int portNumber;
    private static final boolean isWebProfile = Boolean.parseBoolean(System.getProperty("v3.grizzly.webProfile", "true"));
    private static List<String> nvVsMapper = new ArrayList<String>();

    public GrizzlyProxy(Logger logger, Habitat habitat, HttpListener httpListener, Controller controller, HttpService httpService) {
        this.logger = logger;
        this.httpListener = httpListener;
        this.httpService = httpService;
        String port = httpListener.getPort();
        this.portNumber = 8080;
        if (port == null) {
            logger.severe("Cannot find port information from domain.xml");
            throw new RuntimeException("Cannot find port information from domain configuration");
        }
        try {
            this.portNumber = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            logger.severe("Cannot parse port value : " + port + ", using port 8080");
        }
        this.configureGrizzly(this.portNumber, controller, habitat);
    }

    private void configureGrizzly(int port, Controller controller, Habitat habitat) {
        this.grizzlyListener = new GrizzlyServiceListener(controller);
        GrizzlyEmbeddedHttpConfigurator.configureEmbeddedHttp(this.grizzlyListener, this.httpService, this.httpListener, port, controller);
        this.endPointMapper = this.grizzlyListener.configureEndpointMapper(isWebProfile);
        GrizzlyEmbeddedHttp geh = this.grizzlyListener.getEmbeddedHttp();
        V3Mapper mapper = new V3Mapper(this.logger);
        mapper.setPort(port);
        geh.getContainerMapper().setMapper((Mapper)mapper);
        geh.getContainerMapper().configureMapper();
        ExistingSingletonInhabitant<V3Mapper> onePortMapper = new ExistingSingletonInhabitant<V3Mapper>(mapper);
        habitat.addIndex(onePortMapper, "com.sun.grizzly.util.http.mapper.Mapper", String.valueOf(port));
    }

    @Override
    public void stop() {
        this.grizzlyListener.stop();
    }

    public String toString() {
        return "Grizzly on port " + this.httpListener.getPort();
    }

    @Override
    public void registerEndpoint(String contextRoot, Collection<String> vsServers, Adapter endpointAdapter, ApplicationContainer container) throws EndpointRegistrationException {
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        if (!nvVsMapper.contains(endpointAdapter.getClass().getName())) {
            this.vsMapper.registerEndpoint(contextRoot, vsServers, endpointAdapter, container);
            endpointAdapter = this.vsMapper;
        }
        this.endPointMapper.registerEndpoint(contextRoot, vsServers, endpointAdapter, container);
    }

    @Override
    public void unregisterEndpoint(String contextRoot, ApplicationContainer app) throws EndpointRegistrationException {
        this.endPointMapper.unregisterEndpoint(contextRoot, app);
        this.vsMapper.unregisterEndpoint(contextRoot, app);
    }

    public String getContextRoot() {
        return "/";
    }

    @Override
    public Future<Result<Thread>> start() {
        final GrizzlyFuture future = new GrizzlyFuture();
        Thread thread = new Thread(){

            public void run() {
                try {
                    GrizzlyProxy.this.grizzlyListener.start(future);
                }
                catch (InstantiationException e) {
                    GrizzlyProxy.this.logger.log(Level.SEVERE, "Cannot start grizzly listener", e);
                }
                catch (IOException e) {
                    GrizzlyProxy.this.logger.log(Level.SEVERE, "Cannot start grizzly listener", e);
                }
                catch (RuntimeException e) {
                    GrizzlyProxy.this.logger.log(Level.INFO, "Exception in grizzly thread", e);
                }
                catch (Throwable e) {
                    GrizzlyProxy.this.logger.log(Level.INFO, e.getMessage(), e);
                }
            }
        };
        thread.start();
        this.logger.info("Listening on port " + this.grizzlyListener.getPort());
        return future;
    }

    @Override
    public void setVsMapper(VirtualHostMapper vsMapper) {
        this.vsMapper = vsMapper;
    }

    @Override
    public VirtualHostMapper getVsMapper() {
        return this.vsMapper;
    }

    @Override
    public int getPort() {
        return this.portNumber;
    }

    static {
        nvVsMapper.add("org.apache.catalina.connector.CoyoteAdapter");
        nvVsMapper.add(AdminAdapter.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class GrizzlyFuture
    implements Future<Result<Thread>> {
        Result<Thread> result;
        CountDownLatch latch = new CountDownLatch(1);

        public void setResult(Result<Thread> result) {
            this.result = result;
            this.latch.countDown();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.latch.getCount() == 0L;
        }

        @Override
        public Result<Thread> get() throws InterruptedException, ExecutionException {
            this.latch.await();
            return this.result;
        }

        @Override
        public Result<Thread> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.latch.await(timeout, unit);
            return this.result;
        }
    }
}

