/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.services.impl.GrizzlyProxy;
import com.sun.enterprise.v3.services.impl.NetworkProxy;
import com.sun.enterprise.v3.services.impl.VirtualHostMapper;
import com.sun.grizzly.Controller;
import com.sun.grizzly.tcp.Adapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.FutureProvider;
import org.glassfish.api.Startup;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.ApplicationContainer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class GrizzlyService
implements Startup,
RequestDispatcher,
PostConstruct,
PreDestroy,
FutureProvider<Result<Thread>> {
    @Inject(name="server-config")
    Config config;
    @Inject
    Logger logger;
    @Inject
    Habitat habitat;
    List<NetworkProxy> proxies = new ArrayList<NetworkProxy>();
    List<Future<Result<Thread>>> futures;
    private final Controller controller = new Controller();
    private Collection<String> hosts = new ArrayList<String>();

    public void addNetworkProxy(NetworkProxy proxy) {
        this.proxies.add(proxy);
    }

    public void removeNetworkProxy(int port) {
        NetworkProxy proxy = null;
        for (NetworkProxy p : this.proxies) {
            if (p.getPort() != port) continue;
            proxy = p;
        }
        if (proxy != null) {
            proxy.stop();
            this.proxies.remove(proxy);
        }
    }

    public Controller getController() {
        return this.controller;
    }

    @Override
    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    @Override
    public void postConstruct() {
        HttpService httpService = this.config.getHttpService();
        try {
            this.futures = new ArrayList<Future<Result<Thread>>>();
            for (HttpListener listener : httpService.getHttpListener()) {
                this.futures.add(this.createNetworkProxy(listener, httpService));
            }
            this.registerNetworkProxy();
        }
        catch (RuntimeException e) {
            this.logger.log(Level.WARNING, "Closing initialized network proxies");
            for (NetworkProxy proxy : this.proxies) {
                try {
                    proxy.stop();
                }
                catch (Exception proxyStopException) {
                    this.logger.log(Level.SEVERE, "Stop network proxy error ", proxyStopException);
                }
            }
            throw e;
        }
    }

    @Override
    public List<Future<Result<Thread>>> getFutures() {
        return this.futures;
    }

    public synchronized Future<Result<Thread>> createNetworkProxy(HttpListener listener, HttpService httpService) {
        GrizzlyProxy proxy = new GrizzlyProxy(this.logger, this.habitat, listener, this.controller, httpService);
        proxy.setVsMapper(new VirtualHostMapper(this.logger, listener));
        for (VirtualServer vs : httpService.getVirtualServer()) {
            List<String> vsListeners = StringUtils.parseStringList(vs.getHttpListeners(), " ,");
            if (vsListeners == null || vsListeners.size() == 0 || vsListeners.contains(listener.getId())) {
                proxy.getVsMapper().addVirtualServer(vs);
                if (!this.hosts.contains(vs.getId())) {
                    this.hosts.add(vs.getId());
                }
            }
            List<String> aliases = StringUtils.parseStringList(vs.getHosts(), " ,");
            for (String alias : aliases) {
                if (this.hosts.contains(alias)) continue;
                this.hosts.add(alias);
            }
        }
        Future<Result<Thread>> future = proxy.start();
        this.proxies.add(proxy);
        return future;
    }

    public void registerNetworkProxy() {
        for (org.glassfish.api.container.Adapter subAdapter : this.habitat.getAllByContract(org.glassfish.api.container.Adapter.class)) {
            try {
                this.registerEndpoint(subAdapter.getContextRoot(), this.hosts, subAdapter, null);
            }
            catch (EndpointRegistrationException e) {
                this.logger.log(Level.WARNING, "GrizzlyService endpoint registration problem", e);
            }
        }
    }

    @Override
    public void preDestroy() {
        for (NetworkProxy proxy : this.proxies) {
            proxy.stop();
        }
    }

    @Override
    public void registerEndpoint(String contextRoot, Adapter endpointAdapter, ApplicationContainer container) throws EndpointRegistrationException {
        this.registerEndpoint(contextRoot, this.hosts, endpointAdapter, container);
    }

    @Override
    public void registerEndpoint(String contextRoot, Collection<String> vsServers, Adapter endpointAdapter, ApplicationContainer container) throws EndpointRegistrationException {
        for (NetworkProxy proxy : this.proxies) {
            proxy.registerEndpoint(contextRoot, vsServers, endpointAdapter, container);
        }
    }

    @Override
    public void registerEndpoint(String contextRoot, int port, Collection<String> vsServers, Adapter endpointAdapter, ApplicationContainer container) throws EndpointRegistrationException {
        for (NetworkProxy proxy : this.proxies) {
            if (proxy.getPort() != port) continue;
            proxy.registerEndpoint(contextRoot, vsServers, endpointAdapter, container);
        }
    }

    @Override
    public void unregisterEndpoint(String contextRoot) throws EndpointRegistrationException {
        this.unregisterEndpoint(contextRoot, null);
    }

    @Override
    public void unregisterEndpoint(String contextRoot, ApplicationContainer app) throws EndpointRegistrationException {
        for (NetworkProxy proxy : this.proxies) {
            proxy.unregisterEndpoint(contextRoot, app);
        }
    }
}

