/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.WebModuleStats;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.ConnectionPool;
import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpFileCache;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpProtocol;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.KeepAlive;
import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.RequestProcessing;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SessionProperties;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.runtime.web.ManagerProperties;
import com.sun.enterprise.deployment.runtime.web.SessionManager;
import com.sun.enterprise.deployment.runtime.web.StoreProperties;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.deployment.util.WebValidatorWithoutCL;
import com.sun.enterprise.security.integration.RealmInitializer;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.web.AdHocServletInfo;
import com.sun.enterprise.web.AdHocWebModule;
import com.sun.enterprise.web.DebugMonitor;
import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.HealthChecker;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.PEAccessLogValve;
import com.sun.enterprise.web.PEWebContainerFeatureFactoryImpl;
import com.sun.enterprise.web.ProxyHandlerImpl;
import com.sun.enterprise.web.SchemaUpdater;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.V3WebappLoader;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebApplication;
import com.sun.enterprise.web.WebConnector;
import com.sun.enterprise.web.WebContainerStartStopOperation;
import com.sun.enterprise.web.WebContainerTimer;
import com.sun.enterprise.web.WebDebugMonitor;
import com.sun.enterprise.web.WebDeployer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.WebPipeline;
import com.sun.enterprise.web.connector.coyote.PECoyoteConnector;
import com.sun.enterprise.web.logger.IASLogger;
import com.sun.enterprise.web.monitor.impl.PwcServletStatsImpl;
import com.sun.enterprise.web.monitor.impl.PwcWebModuleStatsImpl;
import com.sun.enterprise.web.pluggable.WebContainerFeatureFactory;
import com.sun.enterprise.web.reconfig.HttpServiceConfigListener;
import com.sun.enterprise.web.stats.HTTPListenerStatsImpl;
import com.sun.enterprise.web.stats.PWCRequestStatsImpl;
import com.sun.enterprise.web.stats.PWCVirtualServerStatsImpl;
import com.sun.enterprise.web.stats.ServletStatsImpl;
import com.sun.enterprise.web.stats.WebModuleStatsImpl;
import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.hk2.component.ConstructorWomb;
import com.sun.logging.LogDomains;
import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.spi.NamingManager;
import javax.servlet.jsp.JspFactory;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.CoyoteAdapter;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.startup.TldConfig;
import org.apache.catalina.util.ServerInfo;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.xmlparser.ParserUtils;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.flashlight.provider.ProbeProviderFactory;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.web.loader.util.ASClassLoaderUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ObservableBean;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="com.sun.enterprise.web.WebContainer")
public class WebContainer
implements Container,
PostConstruct,
PreDestroy {
    public static final String DISPATCHER_MAX_DEPTH = "dispatcher-max-depth";
    static final int DEFAULT_REAP_INTERVAL = 60;
    public static final String JWS_APPCLIENT_EAR_NAME = "__JWSappclients";
    public static final String JWS_APPCLIENT_WAR_NAME = "sys";
    private static final String JWS_APPCLIENT_MODULE_NAME = "__JWSappclients:sys.war";
    private static final String DOC_BUILDER_FACTORY_PROPERTY = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String DOC_BUILDER_FACTORY_IMPL = "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl";
    private static final String DOL_DEPLOYMENT = "com.sun.enterprise.web.deployment.backend";
    protected static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    protected static WebContainer webContainer;
    private static boolean debugMonitoring;
    private static long debugMonitoringPeriodMS;
    private static WebContainerTimer _timer;
    protected static boolean useDOLforDeployment;
    @Inject
    Mapper[] mappers;
    @Inject
    Domain domain;
    @Inject
    ServerContext _serverContext;
    @Inject
    ComponentEnvManager componentEnvManager;
    @Inject(optional=true)
    DasConfig dasConfig;
    @Inject
    RequestDispatcher dispatcher;
    @Inject
    GrizzlyService grizzlyService;
    HashMap<String, Integer> portMap = new HashMap();
    HashMap<Integer, CoyoteAdapter> adapterMap = new HashMap();
    HashMap<String, WebConnector> connectorMap = new HashMap();
    EmbeddedWebContainer _embedded;
    Engine engine;
    String instanceName;
    private WebConnector jkConnector;
    private String _id = null;
    protected boolean globalAccessLoggingEnabled = true;
    protected String globalAccessLogBufferSize = null;
    protected String globalAccessLogWriteInterval = null;
    protected int defaultRedirectPort = -1;
    protected boolean catalinaCachingAllowed = true;
    @Inject
    protected ServerEnvironment instance = null;
    private Server _serverBean = null;
    protected static final ResourceBundle _rb;
    protected static MonitoringLevel monitoringLevel;
    protected Level _logLevel = null;
    protected int _debug = 0;
    private File _modulesWorkRoot = null;
    private String modulesStubRoot = null;
    protected File _modulesRoot = null;
    private File _appsWorkRoot = null;
    private File appsStubRoot = null;
    private boolean _reloadingEnabled = false;
    private int _pollInterval = 2;
    protected boolean _started = false;
    protected boolean globalSSOEnabled = true;
    protected WebContainerFeatureFactory webContainerFeatureFactory;
    boolean instanceEnableCookies = true;
    private Config cfg;
    private ServerConfigLookup serverConfigLookup;
    @Inject
    protected ProbeProviderFactory probeProviderFactory = null;
    private HealthChecker _healthChecker = null;

    @Override
    public void postConstruct() {
        WebContainer.setJspFactory();
        this._modulesWorkRoot = this.instance.getWebModuleCompileJspPath();
        this._appsWorkRoot = this.instance.getApplicationCompileJspPath();
        this._modulesRoot = this.instance.getApplicationRepositoryPath();
        this.setTldScan();
        this.modulesStubRoot = this.instance.getModuleStubPath();
        this.appsStubRoot = this.instance.getApplicationStubPath();
        File root = this._serverContext.getInstallRoot();
        File libRoot = new File(root, "lib");
        File schemas = new File(libRoot, "schemas");
        File dtds = new File(libRoot, "dtds");
        try {
            ParserUtils.setSchemaResourcePrefix(schemas.toURL().toString());
            ParserUtils.setDtdResourcePrefix(dtds.toURL().toString());
            ParserUtils.setEntityResolver(this._serverContext.getDefaultHabitat().getComponent(EntityResolver.class, "web"));
        }
        catch (MalformedURLException e) {
            _logger.log(Level.SEVERE, "Exception setting the schemas/dtds location", e);
        }
        this.instanceName = this._serverContext.getInstanceName();
        this.webContainerFeatureFactory = this._serverContext.getDefaultHabitat().getComponent(PEWebContainerFeatureFactoryImpl.class);
        Config cfg = this._serverContext.getDefaultHabitat().getComponent(Config.class);
        this.serverConfigLookup = new ServerConfigLookup(cfg);
        this.configureDynamicReloadingSettings();
        LogService logService = cfg.getLogService();
        this.initLogLevel(logService);
        this.initMonitoringLevel(cfg.getMonitoringService());
        String maxDepth = null;
        if (cfg.getWebContainer() != null) {
            maxDepth = cfg.getWebContainer().getPropertyValue(DISPATCHER_MAX_DEPTH);
        }
        if (maxDepth != null) {
            int depth = -1;
            try {
                depth = Integer.parseInt(maxDepth);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (depth > 0) {
                Request.setMaxDispatchDepth(depth);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Maximum depth for nested request dispatches set to " + maxDepth);
                }
            }
        }
        String logServiceFile = null;
        if (logService != null) {
            logServiceFile = logService.getFile();
        }
        this._embedded = new EmbeddedWebContainer(_logger, this._serverContext, this, logServiceFile);
        this._embedded.setCatalinaHome(this.instance.getDomainRoot().getAbsolutePath());
        this._embedded.setCatalinaBase(this.instance.getDomainRoot().getAbsolutePath());
        this._embedded.setUseNaming(false);
        if (this._debug > 1) {
            this._embedded.setDebug(this._debug);
        }
        this._embedded.setLogger(new IASLogger(_logger));
        this.engine = this._embedded.createEngine();
        this.engine.setParentClassLoader(EmbeddedWebContainer.class.getClassLoader());
        this._embedded.addEngine(this.engine);
        ((StandardEngine)this.engine).setDomain(this._serverContext.getDefaultDomainName());
        ((StandardEngine)this.engine).setName(this._serverContext.getDefaultDomainName());
        String serverInfo = System.getProperty("product.name");
        if (serverInfo != null) {
            ServerInfo.setServerInfo(serverInfo);
        } else {
            ServerInfo.setServerInfo(Version.getVersion());
            System.setProperty("product.name", Version.getVersion());
        }
        WebDebugMonitor debugMonitor = new WebDebugMonitor();
        HashMap monitorMap = debugMonitor.getDebugMonitoringDetails();
        debugMonitoring = (Boolean)monitorMap.get("debugMonitoring");
        debugMonitoringPeriodMS = (Long)monitorMap.get("debugMonitoringPeriodMS");
        if (debugMonitoring) {
            _timer.schedule((TimerTask)new DebugMonitor(this._embedded), 0L, debugMonitoringPeriodMS);
        }
        if (System.getProperty(DOC_BUILDER_FACTORY_PROPERTY) == null) {
            System.setProperty(DOC_BUILDER_FACTORY_PROPERTY, DOC_BUILDER_FACTORY_IMPL);
        }
        this.initInstanceSessionProperties();
        long btime = 0L;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("before schema check");
            btime = System.currentTimeMillis();
        }
        this.doSchemaCheck();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("after schema check time: " + (System.currentTimeMillis() - btime));
        }
        List<Config> configs = this.domain.getConfigs().getConfig();
        for (Config aConfig : configs) {
            HttpService httpService = aConfig.getHttpService();
            List<HttpListener> httpListeners = httpService.getHttpListener();
            for (HttpListener httpListener : httpListeners) {
                if ("admin-listener".equals(httpListener.getId())) continue;
                this.createHttpListener(httpListener, httpService);
            }
            this.createJKConnector(httpService);
            this.setDefaultRedirectPort(this.defaultRedirectPort);
            List<com.sun.enterprise.config.serverbeans.VirtualServer> virtualServers = httpService.getVirtualServer();
            for (com.sun.enterprise.config.serverbeans.VirtualServer vs : virtualServers) {
                this.createVirtualServer(vs, httpService, aConfig.getSecurityService());
                _logger.info("Created virtual server " + vs.getId());
            }
        }
        this.loadDefaultWebModules();
        this._started = true;
        try {
            this._embedded.start();
        }
        catch (LifecycleException le) {
            _logger.log(Level.SEVERE, "Unable to start web container", le);
            return;
        }
        ConstructorWomb<HttpServiceConfigListener> womb = new ConstructorWomb<HttpServiceConfigListener>(HttpServiceConfigListener.class, this._serverContext.getDefaultHabitat(), null);
        HttpServiceConfigListener configListener = (HttpServiceConfigListener)womb.get(null);
        ObservableBean bean = (ObservableBean)((Object)ConfigSupport.getImpl(configListener.httpService));
        bean.addListener(configListener);
        configListener.setContainer(this);
        configListener.setLogger(_logger);
    }

    @Override
    public void preDestroy() {
        try {
            this._embedded.stop();
        }
        catch (LifecycleException le) {
            _logger.log(Level.SEVERE, "Unable to stop web container", le);
            return;
        }
        _timer.cancel();
    }

    public ProbeProviderFactory getProbeProviderFactory() {
        return this.probeProviderFactory;
    }

    @Override
    public String getName() {
        return "Web";
    }

    public Class<? extends WebDeployer> getDeployer() {
        return WebDeployer.class;
    }

    protected WebConnector createHttpListener(HttpListener httpListener, HttpService httpService) {
        String address;
        if (!Boolean.valueOf(httpListener.getEnabled()).booleanValue()) {
            _logger.warning(httpListener.getId() + " HTTP listener is disabled " + Boolean.valueOf(httpListener.getEnabled()));
            return null;
        }
        int port = 8080;
        this.checkHostnameUniqueness(httpListener.getId(), httpService);
        try {
            port = Integer.parseInt(httpListener.getPort());
        }
        catch (NumberFormatException nfe) {
            String msg = _rb.getString("pewebcontainer.http_listener.invalid_port");
            msg = MessageFormat.format(msg, httpListener.getPort(), httpListener.getId());
            throw new IllegalArgumentException(msg);
        }
        boolean isSecure = Boolean.valueOf(httpListener.getSecurityEnabled());
        if (isSecure && this.defaultRedirectPort == -1) {
            this.defaultRedirectPort = port;
        }
        if ("any".equals(address = httpListener.getAddress()) || "ANY".equals(address) || "INADDR_ANY".equals(address)) {
            address = null;
        }
        WebConnector connector = (WebConnector)this._embedded.createConnector(address, port, isSecure);
        for (Mapper m : this.mappers) {
            if (m.getPort() != port) continue;
            connector.setMapper(m);
            break;
        }
        _logger.info("Created HTTP listener " + httpListener.getId());
        connector.setName(httpListener.getId());
        connector.configure(httpListener, isSecure, httpService);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "create.listenerport", new Object[]{port, connector});
        }
        this._embedded.addConnector(connector);
        this.portMap.put(httpListener.getId(), Integer.valueOf(httpListener.getPort()));
        CoyoteAdapter coyoteAdapter = new CoyoteAdapter(connector);
        this.adapterMap.put(Integer.valueOf(httpListener.getPort()), coyoteAdapter);
        this.connectorMap.put(httpListener.getId(), connector);
        if (this.defaultRedirectPort != -1) {
            connector.setRedirectPort(this.defaultRedirectPort);
        }
        return connector;
    }

    private void createJKConnector(HttpService httpService) {
        String portString = System.getProperty("com.sun.enterprise.web.connector.enableJK");
        if (portString == null) {
            return;
        }
        int port = 8009;
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException ex) {
            port = 8009;
        }
        this.jkConnector = (WebConnector)this._embedded.createConnector("0.0.0.0", port, "ajp");
        this.jkConnector.configureJKProperties();
        String defaultHost = "server";
        this.jkConnector.setDefaultHost(defaultHost);
        this.jkConnector.setDomain(this._serverContext.getDefaultDomainName());
        this.jkConnector.setName("httpd-listener");
        this.jkConnector.configureHttpProtocol(httpService.getHttpProtocol());
        _logger.log(Level.INFO, "Apache mod_jk/jk2 attached to virtual-server " + defaultHost + " listening on port: " + portString);
        this._embedded.addConnector(this.jkConnector);
    }

    private void setDefaultRedirectPort(int defaultRedirectPort) {
        if (defaultRedirectPort != -1) {
            Connector[] connectors = this._embedded.getConnectors();
            for (int i = 0; i < connectors.length; ++i) {
                if (connectors[i].getRedirectPort() != -1) continue;
                connectors[i].setRedirectPort(defaultRedirectPort);
            }
        }
    }

    public void configureHttpServiceProperties(HttpService httpService, PECoyoteConnector connector) {
        List<Property> httpServiceProps = httpService.getProperty();
        connector.setProxyHandler(new ProxyHandlerImpl());
        if (httpServiceProps != null) {
            for (Property httpServiceProp : httpServiceProps) {
                String propValue;
                String propName = httpServiceProp.getName();
                if (connector.configureHttpListenerProperty(propName, propValue = httpServiceProp.getValue())) continue;
                if ("connectionTimeout".equals(propName)) {
                    connector.setConnectionTimeout(Integer.parseInt(propValue));
                    continue;
                }
                if ("tcpNoDelay".equals(propName)) {
                    connector.setTcpNoDelay(ConfigBeansUtilities.toBoolean(propValue));
                    continue;
                }
                if ("traceEnabled".equals(propName)) {
                    connector.setAllowTrace(ConfigBeansUtilities.toBoolean(propValue));
                    continue;
                }
                if ("accessLoggingEnabled".equals(propName)) {
                    this.globalAccessLoggingEnabled = ConfigBeansUtilities.toBoolean(propValue);
                    continue;
                }
                if ("accessLogWriteInterval".equals(propName)) {
                    this.globalAccessLogWriteInterval = propValue;
                    continue;
                }
                if ("accessLogBufferSize".equals(propName)) {
                    this.globalAccessLogBufferSize = propValue;
                    continue;
                }
                if ("authPassthroughEnabled".equals(propName)) {
                    connector.setAuthPassthroughEnabled(ConfigBeansUtilities.toBoolean(propValue));
                    continue;
                }
                if ("ssl-session-timeout".equals(propName)) {
                    connector.setSSLSessionTimeout(propValue);
                    continue;
                }
                if ("ssl3-session-timeout".equals(propName)) {
                    connector.setSSL3SessionTimeout(propValue);
                    continue;
                }
                if ("ssl-cache-entries".equals(propName)) {
                    connector.setSSLSessionCacheSize(propValue);
                    continue;
                }
                if ("proxyHandler".equals(propName)) {
                    connector.setProxyHandler(propValue);
                    continue;
                }
                if ("sso-enabled".equals(propName)) {
                    this.globalSSOEnabled = ConfigBeansUtilities.toBoolean(propValue);
                    continue;
                }
                _logger.log(Level.WARNING, "pewebcontainer.invalid_http_service_property", httpServiceProp.getName());
            }
        }
    }

    private void checkHostnameUniqueness(String listenerId, HttpService httpService) {
        int j;
        ArrayList<com.sun.enterprise.config.serverbeans.VirtualServer> listenerVses = null;
        block0: for (com.sun.enterprise.config.serverbeans.VirtualServer vse : httpService.getVirtualServer()) {
            List<String> vsListeners = StringUtils.parseStringList(vse.getHttpListeners(), ",");
            for (j = 0; vsListeners != null && j < vsListeners.size(); ++j) {
                if (!listenerId.equals(vsListeners.get(j))) continue;
                if (listenerVses == null) {
                    listenerVses = new ArrayList<com.sun.enterprise.config.serverbeans.VirtualServer>();
                }
                listenerVses.add(vse);
                continue block0;
            }
        }
        if (listenerVses == null) {
            return;
        }
        for (int i = 0; i < listenerVses.size(); ++i) {
            com.sun.enterprise.config.serverbeans.VirtualServer vs = (com.sun.enterprise.config.serverbeans.VirtualServer)listenerVses.get(i);
            List<String> hosts = StringUtils.parseStringList(vs.getHosts(), ",");
            for (j = 0; hosts != null && j < hosts.size(); ++j) {
                String host = hosts.get(j);
                for (int k = 0; k < listenerVses.size(); ++k) {
                    if (k <= i) continue;
                    com.sun.enterprise.config.serverbeans.VirtualServer otherVs = (com.sun.enterprise.config.serverbeans.VirtualServer)listenerVses.get(k);
                    List<String> otherHosts = StringUtils.parseStringList(otherVs.getHosts(), ",");
                    for (int l = 0; otherHosts != null && l < otherHosts.size(); ++l) {
                        if (!host.equals(otherHosts.get(l))) continue;
                        _logger.log(Level.SEVERE, "pewebcontainer.duplicate_host_name", new Object[]{host, vs.getId(), otherVs.getId(), listenerId});
                    }
                }
            }
        }
    }

    public void createVirtualServer(com.sun.enterprise.config.serverbeans.VirtualServer vsBean, HttpService httpService, SecurityService securityService) {
        MimeMap mm = null;
        String vs_id = vsBean.getId();
        String docroot = vsBean.getPropertyValue("docroot");
        if (docroot == null) {
            docroot = vsBean.getDocroot();
        }
        this.validateDocroot(docroot, vs_id, vsBean.getDefaultWebModule());
        VirtualServer vs = this.createVS(vs_id, vsBean, docroot, mm, httpService.getHttpProtocol());
        Property cacheProp = vsBean.getProperty("setCacheControl");
        if (cacheProp != null) {
            vs.configureCacheControl(cacheProp.getValue());
        }
        List<String> aliasNames = StringUtils.parseStringList(vsBean.getHosts(), ",");
        for (String alias : aliasNames) {
            if ("${com.sun.aas.hostName}".equals(alias)) {
                try {
                    alias = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    _logger.log(Level.SEVERE, "Unable to get local host name", e);
                }
            }
            vs.addAlias(alias);
        }
        PEAccessLogValve accessLogValve = vs.getAccessLogValve();
        boolean startAccessLog = accessLogValve.configure(vs_id, vsBean, httpService, this.domain, this._serverContext.getDefaultHabitat(), this.webContainerFeatureFactory, this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval);
        if (startAccessLog && vs.isAccessLoggingEnabled(this.globalAccessLoggingEnabled)) {
            vs.addValve(accessLogValve);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Created virtual server " + vs_id);
        }
        this.configureHost(vs, httpService, securityService);
        this.engine.addChild(vs);
    }

    protected boolean validateDocroot(String docroot, String vs_id, String defaultWebModule) {
        if (docroot != null) {
            boolean isValid = new File(docroot).exists();
            if (!isValid && defaultWebModule == null) {
                String msg = _rb.getString("pewebcontainer.virtual_server.invalid_docroot");
                msg = MessageFormat.format(msg, vs_id, docroot);
                throw new IllegalArgumentException(msg);
            }
            if (!isValid) {
                _logger.log(Level.WARNING, "virtual-server " + vs_id + " has an invalid docroot: " + docroot);
            }
        } else if (defaultWebModule == null) {
            String msg = _rb.getString("pewebcontainer.virtual_server.missing_docroot");
            msg = MessageFormat.format(msg, vs_id);
            throw new IllegalArgumentException(msg);
        }
        return true;
    }

    protected void configureHost(VirtualServer vs, HttpService httpService, SecurityService securityService) {
        com.sun.enterprise.config.serverbeans.VirtualServer vsBean = vs.getBean();
        vs.configureAliases();
        List<String> listeners = StringUtils.parseStringList(vsBean.getHttpListeners(), ",");
        if (listeners == null) {
            return;
        }
        HttpListener[] httpListeners = new HttpListener[listeners.size()];
        for (int i = 0; i < listeners.size(); ++i) {
            for (HttpListener httpListener : httpService.getHttpListener()) {
                if (!httpListener.getId().equals(listeners.get(i))) continue;
                httpListeners[i] = httpListener;
            }
        }
        this.configureHostPortNumbers(vs, httpListeners);
        vs.configureCatalinaProperties();
        vs.configureAuthRealm(securityService);
    }

    protected void configureHostPortNumbers(VirtualServer vs, HttpListener[] httpListeners) {
        boolean addJkListenerPort = this.jkConnector != null && !vs.getName().equalsIgnoreCase("__asadmin");
        ArrayList<Integer> portsList = new ArrayList<Integer>();
        for (int i = 0; i < httpListeners.length; ++i) {
            if (Boolean.valueOf(httpListeners[i].getEnabled()).booleanValue()) {
                Integer port = this.portMap.get(httpListeners[i].getId());
                if (port == null) continue;
                portsList.add(port);
                continue;
            }
            if (!vs.getName().equalsIgnoreCase("__asadmin")) continue;
            String msg = _rb.getString("pewebcontainer.httpListener.mustNotDisable");
            msg = MessageFormat.format(msg, httpListeners[i].getId(), vs.getName());
            throw new IllegalArgumentException(msg);
        }
        int numPorts = portsList.size();
        if (addJkListenerPort) {
            ++numPorts;
        }
        if (numPorts > 0) {
            int[] ports = new int[numPorts];
            int i = 0;
            for (i = 0; i < portsList.size(); ++i) {
                ports[i] = (Integer)portsList.get(i);
                _logger.info("Virtual Server " + vs.getID() + " set port " + ports[i]);
            }
            if (addJkListenerPort) {
                ports[i] = this.jkConnector.getPort();
                _logger.info("Virtual Server " + vs.getID() + " set jk port " + ports[i]);
            }
            vs.setPorts(ports);
        }
    }

    private void enableVirtualServerMonitoring() {
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            org.apache.catalina.Container[] hostArray = engines[j].findChildren();
            for (int i = 0; i < hostArray.length; ++i) {
                VirtualServer vs = (VirtualServer)hostArray[i];
                this.enableVirtualServerMonitoring(vs);
            }
        }
    }

    private void enableVirtualServerMonitoring(VirtualServer vs) {
        ServerContext sc = this.getServerContext();
        MonitoringRegistry monitoringRegistry = sc.getDefaultHabitat().getComponent(MonitoringRegistry.class);
        PWCVirtualServerStatsImpl vsStats = new PWCVirtualServerStatsImpl(vs);
        try {
            monitoringRegistry.registerPWCVirtualServerStats(vsStats, vs.getID(), null);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Unable to register PWCVirtualServerStats for " + vs.getID(), e);
        }
        PWCRequestStatsImpl pwcRequestStatsImpl = new PWCRequestStatsImpl(sc.getDefaultDomainName());
        vs.setPWCRequestStatsImpl(pwcRequestStatsImpl);
        try {
            monitoringRegistry.registerPWCRequestStats(pwcRequestStatsImpl, vs.getID(), null);
        }
        catch (MonitoringRegistrationException mre) {
            String msg = _logger.getResourceBundle().getString("web.monitoringRegistrationError");
            msg = MessageFormat.format(msg, "PWCRequestStats");
            _logger.log(Level.WARNING, msg, mre);
        }
    }

    public void configureKeepAlive(HttpService httpService) {
        KeepAlive keepAlive = httpService.getKeepAlive();
        Connector[] connectors = this._embedded.findConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            ((PECoyoteConnector)connectors[i]).configureKeepAlive(keepAlive);
        }
    }

    public void configureConnectionPool(HttpService httpService) {
        ConnectionPool cp = httpService.getConnectionPool();
        Connector[] connectors = this._embedded.findConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            ((PECoyoteConnector)connectors[i]).configureConnectionPool(cp);
        }
    }

    public void configureHttpProtocol(HttpService httpService) {
        HttpProtocol httpProtocol = httpService.getHttpProtocol();
        Connector[] connectors = this._embedded.findConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            ((PECoyoteConnector)connectors[i]).configureHttpProtocol(httpProtocol);
        }
    }

    public void configureFileCache(HttpService httpService) {
        HttpFileCache httpFileCache = httpService.getHttpFileCache();
        Connector[] connectors = this._embedded.findConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            ((PECoyoteConnector)connectors[i]).configureFileCache(httpFileCache);
        }
    }

    public void configureRequestProcessing(HttpService httpService) {
        RequestProcessing rp = httpService.getRequestProcessing();
        Connector[] connectors = this._embedded.findConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            ((PECoyoteConnector)connectors[i]).configureRequestProcessing(rp);
        }
    }

    public String getID() {
        return this._id;
    }

    public HealthChecker getHealthChecker() {
        return this._healthChecker;
    }

    private void initHealthChecker() {
        HealthChecker healthChecker = null;
        try {
            healthChecker = this.webContainerFeatureFactory.getHADBHealthChecker(this);
        }
        catch (NoClassDefFoundError ex) {
            _logger.log(Level.WARNING, "hadbhealthchecker.hadbClientJarsMissing");
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("WebContainer>>initHealthChecker - healthChecker = " + healthChecker);
        }
        if (healthChecker != null) {
            this._healthChecker = healthChecker;
            try {
                this._healthChecker.start();
            }
            catch (LifecycleException lifecycleException) {
                // empty catch block
            }
        }
    }

    private void stopHealthChecker() {
        if (this._healthChecker != null) {
            try {
                this._healthChecker.stop();
            }
            catch (LifecycleException lifecycleException) {
                // empty catch block
            }
            this._healthChecker = null;
        }
    }

    public VirtualServer createVS(String vsID, com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String docroot, MimeMap mimeMap, HttpProtocol httpProtocol) {
        VirtualServer vs = (VirtualServer)this._embedded.createHost(vsID, vsBean, docroot, vsBean.getLogFile(), mimeMap);
        vs.configureRemoteAddressFilterValve();
        vs.configureRemoteHostFilterValve(httpProtocol);
        vs.configureSSOValve(this.globalSSOEnabled, this.webContainerFeatureFactory);
        vs.configureRedirect();
        vs.configureErrorPage();
        return vs;
    }

    private void doSchemaCheck() {
        SchemaUpdater schemaUpdater;
        block5: {
            schemaUpdater = null;
            try {
                schemaUpdater = this._serverContext.getDefaultHabitat().getComponent(SchemaUpdater.class);
            }
            catch (NoClassDefFoundError ex) {
                if (!_logger.isLoggable(Level.FINE)) break block5;
                _logger.fine("HADB Warning - client jars missing - ok if not running with HADB");
            }
        }
        if (schemaUpdater != null) {
            try {
                schemaUpdater.doSchemaCheck();
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "schemaupdater.error", ex);
            }
        }
    }

    public void stop() throws LifecycleException {
        ArrayList shutdownCleanupCapablesList;
        WebContainerStartStopOperation startStopOperation;
        block3: {
            if (!this._started) {
                String msg = _rb.getString("webcontainer.notStarted");
                throw new LifecycleException(msg);
            }
            this.stopHealthChecker();
            startStopOperation = this.getWebContainerStartStopOperation();
            shutdownCleanupCapablesList = startStopOperation.doPreStop();
            this._started = false;
            try {
                this._embedded.stop();
            }
            catch (LifecycleException ex) {
                if (ex.getMessage().indexOf("has not been started") != -1) break block3;
                throw ex;
            }
        }
        startStopOperation.doPostStop(shutdownCleanupCapablesList);
    }

    public WebContainerStartStopOperation getWebContainerStartStopOperation() {
        if (this.webContainerFeatureFactory == null) {
            return null;
        }
        WebContainerStartStopOperation startStopOperation = this.webContainerFeatureFactory.getWebContainerStartStopOperation();
        return startStopOperation;
    }

    protected void loadDefaultWebModules() {
        Engine[] engines = this._embedded.getEngines();
        String defaultPath = null;
        for (int j = 0; j < engines.length; ++j) {
            org.apache.catalina.Container[] vsArray = engines[j].findChildren();
            for (int i = 0; i < vsArray.length; ++i) {
                if (!(vsArray[i] instanceof VirtualServer)) continue;
                VirtualServer vs = (VirtualServer)vsArray[i];
                WebModuleConfig wmInfo = vs.getDefaultWebModule(this.domain, this._serverContext.getDefaultHabitat().getComponent(WebDeployer.class));
                if (wmInfo != null) {
                    defaultPath = wmInfo.getContextPath();
                    try {
                        this.updateDefaultWebModule(vs, vs.getPorts(), wmInfo);
                    }
                    catch (LifecycleException le) {
                        String msg = _rb.getString("webcontainer.defaultWebModuleError");
                        msg = MessageFormat.format(msg, defaultPath, vs.getName());
                        _logger.log(Level.SEVERE, msg, le);
                    }
                    continue;
                }
                wmInfo = vs.createSystemDefaultWebModuleIfNecessary(this._serverContext.getDefaultHabitat().getComponent(WebDeployer.class));
                if (wmInfo != null) {
                    defaultPath = wmInfo.getContextPath();
                    this.loadStandaloneWebModule(vs, wmInfo);
                }
                for (int port : vs.getPorts()) {
                    if (this.jkConnector != null && port == this.jkConnector.getPort()) continue;
                    CoyoteAdapter adapter = this.adapterMap.get(port);
                    WebApplication application = new WebApplication(this, wmInfo, this.dispatcher);
                    try {
                        this.dispatcher.registerEndpoint(wmInfo.getContextPath(), adapter, application);
                    }
                    catch (EndpointRegistrationException e) {
                        String msg = _rb.getString("webcontainer.defaultWebModuleError");
                        msg = MessageFormat.format(msg, defaultPath, vs.getName());
                        _logger.log(Level.SEVERE, msg, e);
                    }
                }
            }
        }
    }

    protected void loadStandaloneWebModule(VirtualServer vs, WebModuleConfig wmInfo) {
        this.loadWebModule(vs, wmInfo, "null");
    }

    protected void loadAllJ2EEApplicationWebModules() {
        this.loadAllJ2EEApplicationWebModules(false);
    }

    private void loadAllJ2EEApplicationWebModules(boolean isStartUp) {
        Domain domain = this._serverContext.getDefaultHabitat().getComponent(Domain.class);
        Applications appsBean = domain.getApplications();
        if (appsBean != null) {
            for (J2eeApplication module : appsBean.getModules(J2eeApplication.class)) {
                if (!this.isReferenced(module.getName())) continue;
                this.loadJ2EEApplicationWebModules(module);
            }
        }
    }

    public void loadJ2EEApplicationWebModules(J2eeApplication j2eeAppBean) {
    }

    protected boolean isEnabled(String moduleName) {
        Domain domain = this._serverContext.getDefaultHabitat().getComponent(Domain.class);
        return true;
    }

    public List<Result<WebModule>> loadWebModule(WebModuleConfig wmInfo, String j2eeApplication) {
        String vsIDs = wmInfo.getVirtualServers();
        List<String> vsList = StringUtils.parseStringList(vsIDs, " ,");
        boolean loadToAll = vsList == null || vsList.size() == 0;
        boolean loadAtLeastToOne = false;
        Engine[] engines = this._embedded.getEngines();
        ArrayList<Result<WebModule>> results = new ArrayList<Result<WebModule>>();
        for (int j = 0; j < engines.length; ++j) {
            org.apache.catalina.Container[] vsArray = engines[j].findChildren();
            for (int i = 0; i < vsArray.length; ++i) {
                VirtualServer vs;
                if (!(vsArray[i] instanceof VirtualServer) || (vs = (VirtualServer)vsArray[i]).getID().equals("__asadmin") && loadToAll || !loadToAll && !vsList.contains(vs.getID()) && !this.verifyAlias(vsList, vs)) continue;
                results.add(this.loadWebModule(vs, wmInfo, j2eeApplication));
                loadAtLeastToOne = true;
            }
        }
        if (!loadAtLeastToOne) {
            Object[] params = new Object[]{wmInfo.getName(), vsIDs};
            _logger.log(Level.SEVERE, "webcontainer.moduleNotLoadedToVS", params);
        }
        return results;
    }

    private boolean verifyAlias(List vsList, VirtualServer vs) {
        for (int i = 0; i < vs.getAliases().length; ++i) {
            if (!vsList.contains(vs.getAliases()[i])) continue;
            return true;
        }
        return false;
    }

    protected Result<WebModule> loadWebModule(VirtualServer vs, WebModuleConfig wmInfo, String j2eeApplication) {
        Result<WebModule> result;
        ClassLoader parentLoader;
        String wmName = wmInfo.getName();
        String wmContextPath = wmInfo.getContextPath();
        if (wmContextPath.equals("") && vs.getDefaultWebModuleID() != null) {
            _logger.log(Level.WARNING, "webcontainer.defaultWebModuleConflict", new Object[]{wmName, wmContextPath, vs.getID()});
            return null;
        }
        String displayContextPath = null;
        displayContextPath = wmContextPath.equals("") ? "/" : wmContextPath;
        HashMap adHocPaths = null;
        HashMap adHocSubtrees = null;
        WebModule ctx = (WebModule)vs.findChild(wmContextPath);
        if (ctx != null) {
            if (ctx instanceof AdHocWebModule) {
                if (ctx.hasAdHocPaths()) {
                    adHocPaths = ctx.getAdHocPaths();
                }
                if (ctx.hasAdHocSubtrees()) {
                    adHocSubtrees = ctx.getAdHocSubtrees();
                }
                vs.removeChild(ctx);
            } else if ("__default-web-module".equals(ctx.getModuleName())) {
                this.unloadWebModule(wmContextPath, ctx.getJ2EEApplication(), vs.getName(), null, true);
            } else {
                if (!ctx.getAvailable()) {
                    ctx.setAvailable(true);
                    return null;
                }
                Object[] params = new Object[]{vs.getID(), displayContextPath, wmName};
                _logger.log(Level.WARNING, "webcontainer.duplicateContextRoot", params);
                return null;
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            Object[] params = new Object[]{wmName, vs.getID(), displayContextPath};
            _logger.log(Level.FINEST, "webcontainer.loadModule", params);
        }
        File docBase = null;
        docBase = JWS_APPCLIENT_MODULE_NAME.equals(wmName) ? new File(System.getProperty("com.sun.aas.installRoot")) : wmInfo.getLocation();
        WebBundleDescriptor wbd = wmInfo.getDescriptor();
        Throwable exception = null;
        String compEnvId = null;
        try {
            compEnvId = this.componentEnvManager.bindToComponentNamespace(wbd);
        }
        catch (Exception ex) {
            exception = ex;
        }
        ctx = (WebModule)this._embedded.createContext(wmContextPath, docBase, vs.getDefaultContextXmlLocation(), vs.getDefaultWebXmlLocation(), useDOLforDeployment, wmInfo.getDescriptor(), compEnvId);
        ctx.setUseNaming(false);
        Engine engine = (Engine)vs.getParent();
        if (engine != null) {
            ctx.setEngineName(engine.getName());
            ctx.setJvmRoute(engine.getJvmRoute());
        }
        String j2eeServer = this._serverContext.getInstanceName();
        String domain = this._serverContext.getDefaultDomainName();
        String server = domain + ":j2eeType=J2EEServer,name=" + j2eeServer;
        ctx.setDomain(domain);
        ctx.setJ2EEServer(j2eeServer);
        ctx.setJ2EEApplication(j2eeApplication);
        ctx.setServer(server);
        ctx.setCachingAllowed(false);
        ctx.setCacheControls(vs.getCacheControls());
        ctx.setBean(wmInfo.getBean());
        if (adHocPaths != null) {
            ctx.addAdHocPaths(adHocPaths);
        }
        if (adHocSubtrees != null) {
            ctx.addAdHocSubtrees(adHocSubtrees);
        }
        if (wmInfo.getDescriptor() != null) {
            ctx.setContextRoot(wmInfo.getDescriptor().getContextRoot());
        } else {
            _logger.log(Level.WARNING, "Unable to set context root", wmInfo);
        }
        String wmInfoWorkDir = wmInfo.getWorkDir();
        if (wmInfoWorkDir != null) {
            StringBuffer workDir = new StringBuffer(wmInfo.getWorkDir());
            if (wmName.equals("__default-web-module")) {
                workDir.append("-");
                workDir.append(FileUtils.makeFriendlyFilename(vs.getID()));
            }
            ctx.setWorkDir(workDir.toString());
        }
        if ((parentLoader = wmInfo.getParentLoader()) == null) {
            parentLoader = this._serverContext.getSharedClassLoader();
        }
        ctx.setParentClassLoader(parentLoader);
        try {
            if (wbd != null) {
                String altDDName = wbd.getModuleDescriptor().getAlternateDescriptor();
                if (altDDName != null) {
                    String appName = wmName.substring(0, wmName.indexOf(":"));
                    ServerEnvironment env = this._serverContext.getDefaultHabitat().getComponent(ServerEnvironment.class);
                    String appLoc = env.getApplicationGeneratedXMLPath() + File.separator + appName;
                    if (!FileUtils.safeIsDirectory(appLoc)) {
                        appLoc = wmInfo.getLocation() + "/..";
                    }
                    altDDName = altDDName.startsWith("/") ? appLoc + altDDName.trim() : appLoc + "/" + altDDName.trim();
                    Object[] objs = new Object[]{altDDName, wmName};
                    _logger.log(Level.INFO, "webcontainer.altDDName", objs);
                    ctx.setAltDDName(altDDName);
                }
                if (wbd.hasWebServices()) {
                    ctx.setHasWebServices(true);
                    WebServicesDescriptor webService = wbd.getWebServices();
                    Vector<String> endpointList = new Vector<String>();
                    for (WebServiceEndpoint wse : webService.getEndpoints()) {
                        if (wbd.getContextRoot() != null) {
                            endpointList.add(wbd.getContextRoot() + "/" + wse.getEndpointAddressUri());
                            continue;
                        }
                        endpointList.add(wse.getEndpointAddressUri());
                    }
                    Object[] endpointAddresses = new String[endpointList.size()];
                    endpointList.copyInto(endpointAddresses);
                    ctx.setEndpointAddresses((String[])endpointAddresses);
                } else {
                    ctx.setHasWebServices(false);
                }
            }
            SunWebApp iasBean = null;
            if (wbd != null) {
                iasBean = wbd.getSunDescriptor();
            }
            ctx.setIasWebAppConfigBean(iasBean);
            ctx.setID(wmName);
            ctx.configureMiscSettings(iasBean, vs, displayContextPath);
            if ("__default-web-module".equals(ctx.getID())) {
                ctx.setAlternateDocBases(vs.getProperties());
            }
            Loader loader = this.configureLoader(ctx, iasBean, wmInfo);
            if (wbd != null && wbd.hasWebServices()) {
                wbd.addExtraAttribute("WEBLOADER", loader);
            }
            if (this._reloadingEnabled) {
                // empty if block
            }
            ctx.configureSessionSettings(wbd, wmInfo);
            ctx.setI18nInfo();
            if (wbd != null) {
                NamingManager namingMgr;
                boolean isSystem;
                String resourceType = wmInfo.getObjectType();
                boolean bl = isSystem = resourceType != null && resourceType.startsWith("system-");
                if (!wmName.startsWith("__default-web-module")) {
                    Realm realm = this._serverContext.getDefaultHabitat().getByContract(Realm.class);
                    if ("null".equals(j2eeApplication)) {
                        if (realm != null && realm instanceof RealmInitializer) {
                            ((RealmInitializer)((Object)realm)).initializeRealm(wbd, isSystem, vs.getAuthRealmName());
                            ctx.setRealm(realm);
                        }
                    } else if (realm != null && realm instanceof RealmInitializer) {
                        ((RealmInitializer)((Object)realm)).initializeRealm(wbd, isSystem, null);
                        ctx.setRealm(realm);
                    }
                }
                if (wbd.getApplication() != null && wbd.getApplication().isVirtual()) {
                    wbd.visit(new WebValidatorWithoutCL());
                }
                if ((namingMgr = this._serverContext.getDefaultHabitat().getComponent(NamingManager.class)) != null) {
                    Method m = namingMgr.getClass().getMethod("bindObjects", Object.class);
                    m.invoke((Object)namingMgr, wbd);
                }
            }
            this.addMimeMappings(ctx, vs.getMimeMap());
        }
        catch (Throwable ex) {
            exception = ex;
        }
        if (wbd != null && wbd.getApplication() != null) {
            String moduleName = wbd.getApplication().isVirtual() ? wbd.getApplication().getRegistrationName() : wbd.getModuleDescriptor().getArchiveUri();
            ctx.setModuleName(moduleName);
        } else {
            ctx.setModuleName("__default-web-module");
        }
        try {
            vs.addChild(ctx);
        }
        catch (Throwable ex) {
            exception = ex;
        }
        if (exception != null) {
            ctx.setAvailable(false);
            _logger.log(Level.SEVERE, "webcontainer.webModuleDisabled", exception);
            result = new Result(exception);
        } else {
            result = new Result<WebModule>(ctx);
        }
        this.enableWSMonitoring(wbd, j2eeServer);
        return result;
    }

    protected void updateDefaultWebModule(VirtualServer virtualServer, int[] ports, WebModuleConfig wmInfo) throws LifecycleException {
        String defaultContextPath = wmInfo.getContextPath();
        if (defaultContextPath != null && !defaultContextPath.startsWith("/")) {
            defaultContextPath = "/" + defaultContextPath;
            wmInfo.getDescriptor().setContextRoot(defaultContextPath);
        }
        Connector[] connectors = this._embedded.findConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            PECoyoteConnector conn = (PECoyoteConnector)connectors[i];
            int port = conn.getPort();
            for (int j = 0; j < ports.length; ++j) {
                if (port != ports[j]) continue;
                Mapper mapper = conn.getMapper();
                try {
                    mapper.setDefaultContextPath(virtualServer.getName(), defaultContextPath);
                    CoyoteAdapter adapter = this.adapterMap.get(port);
                    WebApplication application = new WebApplication(this, wmInfo, this.dispatcher);
                    this.dispatcher.registerEndpoint("/", adapter, application);
                    continue;
                }
                catch (Exception e) {
                    throw new LifecycleException(e);
                }
            }
        }
    }

    public ServerContext getServerContext() {
        return this._serverContext;
    }

    ServerConfigLookup getServerConfigLookup() {
        return this.serverConfigLookup;
    }

    File getAppsWorkRoot() {
        return this._appsWorkRoot;
    }

    File getModulesWorkRoot() {
        return this._modulesWorkRoot;
    }

    private Loader configureLoader(WebModule ctx, SunWebApp bean, WebModuleConfig wmInfo) {
        com.sun.enterprise.deployment.runtime.web.ClassLoader clBean = null;
        V3WebappLoader loader = new V3WebappLoader(wmInfo.getAppClassLoader());
        loader.setUseMyFaces(ctx.isUseMyFaces());
        if (bean != null) {
            clBean = bean.getClassLoader();
        }
        if (clBean != null) {
            this.configureLoaderAttributes(loader, clBean, ctx);
            this.configureLoaderProperties(loader, clBean);
        } else {
            loader.setDelegate(true);
        }
        String stubPath = wmInfo.getStubPath();
        if (stubPath != null) {
            loader.addRepository("file:" + stubPath + File.separator);
        }
        this.addLibs(loader, ctx);
        String packagesName = System.getProperty("com.sun.enterprise.overrideablejavaxpackages");
        if (packagesName != null) {
            List<String> overridablePackages = StringUtils.parseStringList(packagesName, " ,");
            for (int i = 0; i < overridablePackages.size(); ++i) {
                loader.addOverridablePackage(overridablePackages.get(i));
            }
        }
        ctx.setLoader(loader);
        return loader;
    }

    public String getApplicationId(WebModule wm) {
        return wm.getID();
    }

    public File getModulesRoot() {
        return this._modulesRoot;
    }

    private String getPersistenceFrequency(SessionManager smBean) {
        String persistenceFrequency = null;
        ManagerProperties mgrBean = smBean.getManagerProperties();
        if (mgrBean != null && mgrBean.sizeWebProperty() > 0) {
            WebProperty[] props = mgrBean.getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (name == null || value == null) {
                    throw new IllegalArgumentException(_rb.getString("webcontainer.nullWebProperty"));
                }
                if (!name.equalsIgnoreCase("persistenceFrequency")) continue;
                persistenceFrequency = value;
                break;
            }
        }
        return persistenceFrequency;
    }

    private String getPersistenceScope(SessionManager smBean) {
        String persistenceScope = null;
        StoreProperties storeBean = smBean.getStoreProperties();
        if (storeBean != null && storeBean.sizeWebProperty() > 0) {
            WebProperty[] props = storeBean.getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (name == null || value == null) {
                    throw new IllegalArgumentException(_rb.getString("webcontainer.nullWebProperty"));
                }
                if (!name.equalsIgnoreCase("persistenceScope")) continue;
                persistenceScope = value;
                break;
            }
        }
        return persistenceScope;
    }

    public void unloadWebModule(String contextRoot, String appName, String virtualServers, WebBundleDescriptor wbd) {
        this.unloadWebModule(contextRoot, appName, virtualServers, wbd, false);
    }

    public void unloadWebModule(String contextRoot, String appName, String virtualServers, WebBundleDescriptor wbd, boolean dummy) {
        this.disableWSMonitoring(wbd);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("WebContainer.unloadWebModule(): contextRoot: " + contextRoot + " appName:" + appName);
        }
        this.cleanSecurityContext(appName);
        if (!contextRoot.equals("") && !contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        } else if ("/".equals(contextRoot)) {
            contextRoot = "";
        }
        Engine[] engines = this._embedded.getEngines();
        List<String> hostList = StringUtils.parseStringList(virtualServers, " ,");
        boolean unloadToAll = hostList == null || hostList.size() == 0;
        boolean hasBeenUndeployed = false;
        org.apache.catalina.Container[] hostArray = null;
        VirtualServer host = null;
        WebModule context = null;
        for (int j = 0; j < engines.length; ++j) {
            hostArray = engines[j].findChildren();
            for (int i = 0; i < hostArray.length; ++i) {
                WebModuleConfig wmInfo;
                host = (VirtualServer)hostArray[i];
                if (unloadToAll && host.getName().equalsIgnoreCase("__asadmin") || !unloadToAll && !hostList.contains(host.getName()) && !this.verifyAlias(hostList, host) || (context = (WebModule)host.findChild(contextRoot)) == null) continue;
                host.removeChild(context);
                try {
                    context.destroy();
                }
                catch (Exception ex) {
                    _logger.log(Level.WARNING, "[WebContainer] Context " + contextRoot + " threw exception in destroy()", ex);
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "[WebContainer] Context " + contextRoot + " undeployed from " + host);
                }
                hasBeenUndeployed = true;
                host.fireContainerEvent("remove", context);
                if (context.hasAdHocPaths() || context.hasAdHocSubtrees()) {
                    WebModule wm = this.createAdHocWebModule(host, contextRoot, context.getJ2EEApplication());
                    wm.addAdHocPaths(context.getAdHocPaths());
                    wm.addAdHocSubtrees(context.getAdHocSubtrees());
                }
                if (dummy || (wmInfo = host.createSystemDefaultWebModuleIfNecessary(this._serverContext.getDefaultHabitat().getComponent(WebDeployer.class))) == null) continue;
                this.loadStandaloneWebModule(host, wmInfo);
            }
        }
        if (!hasBeenUndeployed) {
            _logger.log(Level.SEVERE, "[WebContainer] Undeployment failed for context " + contextRoot);
        }
    }

    public void enableWebModule(WebModuleConfig wmInfo, String j2eeApplication) {
        String vsIDs = wmInfo.getVirtualServers();
        List<String> vsList = StringUtils.parseStringList(vsIDs, " ,");
        boolean enabledToAll = vsList == null || vsList.size() == 0;
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            org.apache.catalina.Container[] vsArray = engines[j].findChildren();
            for (int i = 0; i < vsArray.length; ++i) {
                VirtualServer vs;
                if (!(vsArray[i] instanceof VirtualServer) || (vs = (VirtualServer)vsArray[i]).getID().equals("__asadmin") && enabledToAll || !enabledToAll && !vsList.contains(vs.getID()) && !this.verifyAlias(vsList, vs)) continue;
                this.loadWebModule(vs, wmInfo, j2eeApplication);
            }
        }
    }

    public boolean suspendWebModule(String contextRoot, String appName, String hosts) {
        return this.suspendWebModule(contextRoot, appName, StringUtils.parseStringList(hosts, " ,"));
    }

    public boolean suspendWebModule(String contextRoot, String appName, List<String> hosts) {
        if (!contextRoot.equals("") && !contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        Engine[] engines = this._embedded.getEngines();
        boolean suspendOnAll = hosts == null || hosts.size() == 0;
        boolean hasBeenSuspended = false;
        org.apache.catalina.Container[] hostArray = null;
        VirtualServer host = null;
        Context context = null;
        for (int j = 0; j < engines.length; ++j) {
            hostArray = engines[j].findChildren();
            for (int i = 0; i < hostArray.length; ++i) {
                host = (VirtualServer)hostArray[i];
                if (suspendOnAll && host.getName().equalsIgnoreCase("__asadmin") || !suspendOnAll && !hosts.contains(host.getName()) && !this.verifyAlias(hosts, host) || (context = (Context)host.findChild(contextRoot)) == null) continue;
                context.setAvailable(false);
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "[WebContainer] Context " + contextRoot + " disabled from " + host);
                }
                hasBeenSuspended = true;
            }
        }
        if (!hasBeenSuspended) {
            _logger.log(Level.WARNING, "[WebContainer] Unable to disable web module at context root " + contextRoot);
        }
        return hasBeenSuspended;
    }

    private void configureDynamicReloadingSettings() {
        if (this.dasConfig != null) {
            this._reloadingEnabled = Boolean.parseBoolean(this.dasConfig.getDynamicReloadEnabled());
            String seconds = this.dasConfig.getDynamicReloadPollIntervalInSeconds();
            if (seconds != null) {
                try {
                    this._pollInterval = Integer.parseInt(seconds);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private void setLogLevel(Level level) {
        this._logLevel = level;
        _logger.setLevel(this._logLevel);
        this._debug = level.equals(Level.FINE) ? 1 : (level.equals(Level.FINER) ? 2 : (level.equals(Level.FINEST) ? 5 : 0));
    }

    private void initLogLevel(LogService logserviceBean) {
        Level level = Level.INFO;
        if (logserviceBean != null && logserviceBean.getModuleLogLevels() != null) {
            try {
                level = Level.parse(logserviceBean.getModuleLogLevels().getWebContainer());
            }
            catch (IllegalArgumentException iae) {
                _logger.log(Level.WARNING, "Unable to parse web-container log level", iae);
            }
        }
        this.setLogLevel(level);
    }

    private void initMonitoringLevel(MonitoringService monitoringBean) {
        ModuleMonitoringLevels levels;
        monitoringLevel = MonitoringLevel.OFF;
        if (monitoringBean != null && (levels = monitoringBean.getModuleMonitoringLevels()) != null) {
            monitoringLevel = MonitoringLevel.instance(levels.getWebContainer());
        }
    }

    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    private void cleanSecurityContext(String appName) {
    }

    private void addMimeMappings(StandardContext ctx, MimeMap mimeMap) {
        if (mimeMap == null) {
            return;
        }
        Iterator itr = mimeMap.getExtensions();
        while (itr.hasNext()) {
            String extension = (String)itr.next();
            if (ctx.findMimeMapping(extension) != null) continue;
            ctx.addMimeMapping(extension, mimeMap.getType(extension));
        }
    }

    private void enableAllWSEndpoints() {
        for (J2eeApplication appBean : this.domain.getApplications().getModules(J2eeApplication.class)) {
            if (!this.isReferenced(appBean.getName())) continue;
            this.enableWSMonitoring(appBean.getName());
        }
    }

    private boolean disableWSMonitoring(WebBundleDescriptor wbd) {
        boolean result = true;
        return true;
    }

    private boolean enableWSMonitoring(String id) {
        boolean result = true;
        return true;
    }

    void enableWSMonitoring(WebBundleDescriptor wbd, String serverName) {
    }

    void enableMonitoring(WebModule ctx, String vsId) {
    }

    protected void disableMonitoring(WebModule ctx, String vsId) {
    }

    private void setTldScan() {
        HashSet<String> tldJars = null;
        HashSet<String> tldListeners = null;
        String prop = System.getProperty("com.sun.enterprise.taglibs");
        if (prop != null && prop.trim().length() > 0) {
            tldJars = new HashSet<String>(StringUtils.parseStringList(prop, ","));
        }
        if ((prop = System.getProperty("com.sun.enterprise.taglisteners")) != null && prop.trim().length() > 0) {
            tldListeners = new HashSet<String>(StringUtils.parseStringList(prop, ","));
        }
        if (tldListeners != null && tldListeners.size() > 0) {
            TldConfig.setScanParentTldListener(true);
        }
        TldConfig.setTldListeners(tldListeners);
        TldLocationsCache.setTldJars(tldJars);
    }

    private boolean isReferenced(String appName) {
        Servers servers = this.domain.getServers();
        for (Server server : servers.getServer()) {
            if (!server.getName().equals(this._serverContext.getInstanceName())) continue;
            for (ApplicationRef ref : server.getApplicationRef()) {
                if (!ref.getRef().equals(appName)) continue;
                return true;
            }
        }
        return false;
    }

    private void registerServletStats(String j2eeApplication, String j2eeServer, String webModuleName, String vsId, String contextRoot, String servletName, MonitoringLevelListener listener) {
        PwcServletStatsImpl pwcServletStats = new PwcServletStatsImpl(this._serverContext.getDefaultDomainName(), vsId, contextRoot, servletName, j2eeApplication, j2eeServer);
        ServletStatsImpl servletStats = new ServletStatsImpl(pwcServletStats);
        MonitoringRegistry monitoringRegistry = this._serverContext.getDefaultHabitat().getComponent(MonitoringRegistry.class);
        String app = "null".equalsIgnoreCase(j2eeApplication) ? null : j2eeApplication;
        try {
            monitoringRegistry.registerServletStats(servletStats, app, webModuleName, contextRoot, vsId, servletName, listener);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Exception during registration of servletstats", e);
        }
    }

    private void unregisterServletStats(String j2eeApplication, String webModuleName, String contextRoot, String vsId, String servletName) {
        MonitoringRegistry monitoringRegistry = this._serverContext.getDefaultHabitat().getComponent(MonitoringRegistry.class);
        try {
            monitoringRegistry.unregisterServletStats(j2eeApplication, webModuleName, contextRoot, vsId, servletName);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Exception during unregistration of servletstats", e);
        }
    }

    private WebModuleStats registerWebModuleStats(String j2eeApplication, String j2eeServer, String vsId, WebModule ctx, MonitoringLevelListener listener) {
        WebModuleStatsImpl webStats = (WebModuleStatsImpl)this.webContainerFeatureFactory.getWebModuleStats();
        PwcWebModuleStatsImpl pwcWebStats = new PwcWebModuleStatsImpl(ctx.getObjectName(), ctx.getEncodedPath(), this._serverContext.getDefaultDomainName(), vsId, j2eeApplication, j2eeServer);
        webStats.setPwcWebModuleStats(pwcWebStats);
        webStats.setSessionManager(ctx.getManager());
        MonitoringRegistry monitoringRegistry = this._serverContext.getDefaultHabitat().getComponent(MonitoringRegistry.class);
        String app = "null".equalsIgnoreCase(j2eeApplication) ? null : j2eeApplication;
        try {
            monitoringRegistry.registerWebModuleStats(webStats, app, ctx.getModuleName(), ctx.getEncodedPath(), vsId, listener);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Fail to register WebModuleStats for " + ctx.getModuleName() + " deployed on " + vsId, e);
        }
        return webStats;
    }

    private void unregisterWebModuleStats(String j2eeApplication, String webModuleName, String contextRoot, String vsId) {
        MonitoringRegistry monitoringRegistry = this._serverContext.getDefaultHabitat().getComponent(MonitoringRegistry.class);
        try {
            monitoringRegistry.unregisterWebModuleStats(j2eeApplication, webModuleName, contextRoot, vsId);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Fail to unregister WebModuleStats for " + webModuleName + " deployed on " + vsId, e);
        }
    }

    public static WebContainer getInstance() {
        return webContainer;
    }

    public Engine[] getEngines() {
        return this._embedded.getEngines();
    }

    public void registerAdHocPath(String path, String ctxtRoot, String appName, AdHocServletInfo servletInfo) {
        this.registerAdHocPathAndSubtree(path, null, ctxtRoot, appName, servletInfo);
    }

    public void registerAdHocPathAndSubtree(String path, String subtree, String ctxtRoot, String appName, AdHocServletInfo servletInfo) {
        WebModule wm = null;
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            org.apache.catalina.Container[] vsList = engines[j].findChildren();
            for (int i = 0; i < vsList.length; ++i) {
                VirtualServer vs = (VirtualServer)vsList[i];
                if (vs.getName().equalsIgnoreCase("__asadmin")) continue;
                wm = (WebModule)vs.findChild(ctxtRoot);
                if (wm == null) {
                    wm = this.createAdHocWebModule(vs, ctxtRoot, appName);
                }
                wm.addAdHocPathAndSubtree(path, subtree, servletInfo);
            }
        }
    }

    public void unregisterAdHocPath(String path, String ctxtRoot) {
        this.unregisterAdHocPathAndSubtree(path, null, ctxtRoot);
    }

    public void unregisterAdHocPathAndSubtree(String path, String subtree, String ctxtRoot) {
        WebModule wm = null;
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            org.apache.catalina.Container[] vsList = engines[j].findChildren();
            for (int i = 0; i < vsList.length; ++i) {
                VirtualServer vs = (VirtualServer)vsList[i];
                if (vs.getName().equalsIgnoreCase("__asadmin") || (wm = (WebModule)vs.findChild(ctxtRoot)) == null) continue;
                wm.removeAdHocPath(path);
                wm.removeAdHocSubtree(subtree);
                if (!(wm instanceof AdHocWebModule) || wm.hasAdHocPaths() || wm.hasAdHocSubtrees()) continue;
                vs.removeChild(wm);
                try {
                    wm.destroy();
                    continue;
                }
                catch (Exception ex) {
                    _logger.log(Level.WARNING, "[WebContainer] Context " + wm.getPath() + " threw exception in destroy()", ex);
                }
            }
        }
    }

    private WebModule createAdHocWebModule(VirtualServer vs, String ctxtRoot, String appName) {
        AdHocWebModule wm = new AdHocWebModule(this);
        wm.restrictedSetPipeline(new WebPipeline(wm));
        wm.setParentClassLoader(Thread.currentThread().getContextClassLoader());
        wm.setContextRoot(ctxtRoot);
        wm.setJ2EEApplication(appName);
        wm.setName(ctxtRoot);
        wm.setDocBase(vs.getAppBase());
        wm.setEngineName(vs.getParent().getName());
        String domain = this._serverContext.getDefaultDomainName();
        wm.setDomain(domain);
        String j2eeServer = this._serverContext.getInstanceName();
        wm.setJ2EEServer(j2eeServer);
        String server = domain + ":j2eeType=J2EEServer,name=" + j2eeServer;
        wm.setServer(server);
        wm.setCrossContext(true);
        vs.addChild(wm);
        return wm;
    }

    private void addLibs(Loader loader, WebModule ctx) {
        String list = ASClassLoaderUtil.getLibrariesForModule(WebModule.class, ctx.getID());
        if (list == null) {
            return;
        }
        String[] libs = list.split(",");
        if (libs == null) {
            return;
        }
        File libDir = this.instance.getLibPath();
        String libDirPath = libDir.getAbsolutePath();
        String appLibsPrefix = libDirPath + File.separator + "applibs" + File.separator;
        for (int i = 0; i < libs.length; ++i) {
            try {
                URL url = new URL(libs[i]);
                loader.addRepository(libs[i]);
                continue;
            }
            catch (MalformedURLException e) {
                File file = new File(libs[i]);
                if (file.isAbsolute()) {
                    loader.addRepository("file:" + file.getAbsolutePath());
                    continue;
                }
                loader.addRepository("file:" + appLibsPrefix + libs[i]);
            }
        }
    }

    private void configureLoaderAttributes(Loader loader, com.sun.enterprise.deployment.runtime.web.ClassLoader clBean, WebModule ctx) {
        String[] pathElements;
        String value = clBean.getAttributeValue("Delegate");
        boolean delegate = ConfigBeansUtilities.toBoolean(value);
        loader.setDelegate(delegate);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("WebModule[" + ctx.getPath() + "]: Setting delegate to " + delegate);
        }
        if ((value = clBean.getAttributeValue("ExtraClassPath")) != null && (pathElements = value.split(";|((?<!\\\\):)")) != null) {
            for (String path : pathElements) {
                path = path.replace("\\:", ":");
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("WebModule[" + ctx.getPath() + "]: Adding " + path + " to the classpath");
                }
                try {
                    URL url = new URL(path);
                    loader.addRepository(path);
                }
                catch (MalformedURLException mue1) {
                    File file = new File(path);
                    if (!file.isAbsolute()) {
                        file = new File(ctx.getDocBase(), path);
                    }
                    try {
                        URL url = file.toURI().toURL();
                        loader.addRepository(url.toString());
                    }
                    catch (MalformedURLException mue2) {
                        String msg = _rb.getString("webcontainer.classpathError");
                        Object[] params = new Object[]{path};
                        msg = MessageFormat.format(msg, params);
                        _logger.log(Level.SEVERE, msg, mue2);
                    }
                }
            }
        }
        if ((value = clBean.getAttributeValue("DynamicReloadInterval")) != null) {
            _logger.log(Level.WARNING, "webcontainer.dynamicReloadInterval");
        }
    }

    private void configureLoaderProperties(Loader loader, com.sun.enterprise.deployment.runtime.web.ClassLoader clBean) {
        String name = null;
        String value = null;
        WebProperty[] props = clBean.getWebProperty();
        if (props == null || props.length == 0) {
            return;
        }
        for (int i = 0; i < props.length; ++i) {
            name = props[i].getAttributeValue("name");
            value = props[i].getAttributeValue("value");
            if (name == null || value == null) {
                throw new IllegalArgumentException(_rb.getString("webcontainer.nullWebProperty"));
            }
            if (name.equalsIgnoreCase("ignoreHiddenJarFiles")) {
                loader.setIgnoreHiddenJarFiles(ConfigBeansUtilities.toBoolean(value));
                continue;
            }
            Object[] params = new Object[]{name, value};
            _logger.log(Level.WARNING, "webcontainer.invalidProperty", params);
        }
    }

    void removeDummyModule(VirtualServer vs) {
        WebModule ctx = (WebModule)vs.findChild("");
        if (ctx != null && "__default-web-module".equals(ctx.getModuleName())) {
            this.unloadWebModule("", ctx.getJ2EEApplication(), vs.getName(), null, true);
        }
    }

    private void initInstanceSessionProperties() {
        SessionProperties spBean = this.serverConfigLookup.getInstanceSessionProperties();
        if (spBean == null || spBean.getProperty() == null) {
            return;
        }
        List<Property> props = spBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                throw new IllegalArgumentException(_rb.getString("webcontainer.nullWebProperty"));
            }
            if (propName.equalsIgnoreCase("enableCookies")) {
                this.instanceEnableCookies = ConfigBeansUtilities.toBoolean(propValue);
                continue;
            }
            Object[] params = new Object[]{propName};
            _logger.log(Level.INFO, "webcontainer.notYet", params);
        }
    }

    private static synchronized void setJspFactory() {
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory(new JspFactoryImpl());
        }
    }

    public void deleteHost(HttpService httpService) throws LifecycleException {
        int i;
        Engine[] engines = this._embedded.getEngines();
        org.apache.catalina.Container[] virtualServers = engines[0].findChildren();
        block2: for (i = 0; i < virtualServers.length; ++i) {
            for (com.sun.enterprise.config.serverbeans.VirtualServer vse : httpService.getVirtualServer()) {
                if (!virtualServers[i].getName().equals(vse.getId())) continue;
                virtualServers[i] = null;
                continue block2;
            }
        }
        for (i = 0; i < virtualServers.length; ++i) {
            VirtualServer virtualServer = (VirtualServer)virtualServers[i];
            if (virtualServer == null) continue;
            if (virtualServer.getID().equals("__asadmin")) {
                throw new LifecycleException("Cannot delete admin virtual-server.");
            }
            org.apache.catalina.Container[] webModules = virtualServer.findChildren();
            for (int j = 0; j < webModules.length; ++j) {
                this.unloadWebModule(webModules[j].getName(), webModules[j].getName(), virtualServer.getID(), null);
            }
            try {
                virtualServer.destroy();
                continue;
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Error during destruction of virtual server " + virtualServer.getID(), e);
            }
        }
    }

    public void updateHost(com.sun.enterprise.config.serverbeans.VirtualServer vsBean, HttpService httpService) throws LifecycleException {
        WebModuleConfig wmInfo;
        String newDefaultContextPath;
        WebConnector conn;
        int k;
        int i;
        Engine[] engines = this._embedded.getEngines();
        VirtualServer virtualServer = (VirtualServer)engines[0].findChild(vsBean.getId());
        String oldDefaultWebModule = virtualServer.getDefaultWebModuleID();
        virtualServer.setBean(vsBean);
        this._embedded.setLogFile(virtualServer, vsBean.getLogFile());
        virtualServer.configureVirtualServerState();
        virtualServer.clearAliases();
        virtualServer.configureAliases();
        virtualServer.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this._serverContext.getDefaultHabitat(), this.domain, this.globalAccessLoggingEnabled);
        String docroot = vsBean.getPropertyValue("docroot");
        if (docroot == null) {
            docroot = vsBean.getDocroot();
        }
        if (docroot != null) {
            this.updateDocroot(docroot, virtualServer, vsBean);
        }
        int[] oldPorts = virtualServer.getPorts();
        List<String> listeners = StringUtils.parseStringList(vsBean.getHttpListeners(), ",");
        if (listeners != null) {
            HttpListener[] httpListeners = new HttpListener[listeners.size()];
            for (i = 0; i < listeners.size(); ++i) {
                for (HttpListener httpListener : httpService.getHttpListener()) {
                    if (!httpListener.getId().equals(listeners.get(i))) continue;
                    httpListeners[i] = httpListener;
                }
            }
            this.configureHostPortNumbers(virtualServer, httpListeners);
        } else {
            virtualServer.setPorts(new int[0]);
        }
        int[] newPorts = virtualServer.getPorts();
        for (i = 0; i < oldPorts.length; ++i) {
            boolean found = false;
            for (int j = 0; j < newPorts.length; ++j) {
                if (oldPorts[i] != newPorts[j]) continue;
                found = true;
            }
            if (found) continue;
            Connector[] connectors = this._embedded.findConnectors();
            for (k = 0; k < connectors.length; ++k) {
                conn = (WebConnector)connectors[k];
                if (oldPorts[i] != conn.getPort()) continue;
                try {
                    conn.getMapperListener().unregisterHost(virtualServer.getJmxName());
                    continue;
                }
                catch (Exception e) {
                    throw new LifecycleException(e);
                }
            }
        }
        for (i = 0; i < newPorts.length; ++i) {
            boolean found = false;
            for (int j = 0; j < oldPorts.length; ++j) {
                if (newPorts[i] != oldPorts[j]) continue;
                found = true;
            }
            if (found) continue;
            Connector[] connectors = this._embedded.findConnectors();
            for (k = 0; k < connectors.length; ++k) {
                conn = (WebConnector)connectors[k];
                if (newPorts[i] != conn.getPort()) continue;
                if (!conn.isAvailable()) {
                    conn.start();
                    this.enableHttpListenerMonitoring(virtualServer, conn.getPort(), conn.getName());
                }
                try {
                    conn.getMapperListener().registerHost(virtualServer.getJmxName());
                    continue;
                }
                catch (Exception e) {
                    throw new LifecycleException(e);
                }
            }
        }
        if (oldDefaultWebModule != null) {
            this.updateDefaultWebModule(virtualServer, oldPorts, null);
        }
        if ((newDefaultContextPath = (wmInfo = virtualServer.getDefaultWebModule(this.domain, this._serverContext.getDefaultHabitat().getComponent(WebDeployer.class))).getContextPath()) != null) {
            this.removeDummyModule(virtualServer);
            this.updateDefaultWebModule(virtualServer, virtualServer.getPorts(), wmInfo);
        } else {
            WebModuleConfig wmc = virtualServer.createSystemDefaultWebModuleIfNecessary(this._serverContext.getDefaultHabitat().getComponent(WebDeployer.class));
            if (wmc != null) {
                this.loadStandaloneWebModule(virtualServer, wmc);
            }
        }
    }

    public void updateHostProperties(com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String name, String value, HttpService httpService, SecurityService securityService) {
        Engine[] engines = this._embedded.getEngines();
        VirtualServer vs = (VirtualServer)engines[0].findChild(vsBean.getId());
        vs.setBean(vsBean);
        if (name == null) {
            return;
        }
        if ("docroot".equals(name)) {
            this.updateDocroot(value, vs, vsBean);
        } else if (name.startsWith("alternatedocroot_")) {
            this.updateAlternateDocroot(vs, vsBean);
        } else if ("setCacheControl".equals(name)) {
            vs.configureCacheControl(value);
        } else if ("accesslog".equals(name)) {
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this._serverContext.getDefaultHabitat(), this.domain, this.globalAccessLoggingEnabled);
        } else if ("accessLogWriteInterval".equals(name)) {
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this._serverContext.getDefaultHabitat(), this.domain, this.globalAccessLoggingEnabled);
        } else if ("accessLogBufferSize".equals(name)) {
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this._serverContext.getDefaultHabitat(), this.domain, this.globalAccessLoggingEnabled);
        } else if ("allowRemoteHost".equals(name) || "denyRemoteHost".equals(name)) {
            vs.configureRemoteHostFilterValve(httpService.getHttpProtocol());
        } else if ("allowRemoteAddress".equals(name) || "denyRemoteAddress".equals(name)) {
            vs.configureRemoteAddressFilterValve();
        } else if ("sso-enabled".equals(name)) {
            vs.configureSSOValve(this.globalSSOEnabled, this.webContainerFeatureFactory);
        } else if ("authRealm".equals(name)) {
            vs.configureAuthRealm(securityService);
        } else if (name.startsWith("send-error")) {
            vs.configureErrorPage();
        } else if (name.startsWith("redirect")) {
            vs.configureRedirect();
        } else if (name.startsWith("contextXmlDefault")) {
            vs.setDefaultContextXmlLocation(value);
        }
    }

    public void updateHttpService(HttpService httpService) throws LifecycleException {
        List<HttpListener> httpListeners;
        List<com.sun.enterprise.config.serverbeans.VirtualServer> virtualServers;
        if (httpService == null) {
            return;
        }
        Property ssoEnabled = null;
        Property accessLoggingEnabled = null;
        Property accessLogWriteInterval = null;
        Property accessLogBufferSize = null;
        List<Property> props = httpService.getProperty();
        if (props != null) {
            for (Property prop : props) {
                if ("sso-enabled".equals(prop.getName())) {
                    ssoEnabled = prop;
                    this.globalSSOEnabled = ConfigBeansUtilities.toBoolean(prop.getValue());
                    continue;
                }
                if ("accessLoggingEnabled".equals(prop.getName())) {
                    accessLoggingEnabled = prop;
                    this.globalAccessLoggingEnabled = ConfigBeansUtilities.toBoolean(prop.getValue());
                    continue;
                }
                if ("accessLogWriteInterval".equals(prop.getName())) {
                    accessLogWriteInterval = prop;
                    this.globalAccessLogWriteInterval = prop.getValue();
                    continue;
                }
                if (!"accessLogBufferSize".equals(prop.getName())) continue;
                accessLogBufferSize = prop;
                this.globalAccessLogBufferSize = prop.getValue();
            }
        }
        if ((virtualServers = httpService.getVirtualServer()) != null && (ssoEnabled != null || accessLoggingEnabled != null || accessLogWriteInterval != null || accessLogBufferSize != null)) {
            for (com.sun.enterprise.config.serverbeans.VirtualServer virtualServer : virtualServers) {
                if (ssoEnabled != null) {
                    this.updateHostProperties(virtualServer, ssoEnabled.getName(), ssoEnabled.getValue(), httpService, null);
                }
                if (accessLoggingEnabled != null) {
                    this.updateHostProperties(virtualServer, accessLoggingEnabled.getName(), accessLoggingEnabled.getValue(), httpService, null);
                }
                if (accessLogWriteInterval != null) {
                    this.updateHostProperties(virtualServer, accessLogWriteInterval.getName(), accessLogWriteInterval.getValue(), httpService, null);
                }
                if (accessLogBufferSize == null) continue;
                this.updateHostProperties(virtualServer, accessLogBufferSize.getName(), accessLogBufferSize.getValue(), httpService, null);
            }
        }
        if ((httpListeners = httpService.getHttpListener()) != null) {
            for (HttpListener httpListener : httpListeners) {
                this.updateConnector(httpListener, httpService);
            }
        }
    }

    public void updateConnectorProperty(HttpListener httpListener, String propName, String propValue) throws LifecycleException {
        WebConnector connector = this.connectorMap.get(httpListener.getId());
        if (connector != null) {
            connector.configureHttpListenerProperty(propName, propValue);
        }
    }

    public void updateConnector(HttpListener httpListener, HttpService httpService) throws LifecycleException {
        if (httpListener.getDefaultVirtualServer().equals("__asadmin")) {
            return;
        }
        WebConnector connector = this.connectorMap.get(httpListener.getId());
        if (connector != null) {
            this._embedded.removeConnector(connector);
            this.connectorMap.remove(httpListener.getId());
        }
        if (!Boolean.valueOf(httpListener.getEnabled()).booleanValue()) {
            return;
        }
        connector = this.createHttpListener(httpListener, httpService);
        if (connector == null) {
            return;
        }
        String virtualServerName = httpListener.getDefaultVirtualServer();
        VirtualServer virtualServer = (VirtualServer)this._embedded.getEngines()[0].findChild(virtualServerName);
        boolean found = false;
        int[] ports = virtualServer.getPorts();
        for (int i = 0; i < ports.length; ++i) {
            if (ports[i] != connector.getPort()) continue;
            found = true;
            break;
        }
        if (!found) {
            int[] newPorts = new int[ports.length + 1];
            System.arraycopy(ports, 0, newPorts, 0, ports.length);
            newPorts[ports.length] = connector.getPort();
            virtualServer.setPorts(newPorts);
        }
        connector.start();
    }

    public WebConnector addConnector(HttpListener httpListener, HttpService httpService) throws LifecycleException {
        String defaultContextPath = "/";
        WebConnector connector = this.createHttpListener(httpListener, httpService);
        if (connector.getRedirectPort() == -1) {
            connector.setRedirectPort(this.defaultRedirectPort);
        }
        String virtualServerName = httpListener.getDefaultVirtualServer();
        VirtualServer vs = (VirtualServer)this._embedded.getEngines()[0].findChild(virtualServerName);
        int[] oldPorts = vs.getPorts();
        int[] newPorts = new int[oldPorts.length + 1];
        System.arraycopy(oldPorts, 0, newPorts, 0, oldPorts.length);
        newPorts[oldPorts.length] = connector.getPort();
        vs.setPorts(newPorts);
        this.grizzlyService.createNetworkProxy(httpListener, httpService);
        this.grizzlyService.registerNetworkProxy();
        connector.start();
        return connector;
    }

    public void deleteConnector(HttpListener httpListener, HttpService httpService) throws LifecycleException {
        Connector[] connectors = this._embedded.findConnectors();
        int port = Integer.parseInt(httpListener.getPort());
        for (int i = 0; i < connectors.length; ++i) {
            WebConnector conn = (WebConnector)connectors[i];
            if (port != conn.getPort()) continue;
            this._embedded.removeConnector(conn);
            this.grizzlyService.removeNetworkProxy(port);
            this.portMap.remove(httpListener.getId());
            this.adapterMap.remove(port);
            this.connectorMap.remove(httpListener.getId());
        }
    }

    public void updateAccessLog(HttpService httpService) {
        org.apache.catalina.Container[] virtualServers = this._embedded.getEngines()[0].findChildren();
        for (int i = 0; i < virtualServers.length; ++i) {
            ((VirtualServer)virtualServers[i]).reconfigureAccessLog(httpService, this.webContainerFeatureFactory);
        }
    }

    private void updateDocroot(String docroot, VirtualServer vs, com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        boolean isValid = this.validateDocroot(docroot, vsBean.getId(), vsBean.getDefaultWebModule());
        if (isValid) {
            vs.setAppBase(docroot);
            this.removeDummyModule(vs);
            WebModuleConfig wmInfo = vs.createSystemDefaultWebModuleIfNecessary(this._serverContext.getDefaultHabitat().getComponent(WebDeployer.class));
            if (wmInfo != null) {
                this.loadStandaloneWebModule(vs, wmInfo);
            }
        }
    }

    private void updateAlternateDocroot(VirtualServer vs, com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        this.removeDummyModule(vs);
        WebModuleConfig wmInfo = vs.createSystemDefaultWebModuleIfNecessary(this._serverContext.getDefaultHabitat().getComponent(WebDeployer.class));
        if (wmInfo != null) {
            this.loadStandaloneWebModule(vs, wmInfo);
        }
    }

    protected void enableHttpListenerMonitoring(VirtualServer virtualServer, int port, String httpListenerId) {
        PWCRequestStatsImpl pwcRequestStatsImpl = virtualServer.getPWCRequestStatsImpl();
        if (pwcRequestStatsImpl == null) {
            pwcRequestStatsImpl = new PWCRequestStatsImpl(this.getServerContext().getDefaultDomainName());
            virtualServer.setPWCRequestStatsImpl(pwcRequestStatsImpl);
        }
        MonitoringRegistry mReg = this.getServerContext().getDefaultHabitat().getComponent(MonitoringRegistry.class);
        String vsId = virtualServer.getID();
        HTTPListenerStatsImpl httpStats = this.isTomcatUsingDefaultDomain() ? new HTTPListenerStatsImpl(this.getServerContext().getDefaultDomainName(), port) : new HTTPListenerStatsImpl(vsId, port);
        try {
            mReg.registerHttpListenerStats(httpStats, httpListenerId, vsId, null);
            pwcRequestStatsImpl.addHttpListenerStats(httpStats);
        }
        catch (MonitoringRegistrationException mre) {
            String msg = _logger.getResourceBundle().getString("web.monitoringRegistrationError");
            msg = MessageFormat.format(msg, "HTTPListenerStats");
            _logger.log(Level.WARNING, msg, mre);
        }
    }

    protected boolean isTomcatUsingDefaultDomain() {
        return true;
    }

    static {
        debugMonitoring = false;
        debugMonitoringPeriodMS = 30000L;
        _timer = new WebContainerTimer(true);
        useDOLforDeployment = true;
        _rb = _logger.getResourceBundle();
        if (System.getProperty(DOL_DEPLOYMENT) != null) {
            useDOLforDeployment = Boolean.valueOf(System.getProperty(DOL_DEPLOYMENT));
        }
    }
}

