/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.reconfig;

import com.sun.enterprise.config.serverbeans.AccessLog;
import com.sun.enterprise.config.serverbeans.ConnectionPool;
import com.sun.enterprise.config.serverbeans.HttpFileCache;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpProtocol;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.KeepAlive;
import com.sun.enterprise.config.serverbeans.RequestProcessing;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.web.WebContainer;
import java.beans.PropertyChangeEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleException;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

public class HttpServiceConfigListener
implements ConfigListener {
    @Inject
    public HttpService httpService;
    @Inject
    public AccessLog accessLog;
    @Inject
    public ConnectionPool connectionPool;
    @Inject
    public HttpFileCache httpFileCache;
    @Inject
    public HttpProtocol httpProtocol;
    @Inject
    public KeepAlive keepAlive;
    @Inject
    public RequestProcessing requestProcessing;
    private WebContainer container;
    private Logger logger;
    volatile boolean received = false;

    public void setContainer(WebContainer container) {
        this.container = container;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ConfigSupport.sortAndDispatch(events, new Changed(){

            @Override
            public <T extends ConfigBeanProxy> void changed(Changed.TYPE type, Class<T> tClass, T t) {
                try {
                    if (t instanceof VirtualServer) {
                        if (type == Changed.TYPE.ADD) {
                            HttpServiceConfigListener.this.container.createVirtualServer((VirtualServer)t, HttpServiceConfigListener.this.httpService, null);
                        } else if (type == Changed.TYPE.REMOVE) {
                            HttpServiceConfigListener.this.container.deleteHost(HttpServiceConfigListener.this.httpService);
                        } else if (type == Changed.TYPE.CHANGE) {
                            HttpServiceConfigListener.this.container.updateHost((VirtualServer)t, HttpServiceConfigListener.this.httpService);
                        }
                        return;
                    }
                    if (t instanceof HttpListener) {
                        if (type == Changed.TYPE.ADD) {
                            HttpServiceConfigListener.this.container.addConnector((HttpListener)t, HttpServiceConfigListener.this.httpService);
                        } else if (type == Changed.TYPE.REMOVE) {
                            HttpServiceConfigListener.this.container.deleteConnector((HttpListener)t, HttpServiceConfigListener.this.httpService);
                        } else if (type == Changed.TYPE.CHANGE) {
                            HttpServiceConfigListener.this.container.updateConnector((HttpListener)t, HttpServiceConfigListener.this.httpService);
                        }
                        return;
                    }
                    if (t instanceof AccessLog) {
                        HttpServiceConfigListener.this.container.updateAccessLog(HttpServiceConfigListener.this.httpService);
                    } else if (t instanceof RequestProcessing) {
                        HttpServiceConfigListener.this.container.configureRequestProcessing(HttpServiceConfigListener.this.httpService);
                    } else if (t instanceof KeepAlive) {
                        HttpServiceConfigListener.this.container.configureKeepAlive(HttpServiceConfigListener.this.httpService);
                    } else if (t instanceof ConnectionPool) {
                        HttpServiceConfigListener.this.container.configureConnectionPool(HttpServiceConfigListener.this.httpService);
                    } else if (t instanceof HttpProtocol) {
                        HttpServiceConfigListener.this.container.configureHttpProtocol(HttpServiceConfigListener.this.httpService);
                    } else if (t instanceof HttpFileCache) {
                        HttpServiceConfigListener.this.container.configureFileCache(HttpServiceConfigListener.this.httpService);
                    }
                    HttpServiceConfigListener.this.container.updateHttpService(HttpServiceConfigListener.this.httpService);
                }
                catch (LifecycleException le) {
                    HttpServiceConfigListener.this.logger.log(Level.SEVERE, "Exception processing HttpService config change", le);
                }
            }
        }, this.logger);
        return null;
    }
}

