/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.comet;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometEngine;
import com.sun.grizzly.comet.CometEvent;
import com.sun.grizzly.comet.CometHandler;
import com.sun.grizzly.comet.CometReader;
import com.sun.grizzly.comet.CometSelector;
import com.sun.grizzly.comet.CometWriter;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.TaskBase;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class CometTask
extends TaskBase {
    protected OP_EVENT upcoming_op = OP_EVENT.READ;
    private CometContext cometContext;
    private CometSelector cometSelector;
    private long expireTime = 0L;
    private long expirationDelay = 30000L;
    private InputReader cometInputStream;
    private SelectionKey cometKey;
    private boolean connectionClosed;
    private CometEvent event;
    private CometWriter writer;
    private CometReader reader;
    private boolean asyncReadSupported = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTask() throws IOException {
        CometHandler cometHandler = this.cometContext.getCometHandler(this.key);
        if (this.cometContext.getCometHandler(this.key) == null) {
            if (this.cometKey != null) {
                this.cometKey.cancel();
                this.cometKey.attach(null);
            }
            CometEngine.getEngine().returnTask(this);
            return;
        }
        if (!this.cometContext.isActive(cometHandler)) {
            return;
        }
        ByteBuffer byteBuffer = ((WorkerThread)Thread.currentThread()).getByteBuffer();
        boolean clearBuffer = true;
        try {
            if (this.cometKey == null || this.key == null) {
                return;
            }
            if (this.cometInputStream == null) {
                this.cometInputStream = new InputReader();
            }
            if (this.event == null) {
                this.event = new CometEvent();
            }
            this.connectionClosed = false;
            this.cometInputStream.setSelectionKey(this.cometKey);
            if (byteBuffer == null) {
                byteBuffer = ByteBuffer.allocate(this.selectorThread.getBufferSize());
                ((WorkerThread)Thread.currentThread()).setByteBuffer(byteBuffer);
            } else {
                byteBuffer.clear();
            }
            this.cometInputStream.setByteBuffer(byteBuffer);
            SocketChannel socketChannel = (SocketChannel)this.cometKey.channel();
            if (this.upcoming_op == OP_EVENT.READ) {
                this.event.type = 4;
                int nRead = socketChannel.read(byteBuffer);
                if (nRead == -1 || !socketChannel.isOpen()) {
                    this.connectionClosed = true;
                } else if (!this.asyncReadSupported) {
                    this.selectorThread.getSelectorThreadKeyHandler().addBannedSelectionKey(this.key);
                    if (!this.cometContext.isActive(cometHandler)) {
                        return;
                    }
                    nRead = socketChannel.read(byteBuffer);
                    if (nRead == -1) {
                        this.connectionClosed = true;
                        return;
                    }
                    this.cometContext.resumeCometHandler(cometHandler, false);
                    clearBuffer = false;
                    Controller controller = this.getSelectorThread().getController();
                    ProtocolChain protocolChain = controller.getProtocolChainInstanceHandler().poll();
                    Context ctx = controller.pollContext(this.key);
                    ctx.setController(controller);
                    ctx.setSelectionKey(this.key);
                    ctx.setProtocolChain(protocolChain);
                    protocolChain.execute(ctx);
                } else {
                    byteBuffer.flip();
                    this.reader = new CometReader();
                    this.reader.setNRead(nRead);
                    this.reader.setByteBuffer(byteBuffer);
                    this.event.attach(this.reader);
                    this.cometContext.notify(this.event, 4, this.key);
                    this.reader.setByteBuffer(null);
                    this.reader.setReady(false);
                }
            } else if (this.upcoming_op == OP_EVENT.WRITE) {
                this.event.type = 5;
                this.writer = new CometWriter();
                this.writer.setChannel(socketChannel);
                this.event.attach(this.writer);
                this.cometContext.notify(this.event, 5, this.key);
                this.writer.setReady(false);
            }
        }
        catch (IOException ex) {
            this.connectionClosed = true;
            if (SelectorThread.logger().isLoggable(Level.FINEST)) {
                SelectorThread.logger().log(Level.FINEST, "Comet exception", ex);
            }
        }
        catch (Throwable t) {
            SelectorThread.logger().log(Level.SEVERE, "Comet exception", t);
            this.connectionClosed = true;
        }
        finally {
            if (this.connectionClosed) {
                this.cometSelector.cancelKey(this.cometKey);
            }
            if (clearBuffer) {
                byteBuffer.clear();
            }
            this.asyncReadSupported = false;
        }
    }

    public CometContext getCometContext() {
        return this.cometContext;
    }

    public void setCometContext(CometContext cometContext) {
        this.cometContext = cometContext;
    }

    public void recycle() {
        super.recycle();
        this.key = null;
        this.cometContext = null;
        this.asyncReadSupported = false;
        if (this.cometInputStream != null) {
            this.cometInputStream.recycle();
        }
    }

    public CometSelector getCometSelector() {
        return this.cometSelector;
    }

    public void setCometSelector(CometSelector cometSelector) {
        this.cometSelector = cometSelector;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public long getExpirationDelay() {
        return this.expirationDelay;
    }

    public void setExpirationDelay(long expirationDelay) {
        this.expirationDelay = expirationDelay;
    }

    public SelectionKey getCometKey() {
        return this.cometKey;
    }

    public void setCometKey(SelectionKey cometKey) {
        this.cometKey = cometKey;
    }

    public boolean isAsyncReadSupported() {
        return this.asyncReadSupported;
    }

    public void setAsyncReadSupported(boolean asyncReadSupported) {
        this.asyncReadSupported = asyncReadSupported;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OP_EVENT {
        READ,
        WRITE;

    }
}

