/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.data.provider.RowKey;
import com.sun.webui.jsf.component.HiddenField;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.component.Table;
import com.sun.webui.jsf.component.TableColumn;
import com.sun.webui.jsf.component.TableFooter;
import com.sun.webui.jsf.component.TableHeader;
import com.sun.webui.jsf.component.TableRowGroupBase;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.util.ArrayList;
import java.util.Iterator;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class TableRowGroup
extends TableRowGroupBase {
    public static final String COLUMN_FOOTER_BAR_ID = "_columnFooterBar";
    public static final String COLUMN_HEADER_BAR_ID = "_columnHeaderBar";
    public static final String EMPTY_DATA_COLUMN_ID = "_emptyDataColumn";
    public static final String EMPTY_DATA_COLUMN_FACET = "emptyDataColumn";
    public static final String EMPTY_DATA_TEXT_ID = "_emptyDataText";
    public static final String EMPTY_DATA_TEXT_FACET = "emptyDataText";
    public static final String FOOTER_FACET = "footer";
    public static final String GROUP_FOOTER_BAR_ID = "_groupFooterBar";
    public static final String GROUP_FOOTER_ID = "_groupFooter";
    public static final String GROUP_FOOTER_FACET = "groupFooter";
    public static final String GROUP_HEADER_BAR_ID = "_groupHeaderBar";
    public static final String GROUP_HEADER_ID = "_groupHeader";
    public static final String GROUP_HEADER_FACET = "groupHeader";
    public static final String HEADER_FACET = "header";
    public static final String TABLE_COLUMN_FOOTER_BAR_ID = "_tableColumnFooterBar";
    private int columnCount = -1;
    private boolean paginated = false;
    private boolean paginated_set = false;
    private Table tableAncestor = null;
    private boolean aboveColumnFooter = false;
    private boolean aboveColumnFooter_set = false;
    private boolean aboveColumnHeader = false;
    private boolean aboveColumnHeader_set = false;
    private String extraFooterHtml = null;
    private String extraHeaderHtml = null;
    private String footerText = null;
    private boolean multipleColumnFooters = false;
    private boolean multipleColumnFooters_set = false;
    private boolean multipleTableColumnFooters = false;
    private boolean multipleTableColumnFooters_set = false;

    public TableRowGroup() {
        this.setRendererType("com.sun.webui.jsf.TableRowGroup");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.TableRowGroup";
    }

    public void clear() {
        this.tableAncestor = null;
        this.columnCount = -1;
        super.clear();
    }

    public Table getTableAncestor() {
        if (this.tableAncestor == null) {
            UIComponent component = this;
            while (component != null) {
                if (!((component = ((UIComponent)component).getParent()) instanceof Table)) continue;
                this.tableAncestor = (Table)component;
                break;
            }
        }
        return this.tableAncestor;
    }

    public int getColumnCount() {
        if (this.columnCount == -1) {
            this.columnCount = 0;
            Iterator kids = this.getTableColumnChildren();
            while (kids.hasNext()) {
                TableColumn col = (TableColumn)kids.next();
                this.columnCount += col.getColumnCount();
            }
        }
        return this.columnCount;
    }

    public UIComponent getEmptyDataColumn() {
        UIComponent facet = this.getFacet(EMPTY_DATA_COLUMN_FACET);
        if (facet != null) {
            return facet;
        }
        TableColumn child = new TableColumn();
        child.setId(EMPTY_DATA_COLUMN_ID);
        child.setColSpan(this.getColumnCount());
        child.getChildren().add(this.getEmptyDataText());
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getEmptyDataText() {
        RowKey[] rowKeys;
        UIComponent facet = this.getFacet(EMPTY_DATA_TEXT_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = this.getTheme();
        String msg = null;
        msg = this.getEmptyDataMsg() != null ? this.getEmptyDataMsg() : ((rowKeys = this.getRowKeys()) != null && rowKeys.length > 0 ? theme.getMessage("table.filteredData") : theme.getMessage("table.emptyData"));
        StaticText child = new StaticText();
        child.setId(EMPTY_DATA_TEXT_ID);
        child.setStyleClass(theme.getStyleClass("TABLE_MESSAGE_TEXT"));
        child.setText(msg);
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getGroupFooter() {
        UIComponent facet = this.getFacet(GROUP_FOOTER_FACET);
        if (facet != null) {
            return facet;
        }
        TableFooter child = new TableFooter();
        child.setId(GROUP_FOOTER_ID);
        child.setColSpan(this.getColumnCount());
        child.setExtraHtml(this.getExtraFooterHtml());
        child.setGroupFooter(true);
        facet = this.getFacet(FOOTER_FACET);
        if (!(facet != null && facet.isRendered() || this.getFooterText() != null)) {
            child.setRendered(false);
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getGroupHeader() {
        UIComponent facet = this.getFacet(GROUP_HEADER_FACET);
        if (facet != null) {
            return facet;
        }
        TableHeader child = new TableHeader();
        child.setId(GROUP_HEADER_ID);
        child.setScope("colgroup");
        child.setColSpan(this.getColumnCount());
        child.setExtraHtml(this.getExtraHeaderHtml());
        child.setGroupHeader(true);
        boolean emptyTable = this.getRowCount() == 0;
        boolean renderControls = !emptyTable && (this.isSelectMultipleToggleButton() || this.isGroupToggleButton());
        facet = this.getFacet(HEADER_FACET);
        if (!(facet != null && facet.isRendered() || this.getHeaderText() != null || renderControls)) {
            child.setRendered(false);
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public int getFirst() {
        int last = this.getLast();
        int first = this.isPaginated() ? super.getFirst() : 0;
        return first < last ? first : last;
    }

    public int getPage() {
        if (!this.isPaginated()) {
            return 1;
        }
        return super.getPage();
    }

    public boolean isPaginated() {
        Table table;
        if (!this.paginated_set && (table = this.getTableAncestor()) != null) {
            this.setPaginated(table.isPaginationControls());
        }
        return this.paginated;
    }

    public void setPaginated(boolean paginated) {
        this.paginated = paginated;
        this.paginated_set = true;
    }

    public int getRows() {
        return this.isPaginated() ? super.getRows() : 0;
    }

    public RowKey[] getHiddenRowKeys() {
        if (!this.isPaginated()) {
            return null;
        }
        return super.getHiddenRowKeys();
    }

    public RowKey[] getRenderedRowKeys() {
        RowKey[] rowKeys = this.getSortedRowKeys();
        if (rowKeys == null) {
            return rowKeys;
        }
        ArrayList<RowKey> list = new ArrayList<RowKey>();
        int first = this.getFirst();
        int rows = this.getRows();
        for (int i = first; !(i >= rowKeys.length || this.isPaginated() && i >= first + rows); ++i) {
            list.add(rowKeys[i]);
        }
        rowKeys = new RowKey[list.size()];
        return list.toArray(rowKeys);
    }

    public void processUpdates(FacesContext context) {
        UIComponent field;
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        UIComponent header = this.getFacet(GROUP_HEADER_ID);
        UIComponent uIComponent = field = header != null ? header.getFacets().get("_collapsedHiddenField") : null;
        if (field instanceof HiddenField) {
            Boolean value = field != null ? (Boolean)((HiddenField)field).getText() : null;
            this.setCollapsed(value);
        }
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(this.getFacesContext());
    }

    public boolean isAboveColumnFooter() {
        if (this.aboveColumnFooter_set) {
            return this.aboveColumnFooter;
        }
        ValueExpression _vb = this.getValueExpression("aboveColumnFooter");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setAboveColumnFooter(boolean aboveColumnFooter) {
        this.aboveColumnFooter = aboveColumnFooter;
        this.aboveColumnFooter_set = true;
    }

    public boolean isAboveColumnHeader() {
        if (this.aboveColumnHeader_set) {
            return this.aboveColumnHeader;
        }
        ValueExpression _vb = this.getValueExpression("aboveColumnHeader");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setAboveColumnHeader(boolean aboveColumnHeader) {
        this.aboveColumnHeader = aboveColumnHeader;
        this.aboveColumnHeader_set = true;
    }

    public String getExtraFooterHtml() {
        if (this.extraFooterHtml != null) {
            return this.extraFooterHtml;
        }
        ValueExpression _vb = this.getValueExpression("extraFooterHtml");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setExtraFooterHtml(String extraFooterHtml) {
        this.extraFooterHtml = extraFooterHtml;
    }

    public String getExtraHeaderHtml() {
        if (this.extraHeaderHtml != null) {
            return this.extraHeaderHtml;
        }
        ValueExpression _vb = this.getValueExpression("extraHeaderHtml");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setExtraHeaderHtml(String extraHeaderHtml) {
        this.extraHeaderHtml = extraHeaderHtml;
    }

    public String getFooterText() {
        if (this.footerText != null) {
            return this.footerText;
        }
        ValueExpression _vb = this.getValueExpression("footerText");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setFooterText(String footerText) {
        this.footerText = footerText;
    }

    public boolean isMultipleColumnFooters() {
        if (this.multipleColumnFooters_set) {
            return this.multipleColumnFooters;
        }
        ValueExpression _vb = this.getValueExpression("multipleColumnFooters");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setMultipleColumnFooters(boolean multipleColumnFooters) {
        this.multipleColumnFooters = multipleColumnFooters;
        this.multipleColumnFooters_set = true;
    }

    public boolean isMultipleTableColumnFooters() {
        if (this.multipleTableColumnFooters_set) {
            return this.multipleTableColumnFooters;
        }
        ValueExpression _vb = this.getValueExpression("multipleTableColumnFooters");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setMultipleTableColumnFooters(boolean multipleTableColumnFooters) {
        this.multipleTableColumnFooters = multipleTableColumnFooters;
        this.multipleTableColumnFooters_set = true;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] _values = (Object[])state;
        super.restoreState(context, _values[0]);
        this.aboveColumnFooter = (Boolean)_values[1];
        this.aboveColumnFooter_set = (Boolean)_values[2];
        this.aboveColumnHeader = (Boolean)_values[3];
        this.aboveColumnHeader_set = (Boolean)_values[4];
        this.extraFooterHtml = (String)_values[5];
        this.extraHeaderHtml = (String)_values[6];
        this.footerText = (String)_values[7];
        this.multipleColumnFooters = (Boolean)_values[8];
        this.multipleColumnFooters_set = (Boolean)_values[9];
        this.multipleTableColumnFooters = (Boolean)_values[10];
        this.multipleTableColumnFooters_set = (Boolean)_values[11];
        this.setPaginated((Boolean)_values[12]);
    }

    public Object saveState(FacesContext context) {
        Object[] _values = new Object[]{super.saveState(context), this.aboveColumnFooter ? Boolean.TRUE : Boolean.FALSE, this.aboveColumnFooter_set ? Boolean.TRUE : Boolean.FALSE, this.aboveColumnHeader ? Boolean.TRUE : Boolean.FALSE, this.aboveColumnHeader_set ? Boolean.TRUE : Boolean.FALSE, this.extraFooterHtml, this.extraHeaderHtml, this.footerText, this.multipleColumnFooters ? Boolean.TRUE : Boolean.FALSE, this.multipleColumnFooters_set ? Boolean.TRUE : Boolean.FALSE, this.multipleTableColumnFooters ? Boolean.TRUE : Boolean.FALSE, this.multipleTableColumnFooters_set ? Boolean.TRUE : Boolean.FALSE, this.isPaginated() ? Boolean.TRUE : Boolean.FALSE};
        return _values;
    }
}

